/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.core.handlers.SearchValidator;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SearchValidatorTest {
    @Test
    public void testPositive() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "foobarfoo");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    @Test
    public void testNegative() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "foooo");
        Assertions.assertThat((boolean)request.isValid()).isFalse();
    }

    @Test
    public void testStart() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "barfoo");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    @Test
    public void testEnd() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "foobar");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    @Test
    public void testSplit() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "foob", "arfoo");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    @Test
    public void testMany() {
        SearchValidator validator = new SearchValidator("bar", m -> m == 3);
        HttpRequest request = this.runValidator(validator, "foob", "arfoob", "a", "rfooba", "rfoo");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    @Test
    public void testOverlapping() {
        SearchValidator validator = new SearchValidator("barbar", m -> m == 1);
        HttpRequest request = this.runValidator(validator, "barbarbar");
        Assertions.assertThat((boolean)request.isValid()).isTrue();
    }

    private HttpRequest runValidator(SearchValidator validator, String ... text) {
        Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
        ResourceUtilizer.reserveForTesting((Session)session, (Object)validator);
        HttpRunData.initForTesting((Session)session);
        HttpRequest request = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
        request.start(new SequenceInstance(), null);
        session.currentRequest((Request)request);
        validator.before(session);
        for (String t : text) {
            ByteBuf data = Unpooled.wrappedBuffer((byte[])t.getBytes(StandardCharsets.UTF_8));
            validator.process(session, data, data.readerIndex(), data.readableBytes(), false);
        }
        validator.after(session);
        return request;
    }
}

