/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.statistics.HttpStats;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class EmbeddedResourcesTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.route().handler(ctx -> {
            ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
            ctx.next();
        });
        this.router.route("/foobar/index.html").handler(ctx -> this.serveResourceChunked((RoutingContext)ctx, "data/EmbeddedResourcesTest_index.html"));
        this.router.route("/styles/style.css").handler(ctx -> ctx.response().end("You've got style!"));
        this.router.route("/foobar/stuff.js").handler(ctx -> ctx.response().end("alert('Hello world!')"));
        this.router.route("/generate.php").handler(ctx -> ctx.response().end());
    }

    @Test
    public void test() {
        Benchmark benchmark = this.loadScenario("scenarios/EmbeddedResourcesTest.hf.yaml");
        Map stats = this.runScenario(benchmark);
        Assertions.assertThat((int)stats.size()).isEqualTo(6);
        for (Map.Entry entry : stats.entrySet()) {
            int hits;
            String name = (String)entry.getKey();
            if (name.equals("automatic") || name.equals("manual") || name.equals("legacy")) {
                hits = 1;
            } else {
                Assertions.assertThat((String)name).matches((CharSequence)".*\\.(css|js|ico|php)");
                hits = 3;
            }
            StatisticsSnapshot snapshot = (StatisticsSnapshot)entry.getValue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)snapshot.requestCount).as(name, new Object[0])).isEqualTo(hits);
            ((AbstractIntegerAssert)Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot).status_2xx).as(name, new Object[0])).isEqualTo(hits);
        }
    }
}

