/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.core.handlers.ExpectProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.html.HtmlHandler;
import io.hyperfoil.http.html.MetaRefreshHandler;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.junit.Test;

public class MetaRefreshHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        HtmlHandler.Builder html = new HtmlHandler.Builder();
        ExpectProcessor expect = new ExpectProcessor();
        html.handler((HtmlHandler.TagHandlerBuilder)new MetaRefreshHandler.Builder().processor(fragmented -> expect)).prepareBuild();
        HtmlHandler handler = html.build(true);
        Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
        HttpRunData.initForTesting((Session)session);
        ResourceUtilizer.reserveForTesting((Session)session, (Object)handler);
        handler.before(session);
        ByteBuf content1 = this.buf("content1");
        ByteBuf content2 = this.buf("content2");
        ByteBuf content5 = this.buf("content5");
        try {
            expect.expect(content1);
            this.sendChunk(handler, session, "<html><head><me");
            this.sendChunk(handler, session, "ta Http-equiv=\"refresh");
            this.sendChunk(handler, session, "\" content=\"");
            this.sendChunk(handler, session, "content1\" /><META");
            expect.expect(content2);
            this.sendChunk(handler, session, " content=\"content2\" foo=\"bar\" http-equiv=");
            this.sendChunk(handler, session, "\"Ref");
            this.sendChunk(handler, session, "resh\"></meta>");
            this.sendChunk(handler, session, "  <meta");
            this.sendChunk(handler, session, "META http-equiv=\"refresh\" content=\"content3\"/>");
            this.sendChunk(handler, session, "<!-- --><mETA http-equiv=\"whatever\" content=\"content4\" />");
            this.sendChunk(handler, session, "<mETA http-equiv=\"whatever\" content=\"content4\" />");
            expect.expect(content5);
            this.sendChunk(handler, session, "<meta content=\"content5\" http-equiv=\"refresh\" /></head></html>");
            handler.process(session, ByteBufAllocator.DEFAULT.buffer(0, 0), 0, 0, true);
            handler.after(session);
            expect.validate();
        }
        finally {
            content1.release();
            content2.release();
            content5.release();
        }
    }

    protected void sendChunk(HtmlHandler handler, Session session, String string) {
        ByteBuf buf = this.buf(string);
        handler.process(session, buf, buf.readerIndex(), buf.readableBytes(), false);
        buf.release();
    }

    private ByteBuf buf(String string) {
        return Util.string2byteBuf((CharSequence)string, (ByteBuf)ByteBufAllocator.DEFAULT.buffer());
    }
}

