/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.statistics;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ErrorRatioTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.get("/get200").handler(ctx -> ctx.response().setStatusCode(200).end());
        this.router.get("/get400").handler(ctx -> ctx.response().setStatusCode(400).end());
        this.router.get("/close").handler(ctx -> ctx.response().close());
    }

    @Test
    public void test400(TestContext ctx) {
        ((HttpStepCatalog)this.scenario().initialSequence("400").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/get400").handler().onCompletion(this.validateConnection(ctx)).endHandler().endStep();
        StatisticsSnapshot stats = (StatisticsSnapshot)this.runScenario().get("400");
        HttpStats http = HttpStats.get((StatisticsSnapshot)stats);
        Assertions.assertThat((int)stats.requestCount).isEqualTo(1);
        Assertions.assertThat((int)stats.responseCount).isEqualTo(1);
        Assertions.assertThat((int)http.status_4xx).isEqualTo(1);
        Assertions.assertThat((int)stats.connectionErrors).isEqualTo(0);
        Assertions.assertThat((int)stats.invalid).isEqualTo(1);
        Assertions.assertThat((int)http.cacheHits).isEqualTo(0);
        Assertions.assertThat((long)stats.errors()).isEqualTo(0L);
    }

    protected Action validateConnection(TestContext ctx) {
        return (Action & Serializable)session -> {};
    }

    @Test
    public void testClose() {
        ((HttpStepCatalog)this.scenario().initialSequence("close").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/close").endStep();
        StatisticsSnapshot stats = (StatisticsSnapshot)this.runScenario().get("close");
        Assertions.assertThat((int)stats.requestCount).isEqualTo(1);
        Assertions.assertThat((int)stats.responseCount).isEqualTo(0);
        Assertions.assertThat((int)stats.connectionErrors).isEqualTo(1);
        Assertions.assertThat((int)stats.invalid).isEqualTo(1);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)stats).cacheHits).isEqualTo(0);
        Assertions.assertThat((long)stats.errors()).isEqualTo(1L);
    }

    @Test
    public void testThrowInBodyHandler() {
        ((HttpStepCatalog)this.scenario().initialSequence("throw").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/get200").handler().body(fragmented -> (Processor & Serializable)(session, data, offset, length, isLastPart) -> {
            throw new RuntimeException("Induced failure");
        }).endHandler().endStep();
        StatisticsSnapshot stats = (StatisticsSnapshot)this.runScenario().get("throw");
        HttpStats http = HttpStats.get((StatisticsSnapshot)stats);
        Assertions.assertThat((int)stats.requestCount).isEqualTo(1);
        Assertions.assertThat((int)stats.responseCount).isEqualTo(0);
        Assertions.assertThat((int)http.status_2xx).isEqualTo(1);
        Assertions.assertThat((int)stats.invalid).isEqualTo(1);
        Assertions.assertThat((int)http.cacheHits).isEqualTo(0);
        Assertions.assertThat((int)stats.connectionErrors).isEqualTo(0);
        Assertions.assertThat((int)stats.internalErrors).isEqualTo(1);
        Assertions.assertThat((long)stats.errors()).isEqualTo(1L);
    }

    @Test
    public void testThrowInCompletionHandler() {
        ((HttpStepCatalog)this.scenario().initialSequence("throw").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/get200").handler().onCompletion(() -> (Action & Serializable)session -> {
            throw new RuntimeException("Induced failure");
        }).endHandler().endStep();
        StatisticsSnapshot stats = (StatisticsSnapshot)this.runScenario().get("throw");
        HttpStats http = HttpStats.get((StatisticsSnapshot)stats);
        Assertions.assertThat((int)stats.requestCount).isEqualTo(1);
        Assertions.assertThat((int)stats.responseCount).isEqualTo(1);
        Assertions.assertThat((int)http.status_2xx).isEqualTo(1);
        Assertions.assertThat((int)stats.invalid).isEqualTo(1);
        Assertions.assertThat((int)http.cacheHits).isEqualTo(0);
        Assertions.assertThat((int)stats.connectionErrors).isEqualTo(0);
        Assertions.assertThat((int)stats.internalErrors).isEqualTo(1);
        Assertions.assertThat((long)stats.errors()).isEqualTo(1L);
    }
}

