/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.statistics;

import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.core.metric.MetricSelector;
import io.hyperfoil.core.metric.PathMetricSelector;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class PathMetricsTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.route("/foo.js").handler(ctx -> ctx.response().setStatusCode(200).end());
        this.router.route("/bar.php").handler(ctx -> ctx.response().setStatusCode(200).end());
        this.router.route("/goo.css").handler(ctx -> ctx.response().setStatusCode(200).end());
    }

    @Test
    public void test() {
        AtomicInteger counter = new AtomicInteger(0);
        PathMetricSelector selector = new PathMetricSelector();
        selector.nextItem(".*\\.js");
        selector.nextItem("(.*\\.php).* -> $1");
        selector.nextItem("-> others");
        ((HttpStepCatalog)this.scenario(3).initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path((SerializableFunction & Serializable)s -> {
            switch (counter.getAndIncrement()) {
                case 0: {
                    return "/foo.js";
                }
                case 1: {
                    return "/bar.php?foo=bar";
                }
                case 2: {
                    return "/goo.css";
                }
            }
            throw new IllegalStateException();
        }).metric((MetricSelector)selector).endStep();
        Map stats = this.runScenario();
        Assertions.assertThat((int)((StatisticsSnapshot)stats.get((Object)"/foo.js")).requestCount).isEqualTo(1);
        Assertions.assertThat((int)((StatisticsSnapshot)stats.get((Object)"/bar.php")).requestCount).isEqualTo(1);
        Assertions.assertThat((int)((StatisticsSnapshot)stats.get((Object)"others")).requestCount).isEqualTo(1);
    }
}

