/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.core.steps.SetAction;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.handlers.RangeStatusValidator;
import io.hyperfoil.http.handlers.RecordHeaderTimeHandler;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HttpRequestTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.route().handler((Handler)BodyHandler.create());
        this.router.post("/test").handler(ctx -> {
            String expect = ctx.request().getParam("expect");
            String body = ctx.getBodyAsString();
            if (expect == null) {
                ctx.response().setStatusCode(400).end();
                return;
            }
            ctx.response().setStatusCode(expect.equals(body) ? 200 : 412).end();
        });
        this.router.get("/status").handler(ctx -> {
            String s = ctx.request().getParam("s");
            ctx.response().setStatusCode(Integer.parseInt(s)).end();
        });
        this.router.get("/test").handler(ctx -> {
            ctx.response().putHeader("x-foo", "5");
            String expectHeader = ctx.request().getParam("expectHeader");
            if (expectHeader != null) {
                String[] headerValue = expectHeader.split(":", 2);
                String actualValue = ctx.request().getHeader(headerValue[0]);
                ctx.response().setStatusCode(Objects.equals(actualValue, headerValue[1]) ? 200 : 412);
            }
            ctx.response().end();
        });
    }

    private StatusHandler verifyStatus(TestContext ctx) {
        return (StatusHandler & Serializable)(request, status) -> {
            if (status != 200) {
                ctx.fail("Status is " + status);
            }
        };
    }

    @Test
    public void testStringBody(TestContext ctx) {
        ((HttpStepCatalog)this.scenario(10).initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.POST).path("/test?expect=bar").body("bar").handler().status(this.verifyStatus(ctx)).endHandler().endStep();
        this.runScenario();
    }

    @Test
    public void testStringFromVar(TestContext ctx) {
        ((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).action((Action.Builder)new SetAction.Builder().var("x").value("bar")).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.POST).path("/test?expect=bar").body().fromVar("x").endBody().handler().status(this.verifyStatus(ctx)).endHandler().endStep();
        this.runScenario();
    }

    @Test
    public void testLongChineseStringFromVar(TestContext ctx) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 257; ++i) {
            sb.append((char)random.nextInt(19968, 40869));
        }
        String chineseStr = sb.toString();
        ((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).action((Action.Builder)new SetAction.Builder().var("x").value(chineseStr)).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.POST).path("/test?expect=" + URLEncoder.encode(chineseStr, StandardCharsets.UTF_8.name())).body().fromVar("x").endBody().handler().status(this.verifyStatus(ctx)).endHandler().endStep();
        this.runScenario();
    }

    @Test
    public void testPattern(TestContext ctx) {
        ((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).action((Action.Builder)new SetAction.Builder().var("x").value("bar")).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.POST).path("/test?expect=${x}").body("bar").handler().status(this.verifyStatus(ctx)).endHandler().endStep();
        this.runScenario();
    }

    @Test
    public void testStatusValidator() {
        ((HttpPluginBuilder)((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("expectOK").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/status?s=205").handler().status((StatusHandler)new RangeStatusValidator(205, 205)).endHandler().endStep().endSequence().initialSequence("expectFail").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/status?s=406").handler().status((StatusHandler)new RangeStatusValidator(200, 299)).endHandler().endStep().endSequence().endScenario().endPhase().plugin(HttpPluginBuilder.class)).ergonomics().autoRangeCheck(false).stopOnInvalid(false);
        Map stats = this.runScenario();
        StatisticsSnapshot snapshot0 = (StatisticsSnapshot)stats.get("expectOK");
        StatisticsSnapshot snapshot1 = (StatisticsSnapshot)stats.get("expectFail");
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot0).status_2xx).isEqualTo(1);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot0).status_4xx).isEqualTo(0);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot1).status_2xx).isEqualTo(0);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot1).status_4xx).isEqualTo(1);
        Assertions.assertThat((int)snapshot0.invalid).isEqualTo(0);
        Assertions.assertThat((int)snapshot1.invalid).isEqualTo(1);
    }

    @Test
    public void testRecordHeaderValueHandler() {
        ((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test").handler().header((HeaderHandler.Builder)new RecordHeaderTimeHandler.Builder().header("x-foo").unit("ms")).endHandler().endStep().endSequence();
        Map stats = this.runScenario();
        Assertions.assertThat((int)((StatisticsSnapshot)stats.get((Object)"test")).requestCount).isEqualTo(1);
        Assertions.assertThat((long)((StatisticsSnapshot)stats.get((Object)"x-foo")).histogram.getCountAtValue(TimeUnit.MILLISECONDS.toNanos(5L))).isEqualTo(1L);
    }

    @Test
    public void testRequestHeaders() {
        ((HttpStepCatalog)((HttpStepCatalog)((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("testFromVar").step(HttpStepCatalog.SC)).action((Action.Builder)new SetAction.Builder().var("foo").value("bar")).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test?expectHeader=Authorization:bar").headers().withKey("Authorization").fromVar("foo").end().endHeaders().endStep().endSequence().initialSequence("testPattern").step(HttpStepCatalog.SC)).action((Action.Builder)new SetAction.Builder().var("foo").value("bar")).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test?expectHeader=Authorization:xxxbarxxx").headers().withKey("Authorization").pattern("xxx${foo}xxx").end().endHeaders().endStep().endSequence();
        Map stats = this.runScenario();
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get((Object)"testFromVar"))).status_2xx).isEqualTo(1);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get((Object)"testPattern"))).status_2xx).isEqualTo(1);
    }
}

