/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.api.PluginRunData;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.http.HttpCacheImpl;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpPluginConfig;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.connection.HttpDestinationTableImpl;
import io.hyperfoil.http.connection.SessionConnectionPool;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLException;

public class HttpRunData
implements PluginRunData {
    private final HttpPluginConfig plugin;
    private final HttpDestinationTableImpl[] destinations;
    private final Map<String, HttpClientPool> clientPools = new HashMap<String, HttpClientPool>();
    private final boolean hasSessionPools;
    private final boolean hasHttpCacheEnabled;

    public HttpRunData(Benchmark benchmark, EventLoop[] executors, int agentId) {
        this.plugin = (HttpPluginConfig)benchmark.plugin(HttpPluginConfig.class);
        this.hasHttpCacheEnabled = this.plugin.http().values().stream().anyMatch(Http::enableHttpCache);
        this.hasSessionPools = this.plugin.http().values().stream().anyMatch(http -> http.connectionStrategy() != ConnectionStrategy.SHARED_POOL);
        Map[] connectionPools = new Map[executors.length];
        this.destinations = new HttpDestinationTableImpl[executors.length];
        for (Map.Entry<String, Http> http2 : this.plugin.http().entrySet()) {
            try {
                HttpClientPoolImpl httpClientPool = new HttpClientPoolImpl(http2.getValue(), executors, benchmark, agentId);
                this.clientPools.put(http2.getKey(), httpClientPool);
                if (http2.getValue().isDefault()) {
                    this.clientPools.put(null, httpClientPool);
                }
                for (int executorId = 0; executorId < executors.length; ++executorId) {
                    HttpConnectionPool httpConnectionPool = httpClientPool.connectionPool((EventExecutor)executors[executorId]);
                    HashMap<String, HttpConnectionPool> pools = connectionPools[executorId];
                    if (pools == null) {
                        connectionPools[executorId] = pools = new HashMap<String, HttpConnectionPool>();
                    }
                    pools.put(http2.getKey(), httpConnectionPool);
                    if (!http2.getValue().isDefault()) continue;
                    pools.put(null, httpConnectionPool);
                }
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed creating connection pool to " + http2.getValue().host() + ":" + http2.getValue().port(), e);
            }
        }
        for (int executorId = 0; executorId < connectionPools.length; ++executorId) {
            Map pools = connectionPools[executorId];
            this.destinations[executorId] = new HttpDestinationTableImpl(pools);
        }
    }

    public static void initForTesting(Session session) {
        HttpRunData.initForTesting(session, Clock.systemDefaultZone(), true);
    }

    public static void initForTesting(Session session, Clock clock, boolean cacheEnabled) {
        Scenario dummyScenario = new Scenario(new Sequence[0], new Sequence[0], 16, 16);
        session.declareSingletonResource(HttpDestinationTable.KEY, (Session.Resource)new HttpDestinationTableImpl(Collections.emptyMap()));
        if (cacheEnabled) {
            session.declareSingletonResource(HttpCache.KEY, (Session.Resource)new HttpCacheImpl(clock));
        }
        session.declareSingletonResource(HttpRequestPool.KEY, (Session.Resource)new HttpRequestPool(dummyScenario, session, cacheEnabled));
    }

    public void initSession(Session session, int executorId, Scenario scenario, Clock clock) {
        HttpDestinationTableImpl destinations = this.destinations[executorId];
        if (this.hasSessionPools) {
            destinations = new HttpDestinationTableImpl(destinations, pool -> {
                ConnectionStrategy strategy = pool.clientPool().config().connectionStrategy();
                switch (strategy) {
                    case SHARED_POOL: 
                    case ALWAYS_NEW: {
                        return pool;
                    }
                    case SESSION_POOLS: 
                    case OPEN_ON_REQUEST: {
                        return new SessionConnectionPool((HttpConnectionPool)pool, scenario.maxRequests());
                    }
                }
                throw new IllegalStateException();
            });
        }
        session.declareSingletonResource(HttpDestinationTable.KEY, (Session.Resource)destinations);
        if (this.hasHttpCacheEnabled) {
            session.declareSingletonResource(HttpCache.KEY, (Session.Resource)new HttpCacheImpl(clock));
        }
        session.declareSingletonResource(HttpRequestPool.KEY, (Session.Resource)new HttpRequestPool(scenario, session, this.hasHttpCacheEnabled));
    }

    public void openConnections(Function<Callable<Void>, Future<Void>> blockingHandler, Consumer<Future<Void>> promiseCollector) {
        for (Map.Entry<String, HttpClientPool> entry : this.clientPools.entrySet()) {
            if (entry.getKey() == null) continue;
            Promise promise = Promise.promise();
            promiseCollector.accept((Future<Void>)promise.future());
            entry.getValue().start((Handler<AsyncResult<Void>>)promise);
        }
    }

    public void listConnections(Consumer<String> connectionCollector) {
        for (HttpDestinationTableImpl destinations : this.destinations) {
            for (Map.Entry<String, HttpConnectionPool> entry : destinations.iterable()) {
                if (entry.getKey() == null) continue;
                HttpConnectionPool pool = entry.getValue();
                Collection<? extends HttpConnection> connections = pool.connections();
                HashMap<String, AtomicInteger> byType = new HashMap<String, AtomicInteger>();
                int available = 0;
                int inFlight = 0;
                for (HttpConnection httpConnection : connections) {
                    if (httpConnection.isAvailable()) {
                        ++available;
                    }
                    inFlight += httpConnection.inFlight();
                    byType.computeIfAbsent(httpConnection.getClass().getSimpleName() + (httpConnection.isSecure() ? "(SSL)" : ""), k -> new AtomicInteger()).incrementAndGet();
                }
                connectionCollector.accept(String.format("%s: %d/%d available, %d in-flight requests, %d waiting sessions (estimate), types: %s", entry.getKey(), available, connections.size(), inFlight, pool.waitingSessions(), byType));
            }
        }
    }

    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
        for (Map.Entry<String, HttpClientPool> entry : this.clientPools.entrySet()) {
            if (entry.getKey() == null) continue;
            entry.getValue().visitConnectionStats(consumer);
        }
    }

    public void shutdown() {
        for (HttpClientPool pool : this.clientPools.values()) {
            pool.shutdown();
        }
    }
}

