/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.config.ConnectionPoolConfig;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class HttpBuilder
implements BuilderBase<HttpBuilder> {
    private final HttpPluginBuilder parent;
    private String name;
    private Http http;
    private String originalDestination;
    private Protocol protocol;
    private String host;
    private int port = -1;
    private List<String> addresses = new ArrayList<String>();
    private boolean allowHttp1x = true;
    private boolean allowHttp2 = true;
    private ConnectionPoolConfig.Builder sharedConnections = new ConnectionPoolConfig.Builder(this);
    private int maxHttp2Streams = 100;
    private int pipeliningLimit = 1;
    private boolean directHttp2 = false;
    private long requestTimeout = 30000L;
    private boolean rawBytesHandlers = true;
    private KeyManagerBuilder keyManager = new KeyManagerBuilder(this);
    private TrustManagerBuilder trustManager = new TrustManagerBuilder(this);
    private ConnectionStrategy connectionStrategy = ConnectionStrategy.SHARED_POOL;
    private boolean useHttpCache = true;

    public static HttpBuilder forTesting() {
        return new HttpBuilder(null);
    }

    public HttpBuilder(HttpPluginBuilder parent) {
        this.parent = parent;
    }

    public HttpBuilder name(String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    String authority() {
        if (this.host() == null) {
            return null;
        }
        if (this.port == -1) {
            return this.host();
        }
        return this.host() + ":" + this.portOrDefault();
    }

    public HttpBuilder protocol(Protocol protocol) {
        if (this.protocol != null) {
            throw new BenchmarkDefinitionException("Duplicate 'protocol'");
        }
        this.protocol = protocol;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public int portOrDefault() {
        if (this.port != -1) {
            return this.port;
        }
        if (this.protocol != null) {
            return this.protocol.portOrDefault(this.port);
        }
        throw new BenchmarkDefinitionException("No port nor protocol has been defined");
    }

    public HttpBuilder host(String destination) {
        URL result;
        Object spec;
        if (this.host != null) {
            throw new BenchmarkDefinitionException("Duplicate 'host'. Are you missing '-'s?");
        }
        int schemeEnd = destination.indexOf("://");
        if (schemeEnd < 0) {
            spec = "http://" + destination;
            this.originalDestination = destination;
        } else {
            spec = destination;
            this.originalDestination = destination.substring(schemeEnd + 3);
        }
        try {
            result = new URL((String)spec);
        }
        catch (MalformedURLException e) {
            throw new BenchmarkDefinitionException("Failed to parse host:port", (Throwable)e);
        }
        URL url = result;
        this.protocol = this.protocol == null ? Protocol.fromScheme(url.getProtocol()) : this.protocol;
        this.host = url.getHost();
        this.port = url.getPort();
        if (url.getFile() != null && !url.getFile().isEmpty()) {
            throw new BenchmarkDefinitionException("Host must not contain any path: " + destination);
        }
        return this;
    }

    public HttpBuilder port(int port) {
        if (this.port > 0) {
            throw new BenchmarkDefinitionException("Duplicate 'port'");
        }
        this.port = port;
        return this;
    }

    public HttpBuilder allowHttp1x(boolean allowHttp1x) {
        this.allowHttp1x = allowHttp1x;
        return this;
    }

    public HttpBuilder allowHttp2(boolean allowHttp2) {
        this.allowHttp2 = allowHttp2;
        return this;
    }

    public HttpPluginBuilder endHttp() {
        return this.parent;
    }

    public HttpBuilder sharedConnections(int sharedConnections) {
        this.sharedConnections.core(sharedConnections).max(sharedConnections).buffer(0).keepAliveTime(0L);
        return this;
    }

    public ConnectionPoolConfig.Builder sharedConnections() {
        return this.sharedConnections;
    }

    public HttpBuilder maxHttp2Streams(int maxStreams) {
        this.maxHttp2Streams = maxStreams;
        return this;
    }

    public HttpBuilder pipeliningLimit(int limit) {
        this.pipeliningLimit = limit;
        return this;
    }

    public HttpBuilder directHttp2(boolean directHttp2) {
        this.directHttp2 = directHttp2;
        return this;
    }

    public HttpBuilder requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HttpBuilder requestTimeout(String requestTimeout) {
        this.requestTimeout = "none".equals(requestTimeout) ? -1L : Util.parseToMillis((String)requestTimeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public HttpBuilder addAddress(String address) {
        this.addresses.add(address);
        return this;
    }

    public HttpBuilder rawBytesHandlers(boolean rawBytesHandlers) {
        this.rawBytesHandlers = rawBytesHandlers;
        return this;
    }

    public KeyManagerBuilder keyManager() {
        return this.keyManager;
    }

    public TrustManagerBuilder trustManager() {
        return this.trustManager;
    }

    public HttpBuilder connectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
        return this;
    }

    public ConnectionStrategy connectionStrategy() {
        return this.connectionStrategy;
    }

    public HttpBuilder useHttpCache(boolean useHttpCache) {
        this.useHttpCache = useHttpCache;
        return this;
    }

    public boolean useHttpCache() {
        return this.useHttpCache;
    }

    public void prepareBuild() {
    }

    public Http build(boolean isDefault) {
        if (this.http != null) {
            if (isDefault != this.http.isDefault()) {
                throw new IllegalArgumentException("Already built as isDefault=" + this.http.isDefault());
            }
            return this.http;
        }
        ArrayList<HttpVersion> httpVersions = new ArrayList<HttpVersion>();
        if (this.allowHttp2) {
            httpVersions.add(HttpVersion.HTTP_2_0);
        }
        if (this.allowHttp1x) {
            httpVersions.add(HttpVersion.HTTP_1_1);
            httpVersions.add(HttpVersion.HTTP_1_0);
        }
        if (this.directHttp2) {
            throw new UnsupportedOperationException("Direct HTTP/2 not implemented");
        }
        if (this.originalDestination == null) {
            this.originalDestination = this.host;
            if (this.port >= 0) {
                this.originalDestination = this.originalDestination + ":" + this.port;
            }
        }
        Protocol protocol = this.protocol != null ? this.protocol : Protocol.fromPort(this.port);
        this.http = new Http(this.name, isDefault, this.originalDestination, protocol, this.host, protocol.portOrDefault(this.port), this.addresses.toArray(new String[0]), httpVersions.toArray(new HttpVersion[0]), this.maxHttp2Streams, this.pipeliningLimit, this.sharedConnections.build(), this.directHttp2, this.requestTimeout, this.rawBytesHandlers, this.keyManager.build(), this.trustManager.build(), this.connectionStrategy, this.useHttpCache);
        return this.http;
    }

    private static byte[] readBytes(String filename) throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            if (stream != null) {
                byte[] byArray = Util.toByteArray((InputStream)stream);
                return byArray;
            }
        }
        return Files.readAllBytes(Paths.get(filename, new String[0]));
    }

    public static class KeyManagerBuilder
    implements BuilderBase<KeyManagerBuilder> {
        private final HttpBuilder parent;
        private String storeType = "JKS";
        private byte[] storeBytes;
        private String password;
        private String alias;
        private byte[] certBytes;
        private byte[] keyBytes;

        public KeyManagerBuilder(HttpBuilder parent) {
            this.parent = parent;
        }

        public KeyManagerBuilder storeType(String type) {
            this.storeType = type;
            return this;
        }

        public KeyManagerBuilder storeFile(String filename) {
            try {
                this.storeBytes = HttpBuilder.readBytes(filename);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read key store file " + filename, (Throwable)e);
            }
            return this;
        }

        public KeyManagerBuilder storeBytes(byte[] storeBytes) {
            this.storeBytes = storeBytes;
            return this;
        }

        public KeyManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public KeyManagerBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public KeyManagerBuilder certFile(String certFile) {
            try {
                this.certBytes = HttpBuilder.readBytes(certFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read certificate file " + certFile, (Throwable)e);
            }
            return this;
        }

        public KeyManagerBuilder certBytes(byte[] certBytes) {
            this.certBytes = certBytes;
            return this;
        }

        public KeyManagerBuilder keyFile(String keyFile) {
            try {
                this.keyBytes = HttpBuilder.readBytes(keyFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read private key file " + keyFile, (Throwable)e);
            }
            return this;
        }

        public KeyManagerBuilder keyBytes(byte[] keyBytes) {
            this.keyBytes = keyBytes;
            return this;
        }

        public HttpBuilder end() {
            return this.parent;
        }

        public Http.KeyManager build() {
            return new Http.KeyManager(this.storeType, this.storeBytes, this.password, this.alias, this.certBytes, this.keyBytes);
        }
    }

    public static class TrustManagerBuilder
    implements BuilderBase<TrustManagerBuilder> {
        private final HttpBuilder parent;
        private String storeType = "JKS";
        private byte[] storeBytes;
        private String password;
        private byte[] certBytes;

        public TrustManagerBuilder(HttpBuilder parent) {
            this.parent = parent;
        }

        public TrustManagerBuilder storeType(String type) {
            this.storeType = type;
            return this;
        }

        public TrustManagerBuilder storeFile(String filename) {
            try {
                this.storeBytes = HttpBuilder.readBytes(filename);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read keystore file " + filename, (Throwable)e);
            }
            return this;
        }

        public TrustManagerBuilder storeBytes(byte[] storeBytes) {
            this.storeBytes = storeBytes;
            return this;
        }

        public TrustManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public TrustManagerBuilder certFile(String certFile) {
            try {
                this.certBytes = HttpBuilder.readBytes(certFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read certificate file " + certFile, (Throwable)e);
            }
            return this;
        }

        public TrustManagerBuilder certBytes(byte[] certBytes) {
            this.certBytes = certBytes;
            return this;
        }

        public HttpBuilder end() {
            return this.parent;
        }

        public Http.TrustManager build() {
            return new Http.TrustManager(this.storeType, this.storeBytes, this.password, this.certBytes);
        }
    }
}

