/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.util.Watermarks;
import io.hyperfoil.http.api.HttpConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ConnectionPoolStats {
    private static final Logger log = LogManager.getLogger(ConnectionPoolStats.class);
    protected final String authority;
    protected final Watermarks usedConnections = new Watermarks();
    protected final Watermarks inFlight = new Watermarks();
    protected final Watermarks blockedSessions = new Watermarks();
    protected final Map<String, Watermarks> typeStats = new HashMap<String, Watermarks>();

    ConnectionPoolStats(String authority) {
        this.authority = authority;
    }

    public void incrementInFlight() {
        this.inFlight.incrementUsed();
    }

    public void decrementInFlight() {
        this.inFlight.decrementUsed();
    }

    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
        consumer.accept(this.authority, "in-flight requests", this.inFlight.minUsed(), this.inFlight.maxUsed());
        this.inFlight.resetStats();
        consumer.accept(this.authority, "used connections", this.usedConnections.minUsed(), this.usedConnections.maxUsed());
        this.usedConnections.resetStats();
        consumer.accept(this.authority, "blocked sessions", this.blockedSessions.minUsed(), this.blockedSessions.maxUsed());
        this.blockedSessions.resetStats();
        for (Map.Entry<String, Watermarks> entry : this.typeStats.entrySet()) {
            int min = entry.getValue().minUsed();
            int max = entry.getValue().maxUsed();
            entry.getValue().resetStats();
            consumer.accept(this.authority, entry.getKey(), min, max);
        }
    }

    protected String tagConnection(HttpConnection connection) {
        switch (connection.version()) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                return connection.isSecure() ? "TLS + HTTP 1.x" : "HTTP 1.x";
            }
            case HTTP_2_0: {
                return connection.isSecure() ? "TLS + HTTP 2" : "HTTP 2";
            }
        }
        return "unknown";
    }

    protected void incrementTypeStats(HttpConnection conn) {
        this.typeStats.computeIfAbsent(this.tagConnection(conn), t -> new Watermarks()).incrementUsed();
    }
}

