/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Http1xConnection
extends ChannelDuplexHandler
implements HttpConnection {
    private static final Logger log = LogManager.getLogger(Http1xConnection.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] HTTP1_1 = new byte[]{32, 72, 84, 84, 80, 47, 49, 46, 49, 13, 10};
    private final Deque<HttpRequest> inflights;
    private final BiConsumer<HttpConnection, Throwable> activationHandler;
    private final boolean secure;
    private final int pipeliningLimit;
    private HttpConnectionPool pool;
    private ChannelHandlerContext ctx;
    private int aboutToSend;
    private boolean activated;
    private HttpConnection.Status status = HttpConnection.Status.OPEN;
    private long lastUsed = System.nanoTime();

    Http1xConnection(HttpClientPoolImpl client, BiConsumer<HttpConnection, Throwable> handler) {
        this.activationHandler = handler;
        this.inflights = new ArrayDeque<HttpRequest>(client.config().pipeliningLimit());
        this.secure = client.isSecure();
        this.pipeliningLimit = client.config().pipeliningLimit();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        if (ctx.channel().isActive()) {
            this.checkActivated(ctx);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.checkActivated(ctx);
    }

    private void checkActivated(ChannelHandlerContext ctx) {
        if (!this.activated) {
            this.activated = true;
            this.activationHandler.accept(this, null);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        throw new UnsupportedOperationException();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!(cause instanceof SessionStopException)) {
            log.warn("Exception in {}", (Object)this, (Object)cause);
            this.cancelRequests(cause);
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.cancelRequests(CLOSED_EXCEPTION);
    }

    private void cancelRequests(Throwable cause) {
        HttpRequest request;
        while ((request = this.inflights.poll()) != null) {
            this.pool.release(this, false, true);
            if (!request.isRunning()) continue;
            request.cancel(cause);
        }
    }

    @Override
    public void attach(HttpConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public void request(HttpRequest request, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator) {
        ByteBuf body;
        assert (this.aboutToSend > 0);
        --this.aboutToSend;
        ByteBuf buf = this.ctx.alloc().buffer();
        buf.writeBytes(request.method.netty.asciiName().array());
        buf.writeByte(32);
        boolean beforeQuestion = true;
        for (int i = 0; i < request.path.length(); ++i) {
            if (request.path.charAt(i) == ' ') {
                if (beforeQuestion) {
                    buf.writeByte(37);
                    buf.writeByte(50);
                    buf.writeByte(48);
                    continue;
                }
                buf.writeByte(43);
                continue;
            }
            if (request.path.charAt(i) == '?') {
                beforeQuestion = false;
            }
            buf.writeByte(0xFF & request.path.charAt(i));
        }
        buf.writeBytes(HTTP1_1);
        if (injectHostHeader) {
            this.writeHeader(buf, HttpHeaderNames.HOST.array(), this.pool.clientPool().originalDestinationBytes());
        }
        ByteBuf byteBuf = body = bodyGenerator != null ? bodyGenerator.apply(request.session, request.connection()) : null;
        if (body == null) {
            body = Unpooled.EMPTY_BUFFER;
        }
        if (body.readableBytes() > 0) {
            if (trace) {
                log.trace("Sending HTTP request body: {}\n", (Object)Util.toString((ByteBuf)body, (int)body.readerIndex(), (int)body.readableBytes()));
            }
            buf.writeBytes(HttpHeaderNames.CONTENT_LENGTH.array()).writeByte(58).writeByte(32);
            Util.intAsText2byteBuf((int)body.readableBytes(), (ByteBuf)buf);
            buf.writeByte(13).writeByte(10);
        }
        HttpCache httpCache = null;
        if (request.hasCacheControl()) {
            httpCache = HttpCache.get(request.session);
            httpCache.beforeRequestHeaders(request);
        }
        HttpRequestWriterImpl writer = new HttpRequestWriterImpl(request, buf);
        if (headerAppenders != null) {
            for (BiConsumer<Session, HttpRequestWriter> headerAppender : headerAppenders) {
                headerAppender.accept(request.session, writer);
            }
        }
        buf.writeByte(13).writeByte(10);
        assert (this.ctx.executor().inEventLoop());
        if (httpCache != null && httpCache.isCached(request, writer)) {
            if (trace) {
                log.trace("#{} Request is completed from cache", (Object)request.session.uniqueId());
            }
            if (this.inFlight() != this.pipeliningLimit - 1) {
                this.pool.afterRequestSent(this);
            }
            request.handleCached();
            this.releasePoolAndPulse();
            return;
        }
        this.inflights.add(request);
        ChannelPromise writePromise = this.ctx.newPromise();
        writePromise.addListener((GenericFutureListener)request);
        if (body.isReadable()) {
            this.ctx.write((Object)buf);
            this.ctx.writeAndFlush((Object)body, writePromise);
        } else {
            this.ctx.writeAndFlush((Object)buf, writePromise);
        }
        this.pool.afterRequestSent(this);
    }

    private void writeHeader(ByteBuf buf, byte[] name, byte[] value) {
        buf.writeBytes(name).writeByte(58).writeByte(32).writeBytes(value).writeByte(13).writeByte(10);
    }

    void releasePoolAndPulse() {
        this.lastUsed = System.nanoTime();
        HttpConnectionPool pool = this.pool;
        if (pool != null) {
            pool.release(this, this.inFlight() == this.pipeliningLimit - 1 && !this.isClosed(), true);
            pool.pulse();
        }
    }

    @Override
    public HttpRequest dispatchedRequest() {
        return this.inflights.peekLast();
    }

    @Override
    public HttpRequest peekRequest(int streamId) {
        assert (streamId == 0);
        return this.inflights.peek();
    }

    @Override
    public boolean removeRequest(int streamId, HttpRequest request) {
        HttpRequest req = this.inflights.poll();
        if (req == null) {
            return false;
        }
        if (req != request) {
            throw new IllegalStateException();
        }
        return true;
    }

    public void setClosed() {
        this.status = HttpConnection.Status.CLOSED;
    }

    public boolean isOpen() {
        return this.status == HttpConnection.Status.OPEN;
    }

    public boolean isClosed() {
        return this.status == HttpConnection.Status.CLOSED;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_1_1;
    }

    @Override
    public Http config() {
        return this.pool.clientPool().config();
    }

    @Override
    public HttpConnectionPool pool() {
        return this.pool;
    }

    @Override
    public long lastUsed() {
        return this.lastUsed;
    }

    public ChannelHandlerContext context() {
        return this.ctx;
    }

    public void onAcquire() {
        ++this.aboutToSend;
    }

    public boolean isAvailable() {
        return this.pool == null || this.inFlight() < this.pipeliningLimit;
    }

    public int inFlight() {
        return this.inflights.size() + this.aboutToSend;
    }

    public void close() {
        if (this.status == HttpConnection.Status.OPEN) {
            this.status = HttpConnection.Status.CLOSING;
            this.cancelRequests(SELF_CLOSED_EXCEPTION);
        }
        this.ctx.close();
    }

    public String host() {
        return this.pool.clientPool().host();
    }

    public String toString() {
        return "Http1xConnection{" + this.ctx.channel().localAddress() + " -> " + this.ctx.channel().remoteAddress() + ", status=" + this.status + ", size=" + this.inflights.size() + "+" + this.aboutToSend + ":" + this.inflights + "}";
    }

    private class HttpRequestWriterImpl
    implements HttpRequestWriter {
        private final HttpRequest request;
        private final ByteBuf buf;

        HttpRequestWriterImpl(HttpRequest request, ByteBuf buf) {
            this.request = request;
            this.buf = buf;
        }

        @Override
        public HttpConnection connection() {
            return Http1xConnection.this;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public void putHeader(CharSequence header, CharSequence value) {
            AsciiString ascii;
            ByteBuf buf = this.buf;
            buf.ensureWritable(header.length() + value.length() + 4);
            if (header instanceof AsciiString) {
                ascii = (AsciiString)header;
                buf.writeBytes(ascii.array(), ascii.arrayOffset(), ascii.length());
            } else {
                buf.writeCharSequence(header, CharsetUtil.ISO_8859_1);
            }
            buf.writeByte(58);
            buf.writeByte(32);
            if (value instanceof AsciiString) {
                ascii = (AsciiString)value;
                buf.writeBytes(ascii.array(), ascii.arrayOffset(), ascii.length());
            } else if (Util.isLatin((CharSequence)value)) {
                buf.writeCharSequence(value, CharsetUtil.ISO_8859_1);
            } else {
                buf.writeCharSequence(value, CharsetUtil.UTF_8);
            }
            buf.writeByte(13);
            buf.writeByte(10);
            if (this.request.hasCacheControl()) {
                HttpCache.get(this.request.session).requestHeader(this.request, header, value);
            }
        }
    }
}

