/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.connection.BaseResponseHandler;
import io.hyperfoil.http.connection.Http1xConnection;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Http1xResponseHandler
extends BaseResponseHandler {
    private static final Logger log = LogManager.getLogger(Http1xResponseHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final int MAX_LINE_LENGTH = 4096;
    private State state = State.STATUS;
    private boolean crRead = false;
    private int contentLength = -1;
    private ByteBuf lastLine;
    private int status = 0;
    private boolean chunked = false;
    private int skipChunkBytes;

    Http1xResponseHandler(HttpConnection connection) {
        super(connection);
    }

    @Override
    protected boolean isRequestStream(int streamId) {
        return true;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.lastLine == null) {
            this.lastLine = ctx.alloc().buffer(4096);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.lastLine != null) {
            this.lastLine.release();
            this.lastLine = null;
        }
        super.channelInactive(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.lastLine != null) {
            this.lastLine.release();
            this.lastLine = null;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            int readerIndex = buf.readerIndex();
            do {
                switch (this.state) {
                    case STATUS: {
                        readerIndex = this.readStatus(ctx, buf, readerIndex);
                        break;
                    }
                    case HEADERS: {
                        readerIndex = this.readHeaders(ctx, buf, readerIndex);
                        break;
                    }
                    case BODY: {
                        readerIndex = this.readBody(ctx, buf, readerIndex);
                        break;
                    }
                    case TRAILERS: {
                        readerIndex = this.readTrailers(ctx, buf, readerIndex);
                    }
                }
            } while (readerIndex >= 0);
            return;
        }
        log.error("Unexpected message type: {}", msg);
        super.channelRead(ctx, msg);
    }

    private int readStatus(ChannelHandlerContext ctx, ByteBuf buf, int readerIndex) {
        int lineStartIndex = buf.readerIndex();
        while (readerIndex < buf.writerIndex()) {
            byte val = buf.getByte(readerIndex);
            if (val == 13) {
                this.crRead = true;
            } else {
                if (val == 10 && this.crRead) {
                    int j;
                    this.crRead = false;
                    ByteBuf lineBuf = buf;
                    if (this.lastLine.isReadable()) {
                        assert (lineStartIndex == buf.readerIndex());
                        this.copyLastLine(buf, lineStartIndex, readerIndex);
                        lineBuf = this.lastLine;
                        lineStartIndex = 0;
                    }
                    for (j = lineStartIndex; j < lineBuf.writerIndex() && lineBuf.getByte(j) != 32; ++j) {
                    }
                    this.status = Http1xResponseHandler.readDecNumber(lineBuf, j);
                    if (this.status >= 100 && this.status < 200 || this.status == 204 || this.status == 304) {
                        this.contentLength = 0;
                    }
                    this.onStatus(this.status);
                    this.state = State.HEADERS;
                    this.lastLine.writerIndex(0);
                    return readerIndex + 1;
                }
                this.crRead = false;
            }
            ++readerIndex;
        }
        this.copyLastLine(buf, lineStartIndex, readerIndex);
        this.passFullBuffer(ctx, buf);
        return -1;
    }

    private int readHeaders(ChannelHandlerContext ctx, ByteBuf buf, int readerIndex) throws Exception {
        int lineStartIndex = readerIndex;
        while (readerIndex < buf.writerIndex()) {
            if (!this.crRead) {
                int indexOfCr = buf.indexOf(readerIndex, buf.writerIndex(), (byte)13);
                if (indexOfCr == -1) {
                    readerIndex = buf.writerIndex();
                    break;
                }
                this.crRead = true;
                readerIndex = indexOfCr + 1;
                continue;
            }
            byte val = buf.getByte(readerIndex);
            if (val == 10) {
                int lineEndIndex;
                ByteBuf lineBuf;
                this.crRead = false;
                if (readerIndex - lineStartIndex == 1 && this.lastLine.writerIndex() == 0 || this.lastLine.writerIndex() == 1 && readerIndex == buf.readerIndex()) {
                    HttpRequest httpRequest = this.connection.peekRequest(0);
                    if (httpRequest != null) {
                        switch (httpRequest.method) {
                            case HEAD: 
                            case CONNECT: {
                                this.contentLength = 0;
                                this.chunked = false;
                            }
                        }
                    }
                    this.state = State.BODY;
                    this.lastLine.writerIndex(0);
                    if (this.contentLength >= 0) {
                        this.responseBytes = readerIndex - buf.readerIndex() + this.contentLength + 1;
                    }
                    return readerIndex + 1;
                }
                if (this.lastLine.isReadable()) {
                    this.copyLastLine(buf, lineStartIndex, readerIndex);
                    lineBuf = this.lastLine;
                    lineEndIndex = this.lastLine.readableBytes() + readerIndex - lineStartIndex - 1;
                    lineStartIndex = 0;
                } else {
                    lineBuf = buf;
                    lineEndIndex = readerIndex - 1;
                }
                if (Http1xResponseHandler.matches(lineBuf, lineStartIndex, HttpHeaderNames.CONTENT_LENGTH)) {
                    this.contentLength = Http1xResponseHandler.readDecNumber(lineBuf, lineStartIndex + HttpHeaderNames.CONTENT_LENGTH.length() + 1);
                } else if (Http1xResponseHandler.matches(lineBuf, lineStartIndex, HttpHeaderNames.TRANSFER_ENCODING)) {
                    this.chunked = Http1xResponseHandler.matches(lineBuf, lineStartIndex + HttpHeaderNames.TRANSFER_ENCODING.length() + 1, HttpHeaderValues.CHUNKED);
                    this.skipChunkBytes = 0;
                }
                int endOfNameIndex = lineEndIndex;
                int startOfValueIndex = lineStartIndex;
                int indexOfColon = lineBuf.indexOf(lineStartIndex, lineEndIndex, (byte)58);
                if (indexOfColon != -1) {
                    int i = indexOfColon;
                    for (endOfNameIndex = i - 1; endOfNameIndex >= lineStartIndex && lineBuf.getByte(endOfNameIndex) == 32; --endOfNameIndex) {
                    }
                    for (startOfValueIndex = i + 1; startOfValueIndex < lineEndIndex && lineBuf.getByte(startOfValueIndex) == 32; ++startOfValueIndex) {
                    }
                }
                this.onHeaderRead(lineBuf, lineStartIndex, endOfNameIndex + 1, startOfValueIndex, lineEndIndex);
                this.lastLine.writerIndex(0);
                lineStartIndex = readerIndex + 1;
            } else if (val != 13) {
                this.crRead = false;
            }
            ++readerIndex;
        }
        this.copyLastLine(buf, lineStartIndex, readerIndex);
        this.passFullBuffer(ctx, buf);
        return -1;
    }

    private int readBody(ChannelHandlerContext ctx, ByteBuf buf, int readerIndex) throws Exception {
        if (this.chunked) {
            int readable = buf.writerIndex() - readerIndex;
            if (this.skipChunkBytes > readable) {
                int readableBody = Math.min(this.skipChunkBytes - 2, readable);
                this.skipChunkBytes -= readable;
                this.onBodyPart(buf, readerIndex, readableBody, false);
                this.passFullBuffer(ctx, buf);
                return -1;
            }
            this.onBodyPart(buf, readerIndex, this.skipChunkBytes - 2, false);
            this.skipChunkBytes = 0;
            return this.readChunks(ctx, buf, readerIndex += this.skipChunkBytes);
        }
        if (this.responseBytes > 0) {
            boolean isLastPart = buf.readableBytes() >= this.responseBytes;
            this.onBodyPart(buf, readerIndex, Math.min(buf.writerIndex(), buf.readerIndex() + this.responseBytes) - readerIndex, isLastPart);
            if (isLastPart) {
                this.reset();
            }
            return this.handleBuffer(ctx, buf, 0) ? buf.readerIndex() : -1;
        }
        this.onBodyPart(buf, readerIndex, buf.writerIndex() - readerIndex, false);
        this.passFullBuffer(ctx, buf);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readChunks(ChannelHandlerContext ctx, ByteBuf buf, int readerIndex) {
        int lineStartOffset = readerIndex;
        while (readerIndex < buf.writerIndex()) {
            block13: {
                byte val = buf.getByte(readerIndex);
                if (val == 13) {
                    this.crRead = true;
                } else {
                    if (val == 10 && this.crRead) {
                        try {
                            int partSize;
                            ByteBuf lineBuf = buf;
                            if (this.lastLine.isReadable()) {
                                this.copyLastLine(buf, lineStartOffset, readerIndex);
                                lineBuf = this.lastLine;
                                lineStartOffset = 0;
                            }
                            if ((partSize = this.readHexNumber(lineBuf, lineStartOffset)) == 0) {
                                this.onBodyPart(Unpooled.EMPTY_BUFFER, 0, 0, true);
                                this.chunked = false;
                                this.state = State.TRAILERS;
                                int n = readerIndex + 1;
                                return n;
                            }
                            if (readerIndex + 3 + partSize < buf.writerIndex()) {
                                this.onBodyPart(buf, readerIndex + 1, partSize, false);
                                readerIndex += partSize;
                                if (buf.getByte(++readerIndex) != 13 || buf.getByte(++readerIndex) != 10) {
                                    throw new IllegalStateException("Chunk must end with CRLF!");
                                }
                                lineStartOffset = readerIndex + 1;
                                assert (this.skipChunkBytes == 0);
                                break block13;
                            }
                            this.onBodyPart(buf, readerIndex + 1, Math.min(buf.writerIndex() - readerIndex - 1, partSize), false);
                            this.skipChunkBytes = readerIndex + 3 + partSize - buf.writerIndex();
                            this.passFullBuffer(ctx, buf);
                            int n = -1;
                            return n;
                        }
                        finally {
                            this.crRead = false;
                            this.lastLine.writerIndex(0);
                        }
                    }
                    this.crRead = false;
                }
            }
            ++readerIndex;
        }
        this.copyLastLine(buf, lineStartOffset, buf.writerIndex());
        this.passFullBuffer(ctx, buf);
        return -1;
    }

    private int readTrailers(ChannelHandlerContext ctx, ByteBuf buf, int readerIndex) throws Exception {
        int lineStartIndex = readerIndex;
        while (readerIndex < buf.writerIndex()) {
            byte val = buf.getByte(readerIndex);
            if (val == 13) {
                this.crRead = true;
            } else if (val == 10 && this.crRead) {
                if (readerIndex - lineStartIndex == 1 || this.lastLine.writerIndex() == 1 && readerIndex == buf.readerIndex()) {
                    this.responseBytes = readerIndex + 1 - buf.readerIndex();
                    this.reset();
                    return this.handleBuffer(ctx, buf, 0) ? buf.readerIndex() : -1;
                }
                lineStartIndex = readerIndex + 1;
            } else {
                this.crRead = false;
            }
            ++readerIndex;
        }
        this.copyLastLine(buf, lineStartIndex, readerIndex);
        this.passFullBuffer(ctx, buf);
        return -1;
    }

    private void reset() {
        this.state = State.STATUS;
        this.status = 0;
        this.chunked = false;
        this.skipChunkBytes = 0;
        this.contentLength = -1;
        this.lastLine.writerIndex(0);
        this.crRead = false;
    }

    private void copyLastLine(ByteBuf buf, int lineStartOffset, int readerIndex) {
        int lineBytes = readerIndex - lineStartOffset;
        if (this.lastLine.writerIndex() + lineBytes > this.lastLine.capacity()) {
            throw new IllegalStateException("Too long header line.");
        }
        if (lineBytes > 0) {
            buf.getBytes(lineStartOffset, this.lastLine, this.lastLine.writerIndex(), lineBytes);
            this.lastLine.writerIndex(this.lastLine.writerIndex() + lineBytes);
        }
    }

    private void passFullBuffer(ChannelHandlerContext ctx, ByteBuf buf) {
        HttpRequest request = this.connection.peekRequest(0);
        this.onRawData(request, buf, false);
        this.onData(ctx, buf);
    }

    private static boolean matches(ByteBuf buf, int bufOffset, AsciiString string) {
        if ((bufOffset = Http1xResponseHandler.skipWhitespaces(buf, bufOffset)) + string.length() > buf.writerIndex()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Util.compareIgnoreCase((byte)buf.getByte(bufOffset + i), (byte)string.byteAt(i))) continue;
            return false;
        }
        return true;
    }

    private int readHexNumber(ByteBuf buf, int index) {
        int value = 0;
        for (index = Http1xResponseHandler.skipWhitespaces(buf, index); index < buf.writerIndex(); ++index) {
            byte b = buf.getByte(index);
            int v = this.toHex((char)b);
            if (v < 0) {
                if (b != 13) {
                    log.error("Error reading buffer, starting from {}, current index {} (char: {}), status {}:\n{}", (Object)buf.readerIndex(), (Object)index, (Object)b, (Object)this, (Object)ByteBufUtil.prettyHexDump((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes()));
                    throw new IllegalStateException("Part size must be followed by CRLF!");
                }
                return value;
            }
            value = value * 16 + v;
        }
        throw new IllegalStateException();
    }

    private int toHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private static int readDecNumber(ByteBuf buf, int index) {
        int value = 0;
        for (index = Http1xResponseHandler.skipWhitespaces(buf, index); index < buf.writerIndex(); ++index) {
            byte b = buf.getByte(index);
            if (b < 48 || b > 57) {
                return value;
            }
            value = value * 10 + (b - 48);
        }
        throw new IllegalStateException();
    }

    private static int skipWhitespaces(ByteBuf buf, int index) {
        int i = buf.forEachByte(index, buf.writerIndex() - index, ByteProcessor.FIND_NON_LINEAR_WHITESPACE);
        if (i != -1) {
            return i;
        }
        return buf.writerIndex();
    }

    public String toString() {
        return "Http1xRawBytesHandler{state=" + this.state + ", crRead=" + this.crRead + ", contentLength=" + this.contentLength + ", status=" + this.status + ", chunked=" + this.chunked + ", skipChunkBytes=" + this.skipChunkBytes + "}";
    }

    @Override
    protected void onData(ChannelHandlerContext ctx, ByteBuf buf) {
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStatus(int status) {
        HttpRequest request = this.connection.peekRequest(0);
        if (request == null) {
            if (HttpResponseStatus.REQUEST_TIMEOUT.code() == status) {
                log.debug("Closing connection {} as server timed out waiting for our first request.", (Object)this.connection);
            } else {
                log.error("Received unsolicited response (status {}) on {}", (Object)status, (Object)this.connection);
            }
            return;
        }
        if (request.isCompleted()) {
            log.trace("Request on connection {} has been already completed (error in handlers?), ignoring", (Object)this.connection);
        } else {
            HttpResponseHandlers handlers = request.handlers();
            request.enter();
            try {
                handlers.handleStatus(request, status, null);
            }
            finally {
                request.exit();
            }
            request.session.proceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onHeaderRead(ByteBuf buf, int startOfName, int endOfName, int startOfValue, int endOfValue) {
        HttpRequest request = this.connection.peekRequest(0);
        if (request == null) {
            if (trace) {
                AsciiString name = Util.toAsciiString((ByteBuf)buf, (int)startOfName, (int)(endOfName - startOfName));
                String value = Util.toString((ByteBuf)buf, (int)startOfValue, (int)(endOfValue - startOfValue));
                log.trace("No request, received headers: {}: {}", (Object)name, (Object)value);
            }
        } else if (request.isCompleted()) {
            log.trace("Request on connection {} has been already completed (error in handlers?), ignoring", (Object)this.connection);
        } else {
            HttpResponseHandlers handlers = request.handlers();
            request.enter();
            try {
                AsciiString name = Util.toAsciiString((ByteBuf)buf, (int)startOfName, (int)(endOfName - startOfName));
                int valueLen = endOfValue - startOfValue;
                Object value = Util.isAscii((ByteBuf)buf, (int)startOfValue, (int)valueLen) ? Util.toAsciiString((ByteBuf)buf, (int)startOfValue, (int)valueLen) : buf.toString(startOfName, valueLen, CharsetUtil.UTF_8);
                handlers.handleHeader(request, (CharSequence)name, (CharSequence)value);
            }
            finally {
                request.exit();
            }
            request.session.proceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onBodyPart(ByteBuf buf, int startOffset, int length, boolean isLastPart) {
        if (length < 0 || length == 0 && !isLastPart) {
            return;
        }
        HttpRequest request = this.connection.peekRequest(0);
        if (request != null && !request.isCompleted()) {
            HttpResponseHandlers handlers = request.handlers();
            request.enter();
            try {
                handlers.handleBodyPart(request, buf, startOffset, length, isLastPart);
            }
            finally {
                request.exit();
            }
            request.session.proceed();
        }
    }

    @Override
    protected void onCompletion(HttpRequest request) {
        boolean removed = false;
        if (!request.isCompleted()) {
            request.enter();
            try {
                request.handlers().handleEnd(request, true);
                if (trace) {
                    log.trace("Completed response on {}", (Object)this);
                }
            }
            catch (SessionStopException e) {
                if (this.connection.removeRequest(0, request)) {
                    ((Http1xConnection)this.connection).releasePoolAndPulse();
                }
                throw e;
            }
            finally {
                request.exit();
            }
            removed = this.connection.removeRequest(0, request);
            request.session.proceed();
        }
        assert (request.isCompleted());
        request.release();
        if (trace) {
            log.trace("Releasing request");
        }
        if (removed) {
            ((Http1xConnection)this.connection).releasePoolAndPulse();
        }
    }

    private static enum State {
        STATUS,
        HEADERS,
        BODY,
        TRAILERS;

    }
}

