/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.AppendableCharSequence;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Http2Connection
extends Http2EventAdapter
implements HttpConnection {
    private static final Logger log = LogManager.getLogger(Http2Connection.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ChannelHandlerContext context;
    private final io.netty.handler.codec.http2.Http2Connection connection;
    private final Http2ConnectionEncoder encoder;
    private final IntObjectMap<HttpRequest> streams = new IntObjectHashMap();
    private final long clientMaxStreams;
    private final boolean secure;
    private HttpConnectionPool pool;
    private int aboutToSend;
    private long maxStreams;
    private HttpConnection.Status status = HttpConnection.Status.OPEN;
    private HttpRequest dispatchedRequest;
    private long lastUsed = System.nanoTime();

    Http2Connection(ChannelHandlerContext context, io.netty.handler.codec.http2.Http2Connection connection, Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, HttpClientPool clientPool) {
        this.context = context;
        this.connection = connection;
        this.encoder = encoder;
        this.clientMaxStreams = this.maxStreams = (long)clientPool.config().maxHttp2Streams();
        this.secure = clientPool.isSecure();
        EventAdapter listener = new EventAdapter();
        connection.addListener((Http2Connection.Listener)listener);
        decoder.frameListener((Http2FrameListener)listener);
    }

    public ChannelHandlerContext context() {
        return this.context;
    }

    public void onAcquire() {
        assert (this.aboutToSend >= 0);
        ++this.aboutToSend;
    }

    public boolean isAvailable() {
        return (long)this.inFlight() < this.maxStreams;
    }

    public int inFlight() {
        return this.streams.size() + this.aboutToSend;
    }

    public void incrementConnectionWindowSize(int increment) {
        try {
            Http2Stream stream = this.connection.connectionStream();
            ((Http2LocalFlowController)this.connection.local().flowController()).incrementWindowSize(stream, increment);
        }
        catch (Http2Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.status == HttpConnection.Status.OPEN) {
            this.status = HttpConnection.Status.CLOSING;
            this.cancelRequests(Connection.SELF_CLOSED_EXCEPTION);
        }
        this.context.close();
    }

    public String host() {
        return this.pool.clientPool().host();
    }

    @Override
    public void attach(HttpConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public void request(HttpRequest request, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator) {
        HttpCache httpCache;
        ByteBuf buf;
        assert (this.aboutToSend > 0);
        --this.aboutToSend;
        HttpClientPool httpClientPool = this.pool.clientPool();
        ByteBuf byteBuf = buf = bodyGenerator != null ? bodyGenerator.apply(request.session, this) : null;
        if (request.path.contains(" ")) {
            int length = request.path.length();
            AppendableCharSequence temp = new AppendableCharSequence(length);
            boolean beforeQuestion = true;
            for (int i = 0; i < length; ++i) {
                if (request.path.charAt(i) == ' ') {
                    if (beforeQuestion) {
                        temp.append('%');
                        temp.append('2');
                        temp.append('0');
                        continue;
                    }
                    temp.append('+');
                    continue;
                }
                if (request.path.charAt(i) == '?') {
                    beforeQuestion = false;
                }
                temp.append(request.path.charAt(i));
            }
            request.path = temp.toString();
        }
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)request.method.name()).scheme((CharSequence)httpClientPool.scheme()).path((CharSequence)request.path).authority((CharSequence)httpClientPool.authority());
        if (injectHostHeader && !this.pool.clientPool().config().protocol().secure()) {
            headers.add((Object)HttpHeaderNames.HOST, (Object)httpClientPool.authority());
        }
        if (buf != null && buf.readableBytes() > 0) {
            headers.add((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(buf.readableBytes()));
        }
        HttpRequestWriterImpl writer = new HttpRequestWriterImpl(request, headers);
        if (headerAppenders != null) {
            for (BiConsumer<Session, HttpRequestWriter> headerAppender : headerAppenders) {
                headerAppender.accept(request.session, writer);
            }
        }
        if (request.hasCacheControl() && (httpCache = HttpCache.get(request.session)).isCached(request, writer)) {
            if (trace) {
                log.trace("#{} Request is completed from cache", (Object)request.session.uniqueId());
            }
            if ((long)this.streams.size() != this.maxStreams - 1L) {
                this.pool.afterRequestSent(this);
            }
            request.handleCached();
            this.tryReleaseToPool();
            return;
        }
        assert (this.context.executor().inEventLoop());
        int id = this.nextStreamId();
        this.streams.put(id, (Object)request);
        this.dispatchedRequest = request;
        ChannelPromise writePromise = this.context.newPromise();
        this.encoder.writeHeaders(this.context, id, headers, 0, buf == null, writePromise);
        if (buf != null) {
            if (trace) {
                log.trace("Sending HTTP request body: {}\n", (Object)Util.toString((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes()));
            }
            writePromise = this.context.newPromise();
            this.encoder.writeData(this.context, id, buf, 0, true, writePromise);
        }
        writePromise.addListener((GenericFutureListener)request);
        this.context.channel().flush();
        this.dispatchedRequest = null;
        this.pool.afterRequestSent(this);
    }

    @Override
    public HttpRequest dispatchedRequest() {
        return this.dispatchedRequest;
    }

    @Override
    public HttpRequest peekRequest(int streamId) {
        return (HttpRequest)((Object)this.streams.get(streamId));
    }

    @Override
    public boolean removeRequest(int streamId, HttpRequest request) {
        throw new UnsupportedOperationException();
    }

    public void setClosed() {
        this.status = HttpConnection.Status.CLOSED;
    }

    public boolean isOpen() {
        return this.status == HttpConnection.Status.OPEN;
    }

    public boolean isClosed() {
        return this.status == HttpConnection.Status.CLOSED;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2_0;
    }

    @Override
    public Http config() {
        return this.pool.clientPool().config();
    }

    @Override
    public HttpConnectionPool pool() {
        return this.pool;
    }

    @Override
    public long lastUsed() {
        return this.lastUsed;
    }

    private int nextStreamId() {
        return this.connection.local().incrementAndGetNextStreamId();
    }

    public String toString() {
        return "Http2Connection{" + this.context.channel().localAddress() + " -> " + this.context.channel().remoteAddress() + ", status=" + this.status + ", streams=" + this.streams.size() + "+" + this.aboutToSend + ":" + this.streams + "}";
    }

    void cancelRequests(Throwable cause) {
        Iterator iterator = this.streams.values().iterator();
        while (iterator.hasNext()) {
            HttpRequest request = (HttpRequest)((Object)iterator.next());
            iterator.remove();
            this.pool.release(this, false, true);
            request.cancel(cause);
        }
    }

    private void tryReleaseToPool() {
        this.lastUsed = System.nanoTime();
        HttpConnectionPool pool = this.pool;
        if (pool != null) {
            pool.release(this, (long)this.inFlight() == this.maxStreams - 1L && !this.isClosed(), true);
            pool.pulse();
        }
    }

    private class EventAdapter
    extends Http2EventAdapter {
        private EventAdapter() {
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
            if (settings.maxConcurrentStreams() != null) {
                Http2Connection.this.maxStreams = Math.min(Http2Connection.this.clientMaxStreams, settings.maxConcurrentStreams());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
            HttpRequest request = (HttpRequest)((Object)Http2Connection.this.streams.get(streamId));
            if (request != null && !request.isCompleted()) {
                HttpResponseHandlers handlers = request.handlers();
                int code = -1;
                try {
                    code = Integer.parseInt(headers.status().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                request.enter();
                try {
                    handlers.handleStatus(request, code, "");
                    for (Map.Entry header : headers) {
                        handlers.handleHeader(request, (CharSequence)header.getKey(), (CharSequence)header.getValue());
                    }
                    if (endStream) {
                        handlers.handleBodyPart(request, Unpooled.EMPTY_BUFFER, 0, 0, true);
                    }
                }
                finally {
                    request.exit();
                }
                request.session.proceed();
            }
            if (endStream) {
                this.endStream(streamId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int ack = super.onDataRead(ctx, streamId, data, padding, endOfStream);
            HttpRequest request = (HttpRequest)((Object)Http2Connection.this.streams.get(streamId));
            if (request != null && !request.isCompleted()) {
                HttpResponseHandlers handlers = request.handlers();
                request.enter();
                try {
                    handlers.handleBodyPart(request, data, data.readerIndex(), data.readableBytes(), endOfStream);
                }
                finally {
                    request.exit();
                }
                request.session.proceed();
            }
            if (endOfStream) {
                this.endStream(streamId);
            }
            return ack;
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
            HttpRequest request = (HttpRequest)((Object)Http2Connection.this.streams.get(streamId));
            if (request != null) {
                HttpResponseHandlers handlers = request.handlers();
                if (!request.isCompleted()) {
                    request.enter();
                    try {
                        handlers.handleThrowable(request, new IOException("HTTP2 stream was reset"));
                    }
                    catch (SessionStopException e) {
                        if (Http2Connection.this.streams.remove(streamId) == request) {
                            Http2Connection.this.tryReleaseToPool();
                        }
                        throw e;
                    }
                    finally {
                        request.exit();
                    }
                    request.session.proceed();
                }
                request.release();
                if (Http2Connection.this.streams.remove(streamId) == request) {
                    Http2Connection.this.tryReleaseToPool();
                }
            }
        }

        private void endStream(int streamId) {
            HttpRequest request = (HttpRequest)((Object)Http2Connection.this.streams.get(streamId));
            if (request != null) {
                if (!request.isCompleted()) {
                    request.enter();
                    try {
                        request.handlers().handleEnd(request, true);
                        if (trace) {
                            log.trace("Completed response on {}", (Object)this);
                        }
                    }
                    catch (SessionStopException e) {
                        if (Http2Connection.this.streams.remove(streamId) == request) {
                            Http2Connection.this.tryReleaseToPool();
                        }
                        throw e;
                    }
                    finally {
                        request.exit();
                    }
                    request.session.proceed();
                }
                request.release();
                if (Http2Connection.this.streams.remove(streamId) == request) {
                    Http2Connection.this.tryReleaseToPool();
                }
            }
        }
    }

    private class HttpRequestWriterImpl
    implements HttpRequestWriter {
        private final HttpRequest request;
        private final Http2Headers headers;

        HttpRequestWriterImpl(HttpRequest request, Http2Headers headers) {
            this.request = request;
            this.headers = headers;
        }

        @Override
        public HttpConnection connection() {
            return Http2Connection.this;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public void putHeader(CharSequence header, CharSequence value) {
            this.headers.add((Object)header, (Object)value);
            if (this.request.hasCacheControl()) {
                HttpCache.get(this.request.session).requestHeader(this.request, header, value);
            }
        }
    }
}

