/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseDelegatingStatusHandler
implements StatusHandler {
    protected final StatusHandler[] handlers;

    public BaseDelegatingStatusHandler(StatusHandler[] handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handleStatus(HttpRequest request, int status) {
        for (StatusHandler handler : this.handlers) {
            handler.handleStatus(request, status);
        }
    }

    public static abstract class Builder<S extends Builder<S>>
    implements StatusHandler.Builder {
        private final List<StatusHandler.Builder> handlers = new ArrayList<StatusHandler.Builder>();

        public S handlers(Collection<? extends StatusHandler.Builder> handlers) {
            this.handlers.addAll(handlers);
            return (S)this;
        }

        protected StatusHandler[] buildHandlers() {
            return (StatusHandler[])this.handlers.stream().map(StatusHandler.Builder::build).toArray(StatusHandler[]::new);
        }
    }
}

