/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.impl.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RangeStatusValidator
implements StatusHandler {
    private static final Logger log = LogManager.getLogger(RangeStatusValidator.class);
    public final int min;
    public final int max;

    public RangeStatusValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void handleStatus(HttpRequest request, int status) {
        boolean valid;
        boolean bl = valid = status >= this.min && status <= this.max;
        if (!valid) {
            request.markInvalid();
            log.warn("#{} Sequence {}, request {} on connection {} received invalid status {}", (Object)request.session.uniqueId(), (Object)request.sequence(), (Object)request, (Object)request.connection(), (Object)status);
        }
    }

    @Name(value="range")
    public static class Builder
    implements StatusHandler.Builder,
    InitFromParam<Builder> {
        private int min = 200;
        private int max = 299;

        public Builder init(String param) {
            int xn = 0;
            for (int i = param.length() - 1; i >= 0 && param.charAt(i) == 'x'; --i) {
                ++xn;
            }
            try {
                int dash = param.indexOf(45);
                if (dash >= 0) {
                    this.min = Integer.parseInt(param.substring(0, dash).trim());
                    this.max = Integer.parseInt(param.substring(dash + 1).trim());
                } else {
                    int value = Integer.parseInt(param.substring(0, param.length() - xn));
                    int mul = Util.pow((int)10, (int)xn);
                    this.min = value * mul;
                    this.max = (value + 1) * mul - 1;
                }
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Cannot parse '" + param + "' as status range");
            }
            return this;
        }

        @Override
        public RangeStatusValidator build() {
            return new RangeStatusValidator(this.min, this.max);
        }

        public Builder min(int min) {
            this.min = min;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }
    }
}

