/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.metric.AuthorityAndPathMetric;
import io.hyperfoil.core.metric.MetricSelector;
import io.hyperfoil.core.metric.PathMetricSelector;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.handlers.Location;
import io.hyperfoil.http.steps.HttpRequestStepBuilder;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;

public class FetchResourceHandler
implements Serializable,
ResourceUtilizer {
    private final ObjectAccess var;
    private final int maxResources;
    private final String sequence;
    private final int concurrency;
    private final Action onCompletion;
    private final Queue.Key queueKey;
    private final LimitedPoolResource.Key<Location> locationPoolKey;

    public FetchResourceHandler(Queue.Key queueKey, LimitedPoolResource.Key<Location> locationPoolKey, ObjectAccess var, int maxResources, String sequence, int concurrency, Action onCompletion) {
        this.queueKey = queueKey;
        this.locationPoolKey = locationPoolKey;
        this.var = var;
        this.maxResources = maxResources;
        this.sequence = sequence;
        this.concurrency = concurrency;
        this.onCompletion = onCompletion;
    }

    public void before(Session session) {
        Queue queue = (Queue)session.getResource((Session.ResourceKey)this.queueKey);
        queue.reset(session);
    }

    public void handle(Session session, CharSequence authority, CharSequence path) {
        Queue queue = (Queue)session.getResource((Session.ResourceKey)this.queueKey);
        LimitedPoolResource locationPool = (LimitedPoolResource)session.getResource(this.locationPoolKey);
        Location location = (Location)locationPool.acquire();
        location.authority = authority;
        location.path = path;
        queue.push(session, (Object)location);
    }

    public void after(Session session) {
        Queue queue = (Queue)session.getResource((Session.ResourceKey)this.queueKey);
        queue.producerComplete(session);
    }

    public void reserve(Session session) {
        if (!this.var.isSet(session)) {
            this.var.setObject(session, (Object)ObjectVar.newArray((Session)session, (int)this.concurrency));
        }
        session.declareResource((Session.ResourceKey)this.queueKey, () -> new Queue(this.var, this.maxResources, this.concurrency, this.sequence, this.onCompletion), true);
        session.declareResource(this.locationPoolKey, () -> LimitedPoolResource.create((int)this.maxResources, Location.class, Location::new), true);
    }

    public static class Builder
    implements BuilderBase<Builder> {
        private MetricSelector metricSelector;
        private int maxResources;
        private int concurrency = 8;
        private Action.Builder onCompletion;
        private Queue.Key queueKey;
        private LimitedPoolResource.Key<Location> locationPoolKey;
        private ObjectAccess varAccess;
        private String sequenceName;

        public Builder maxResources(int maxResources) {
            this.maxResources = maxResources;
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public PathMetricSelector metric() {
            PathMetricSelector metricSelector = new PathMetricSelector();
            this.metric((MetricSelector)metricSelector);
            return metricSelector;
        }

        public Builder metric(MetricSelector metricSelector) {
            if (this.metricSelector != null) {
                throw new BenchmarkDefinitionException("Metric already set!");
            }
            this.metricSelector = metricSelector;
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> onCompletion() {
            return new ServiceLoadedBuilderProvider(Action.Builder.class, this::onCompletion);
        }

        public Builder onCompletion(Action.Builder onCompletion) {
            this.onCompletion = onCompletion;
            return this;
        }

        public void prepareBuild() {
            this.queueKey = new Queue.Key();
            this.locationPoolKey = new LimitedPoolResource.Key();
            Locator locator = Locator.current();
            this.sequenceName = String.format("%s_fetchResources_%08x", locator.sequence().name(), ThreadLocalRandom.current().nextInt());
            Unique locationVar = new Unique();
            this.varAccess = SessionFactory.objectAccess((Object)locationVar);
            HttpRequestStepBuilder requestBuilder = new HttpRequestStepBuilder().sync(true).method(HttpMethod.GET);
            requestBuilder.path(() -> new Location.GetPath(SessionFactory.sequenceScopedReadAccess((Object)locationVar)));
            requestBuilder.authority(() -> new Location.GetAuthority(SessionFactory.sequenceScopedReadAccess((Object)locationVar)));
            if (this.metricSelector != null) {
                requestBuilder.metric(this.metricSelector);
            } else {
                requestBuilder.metric((MetricSelector)new AuthorityAndPathMetric());
            }
            SequenceBuilder sequence = locator.scenario().sequence(this.sequenceName).concurrency(this.concurrency);
            sequence.stepBuilder((StepBuilder)requestBuilder);
            Queue.Key myQueueKey = this.queueKey;
            LimitedPoolResource.Key<Location> myPoolKey = this.locationPoolKey;
            requestBuilder.handler().onCompletion(() -> new Location.Complete(myPoolKey, myQueueKey, SessionFactory.sequenceScopedObjectAccess((Object)locationVar)));
            sequence.prepareBuild();
        }

        public FetchResourceHandler build() {
            if (this.maxResources <= 0) {
                throw new BenchmarkDefinitionException("Maximum size for queue must be set!");
            }
            Action onCompletion = this.onCompletion == null ? null : this.onCompletion.build();
            return new FetchResourceHandler(this.queueKey, this.locationPoolKey, this.varAccess, this.maxResources, this.sequenceName, this.concurrency, onCompletion);
        }
    }
}

