/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.html.HtmlHandler;
import io.hyperfoil.http.html.Match;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;

public class MetaRefreshHandler
implements HtmlHandler.TagHandler {
    private static final byte[] META = "meta".getBytes(StandardCharsets.UTF_8);
    private static final byte[] HTTP_EQUIV = "http-equiv".getBytes(StandardCharsets.UTF_8);
    private static final byte[] REFRESH = "refresh".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    private final Processor processor;

    public MetaRefreshHandler(Processor processor) {
        this.processor = processor;
    }

    @Override
    public Processor processor() {
        return this.processor;
    }

    @Override
    public HtmlHandler.HandlerContext newContext() {
        return new Context();
    }

    class Context
    implements HtmlHandler.HandlerContext {
        private final Match meta = new Match();
        private final Match httpEquiv = new Match();
        private final Match content = new Match();
        private final Match refresh = new Match();
        private final ByteBuf valueBuffer = ByteBufAllocator.DEFAULT.buffer();

        Context() {
        }

        @Override
        public void onTag(Session session, boolean close, ByteBuf data, int offset, int length, boolean isLast) {
            if (close) {
                this.endTag(session, true);
            } else {
                this.meta.shift(data, offset, length, isLast, META);
            }
        }

        @Override
        public void onAttr(Session session, ByteBuf data, int offset, int length, boolean isLast) {
            if (this.meta.hasMatch()) {
                this.httpEquiv.shift(data, offset, length, isLast, HTTP_EQUIV);
                this.content.shift(data, offset, length, isLast, CONTENT);
            }
        }

        @Override
        public void onValue(Session session, ByteBuf data, int offset, int length, boolean isLast) {
            if (this.httpEquiv.hasMatch()) {
                this.refresh.shift(data, offset, length, isLast, REFRESH);
                if (this.refresh.hasMatch() && this.valueBuffer.isReadable()) {
                    MetaRefreshHandler.this.processor.process(session, this.valueBuffer, this.valueBuffer.readerIndex(), this.valueBuffer.readableBytes(), true);
                    this.valueBuffer.clear();
                }
            } else if (this.content.hasMatch()) {
                this.valueBuffer.writeBytes(data, offset, length);
                if (this.refresh.hasMatch() && isLast) {
                    MetaRefreshHandler.this.processor.process(session, this.valueBuffer, this.valueBuffer.readerIndex(), this.valueBuffer.readableBytes(), true);
                    this.valueBuffer.clear();
                }
            }
        }

        @Override
        public void endTag(Session session, boolean closing) {
            this.meta.reset();
            this.httpEquiv.reset();
            this.content.reset();
            this.refresh.reset();
            this.valueBuffer.clear();
        }

        @Override
        public void destroy() {
            this.valueBuffer.release();
        }
    }

    public static class Builder
    implements HtmlHandler.TagHandlerBuilder<Builder> {
        private Processor.Builder processor;

        public Builder processor(Processor.Builder processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public MetaRefreshHandler build() {
            return new MetaRefreshHandler(this.processor.build(false));
        }
    }
}

