/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.MappingListBuilder;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.steps.HttpRequestStepBuilder;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class FormGenerator
implements SerializableBiFunction<Session, Connection, ByteBuf> {
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private final SerializableBiConsumer<Session, ByteBuf>[] inputs;

    private FormGenerator(SerializableBiConsumer<Session, ByteBuf>[] inputs) {
        this.inputs = inputs;
    }

    public ByteBuf apply(Session session, Connection connection) {
        if (this.inputs.length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buffer = connection.context().alloc().buffer();
        this.inputs[0].accept((Object)session, (Object)buffer);
        for (int i = 1; i < this.inputs.length; ++i) {
            buffer.ensureWritable(1);
            buffer.writeByte(38);
            this.inputs[i].accept((Object)session, (Object)buffer);
        }
        return buffer;
    }

    public static class ContentTypeWriter
    implements SerializableBiConsumer<Session, HttpRequestWriter> {
        public void accept(Session session, HttpRequestWriter writer) {
            writer.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, FormGenerator.APPLICATION_X_WWW_FORM_URLENCODED);
        }
    }

    public static class InputBuilder {
        private String name;
        private String value;
        private String fromVar;
        private String pattern;

        public SerializableBiConsumer<Session, ByteBuf> build() {
            if (this.value != null && this.fromVar != null && this.pattern != null) {
                throw new BenchmarkDefinitionException("Form input: Must set only one of 'value', 'var', 'pattern'");
            }
            if (this.value == null && this.fromVar == null && this.pattern == null) {
                throw new BenchmarkDefinitionException("Form input: Must set one of 'value' or 'var' or 'pattern'");
            }
            if (this.name == null) {
                throw new BenchmarkDefinitionException("Form input: 'name' must be set.");
            }
            try {
                byte[] nameBytes = URLEncoder.encode(this.name, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8);
                if (this.value != null) {
                    byte[] valueBytes = URLEncoder.encode(this.value, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8);
                    return new ConstantInput(nameBytes, valueBytes);
                }
                if (this.fromVar != null) {
                    ReadAccess access = SessionFactory.readAccess((Object)this.fromVar);
                    return new VariableInput(nameBytes, access);
                }
                Pattern pattern = new Pattern(this.pattern, true);
                return new PatternInput(nameBytes, pattern);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        public InputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputBuilder value(String value) {
            this.value = value;
            return this;
        }

        public InputBuilder fromVar(String var) {
            this.fromVar = var;
            return this;
        }

        public InputBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        private static class ConstantInput
        implements SerializableBiConsumer<Session, ByteBuf> {
            private final byte[] name;
            private final byte[] value;

            ConstantInput(byte[] name, byte[] value) {
                this.name = name;
                this.value = value;
            }

            public void accept(Session session, ByteBuf buf) {
                buf.writeBytes(this.name).writeByte(61).writeBytes(this.value);
            }
        }

        private static class VariableInput
        implements SerializableBiConsumer<Session, ByteBuf> {
            private final byte[] name;
            private final ReadAccess fromVar;

            VariableInput(byte[] name, ReadAccess fromVar) {
                this.name = name;
                this.fromVar = fromVar;
            }

            public void accept(Session session, ByteBuf buf) {
                buf.writeBytes(this.name).writeByte(61);
                Session.Var var = this.fromVar.getVar(session);
                if (!var.isSet()) {
                    throw new IllegalStateException("Variable " + this.fromVar + " was not set yet!");
                }
                if (var.type() == Session.VarType.INTEGER) {
                    Util.intAsText2byteBuf((int)var.intValue(session), (ByteBuf)buf);
                } else if (var.type() == Session.VarType.OBJECT) {
                    Object o = var.objectValue(session);
                    if (o != null) {
                        if (o instanceof byte[]) {
                            buf.writeBytes((byte[])o);
                        } else {
                            Util.urlEncode((String)o.toString(), (ByteBuf)buf);
                        }
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
        }

        private static class PatternInput
        implements SerializableBiConsumer<Session, ByteBuf> {
            private final byte[] name;
            private final Pattern pattern;

            PatternInput(byte[] name, Pattern pattern) {
                this.name = name;
                this.pattern = pattern;
            }

            public void accept(Session session, ByteBuf buf) {
                buf.writeBytes(this.name).writeByte(61);
                this.pattern.accept(session, buf);
            }
        }
    }

    public static class Builder
    implements HttpRequestStepBuilder.BodyGeneratorBuilder,
    MappingListBuilder<InputBuilder> {
        private final ArrayList<InputBuilder> inputs = new ArrayList();

        public InputBuilder addItem() {
            InputBuilder input = new InputBuilder();
            this.inputs.add(input);
            return input;
        }

        @Override
        public SerializableBiFunction<Session, Connection, ByteBuf> build() {
            return new FormGenerator((SerializableBiConsumer[])this.inputs.stream().map(InputBuilder::build).toArray(SerializableBiConsumer[]::new));
        }
    }
}

