/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.PartialBuilder;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.config.SLABuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.generators.StringGeneratorBuilder;
import io.hyperfoil.core.generators.StringGeneratorImplBuilder;
import io.hyperfoil.core.handlers.GzipInflatorProcessor;
import io.hyperfoil.core.handlers.StoreProcessor;
import io.hyperfoil.core.metric.MetricSelector;
import io.hyperfoil.core.metric.PathMetricSelector;
import io.hyperfoil.core.metric.ProvidedMetricSelector;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.DelaySessionStartStep;
import io.hyperfoil.core.steps.StatisticsStep;
import io.hyperfoil.core.util.BitSetResource;
import io.hyperfoil.core.util.DoubleIncrementBuilder;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.UserAgentAppender;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.cookie.CookieAppender;
import io.hyperfoil.http.handlers.FilterHeaderHandler;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.AfterSyncRequestStep;
import io.hyperfoil.http.steps.BeforeSyncRequestStep;
import io.hyperfoil.http.steps.BodyBuilder;
import io.hyperfoil.http.steps.HttpRequestContext;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.hyperfoil.http.steps.PrepareHttpRequestStep;
import io.hyperfoil.http.steps.SendHttpRequestStep;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Name(value="httpRequest")
public class HttpRequestStepBuilder
extends BaseStepBuilder<HttpRequestStepBuilder> {
    private static final Logger log = LogManager.getLogger(SendHttpRequestStep.class);
    private int stepId = -1;
    private HttpMethod.Builder method;
    private StringGeneratorBuilder authority;
    private StringGeneratorBuilder endpoint;
    private StringGeneratorBuilder path;
    private BodyGeneratorBuilder body;
    private final List<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> headerAppenders = new ArrayList<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>>();
    private boolean injectHostHeader = true;
    private MetricSelector metricSelector;
    private long timeout = Long.MIN_VALUE;
    private HttpResponseHandlersImpl.Builder handler = new HttpResponseHandlersImpl.Builder(this);
    private boolean sync = true;
    private SLABuilder.ListBuilder<HttpRequestStepBuilder> sla = null;
    private CompensationBuilder compensation;
    private CompressionBuilder compression = new CompressionBuilder(this);

    public HttpRequestStepBuilder method(HttpMethod method) {
        return this.method(new HttpMethod.ProvidedBuilder(method));
    }

    public HttpRequestStepBuilder method(HttpMethod.Builder method) {
        this.method = method;
        return this;
    }

    public HttpRequestStepBuilder GET(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.GET).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> GET() {
        return this.method(HttpMethod.GET).path();
    }

    public HttpRequestStepBuilder HEAD(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.HEAD).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> HEAD() {
        return this.method(HttpMethod.HEAD).path();
    }

    public HttpRequestStepBuilder POST(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.POST).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> POST() {
        return this.method(HttpMethod.POST).path();
    }

    public HttpRequestStepBuilder PUT(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.PUT).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> PUT() {
        return this.method(HttpMethod.PUT).path();
    }

    public HttpRequestStepBuilder DELETE(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.DELETE).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> DELETE() {
        return this.method(HttpMethod.DELETE).path();
    }

    public HttpRequestStepBuilder OPTIONS(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.OPTIONS).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> OPTIONS() {
        return this.method(HttpMethod.OPTIONS).path();
    }

    public HttpRequestStepBuilder PATCH(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.PATCH).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> PATCH() {
        return this.method(HttpMethod.PATCH).path();
    }

    public HttpRequestStepBuilder TRACE(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.TRACE).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> TRACE() {
        return this.method(HttpMethod.TRACE).path();
    }

    public HttpRequestStepBuilder CONNECT(String path) {
        return (HttpRequestStepBuilder)((Object)this.method(HttpMethod.CONNECT).path().pattern(path).end());
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> CONNECT() {
        return this.method(HttpMethod.CONNECT).path();
    }

    public HttpRequestStepBuilder authority(String authority) {
        return (HttpRequestStepBuilder)((Object)this.authority().pattern(authority).end());
    }

    public HttpRequestStepBuilder authority(SerializableFunction<Session, String> authorityGenerator) {
        return this.authority(() -> authorityGenerator);
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> authority() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.authority((StringGeneratorBuilder)builder);
        return builder;
    }

    public HttpRequestStepBuilder authority(StringGeneratorBuilder authority) {
        this.authority = authority;
        return this;
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> endpoint() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.endpoint = builder;
        return builder;
    }

    public HttpRequestStepBuilder path(String path) {
        return this.path(() -> new Pattern(path, false));
    }

    public StringGeneratorImplBuilder<HttpRequestStepBuilder> path() {
        StringGeneratorImplBuilder builder = new StringGeneratorImplBuilder((Object)this);
        this.path((StringGeneratorBuilder)builder);
        return builder;
    }

    public HttpRequestStepBuilder path(SerializableFunction<Session, String> pathGenerator) {
        return this.path(() -> pathGenerator);
    }

    public HttpRequestStepBuilder path(StringGeneratorBuilder builder) {
        if (this.path != null) {
            throw new BenchmarkDefinitionException("Path generator already set.");
        }
        this.path = builder;
        return this;
    }

    public HttpRequestStepBuilder body(String string) {
        return this.body().pattern(string).endBody();
    }

    public BodyBuilder body() {
        return new BodyBuilder(this);
    }

    public HttpRequestStepBuilder body(SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator) {
        return this.body(() -> bodyGenerator);
    }

    public HttpRequestStepBuilder body(BodyGeneratorBuilder bodyGenerator) {
        if (this.body != null) {
            throw new BenchmarkDefinitionException("Body generator already set.");
        }
        this.body = bodyGenerator;
        return this;
    }

    BodyGeneratorBuilder bodyBuilder() {
        return this.body;
    }

    public HttpRequestStepBuilder headerAppender(SerializableBiConsumer<Session, HttpRequestWriter> headerAppender) {
        this.headerAppenders.add(() -> headerAppender);
        return this;
    }

    public HttpRequestStepBuilder headerAppenders(Collection<? extends Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> appenders) {
        this.headerAppenders.addAll(appenders);
        return this;
    }

    List<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> headerAppenders() {
        return Collections.unmodifiableList(this.headerAppenders);
    }

    public HeadersBuilder headers() {
        return new HeadersBuilder(this);
    }

    public HttpRequestStepBuilder timeout(long timeout, TimeUnit timeUnit) {
        if (timeout <= 0L) {
            throw new BenchmarkDefinitionException("Timeout must be positive!");
        }
        if (this.timeout != Long.MIN_VALUE) {
            throw new BenchmarkDefinitionException("Timeout already set!");
        }
        this.timeout = timeUnit.toMillis(timeout);
        return this;
    }

    public HttpRequestStepBuilder timeout(String timeout) {
        return this.timeout(Util.parseToMillis((String)timeout), TimeUnit.MILLISECONDS);
    }

    public HttpRequestStepBuilder metric(String name) {
        return this.metric((MetricSelector)new ProvidedMetricSelector(name));
    }

    public HttpRequestStepBuilder metric(MetricSelector selector) {
        this.metricSelector = selector;
        return this;
    }

    public PathMetricSelector metric() {
        PathMetricSelector selector = new PathMetricSelector();
        this.metricSelector = selector;
        return selector;
    }

    public HttpResponseHandlersImpl.Builder handler() {
        return this.handler;
    }

    public HttpRequestStepBuilder sync(boolean sync) {
        this.sync = sync;
        return this;
    }

    public SLABuilder.ListBuilder<HttpRequestStepBuilder> sla() {
        if (this.sla == null) {
            this.sla = new SLABuilder.ListBuilder((Object)this);
        }
        return this.sla;
    }

    public CompensationBuilder compensation() {
        this.compensation = new CompensationBuilder(this);
        return this.compensation;
    }

    public HttpRequestStepBuilder compression(String encoding) {
        this.compression().encoding(encoding);
        return this;
    }

    public CompressionBuilder compression() {
        return this.compression;
    }

    public int id() {
        assert (this.stepId >= 0);
        return this.stepId;
    }

    public void prepareBuild() {
        this.stepId = StatisticsStep.nextId();
        Locator locator = Locator.current();
        HttpErgonomics ergonomics = ((HttpPluginBuilder)locator.benchmark().plugin(HttpPluginBuilder.class)).ergonomics();
        if (ergonomics.repeatCookies()) {
            this.headerAppender(new CookieAppender());
        }
        if (ergonomics.userAgentFromSession()) {
            this.headerAppender(new UserAgentAppender());
        }
        BeforeSyncRequestStep beforeSyncRequestStep = null;
        if (this.sync) {
            beforeSyncRequestStep = new BeforeSyncRequestStep();
            locator.sequence().insertBefore(locator).step((Step)beforeSyncRequestStep);
            this.handler.onCompletion(new ReleaseSyncAction(beforeSyncRequestStep));
        }
        if (this.metricSelector == null) {
            String sequenceName = Locator.current().sequence().name();
            this.metricSelector = new ProvidedMetricSelector(sequenceName);
        }
        if (this.compensation != null) {
            this.compensation.prepareBuild();
        }
        this.compression.prepareBuild();
        this.handler.prepareBuild();
        if (this.sync) {
            locator.sequence().insertAfter(locator).step((Step)new AfterSyncRequestStep(beforeSyncRequestStep));
        }
    }

    public List<Step> build() {
        String guessedAuthority = null;
        boolean checkAuthority = true;
        HttpPluginBuilder httpPlugin = (HttpPluginBuilder)Locator.current().benchmark().plugin(HttpPluginBuilder.class);
        SerializableFunction authority = this.authority != null ? this.authority.build() : null;
        SerializableFunction endpoint = this.endpoint != null ? this.endpoint.build() : null;
        HttpBuilder http = null;
        if (authority != null && endpoint != null) {
            throw new BenchmarkDefinitionException("You have set both endpoint (abstract name) and authority (host:port) as the request target; use only one.");
        }
        if (endpoint != null) {
            checkAuthority = false;
            try {
                String guessedEndpoint = (String)endpoint.apply(null);
                if (guessedEndpoint != null) {
                    if (!httpPlugin.validateEndpoint(guessedEndpoint)) {
                        throw new BenchmarkDefinitionException("There is no HTTP endpoint '" + guessedEndpoint + "'");
                    }
                    http = httpPlugin.getHttpByName(guessedEndpoint);
                }
            }
            catch (Throwable guessedEndpoint) {
                // empty catch block
            }
        }
        SerializableFunction pathGenerator = this.path != null ? this.path.build() : null;
        try {
            guessedAuthority = authority == null ? null : (String)authority.apply(null);
        }
        catch (Throwable e) {
            checkAuthority = false;
        }
        if (checkAuthority) {
            http = httpPlugin.getHttp(guessedAuthority);
        }
        if (checkAuthority && !httpPlugin.validateAuthority(guessedAuthority)) {
            String guessedPath = "<unknown path>";
            try {
                if (pathGenerator != null) {
                    guessedPath = (String)pathGenerator.apply(null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (authority == null) {
                throw new BenchmarkDefinitionException(String.format("%s to <default route>%s is invalid as we don't have a default route set.", this.method, guessedPath));
            }
            throw new BenchmarkDefinitionException(String.format("%s to %s%s is invalid - no HTTP configuration defined.", this.method, guessedAuthority, guessedPath));
        }
        if (this.sla == null && http != null && (http.connectionStrategy() == ConnectionStrategy.OPEN_ON_REQUEST || http.connectionStrategy() == ConnectionStrategy.ALWAYS_NEW)) {
            this.sla = (SLABuilder.ListBuilder)new SLABuilder.ListBuilder((Object)this).addItem().blockedRatio(1.01).endSLA();
        }
        SerializableBiConsumer[] headerAppenders = this.headerAppenders.isEmpty() ? null : (SerializableBiConsumer[])this.headerAppenders.stream().map(Supplier::get).toArray(SerializableBiConsumer[]::new);
        SLA[] sla = this.sla != null ? this.sla.build() : SLABuilder.DEFAULT;
        SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator = this.body != null ? this.body.build() : null;
        HttpRequestContext.Key contextKey = new HttpRequestContext.Key();
        PrepareHttpRequestStep prepare = new PrepareHttpRequestStep(this.stepId, contextKey, this.method.build(), (SerializableFunction<Session, String>)endpoint, (SerializableFunction<Session, String>)authority, (SerializableFunction<Session, String>)pathGenerator, this.metricSelector, this.handler.build());
        SendHttpRequestStep step = new SendHttpRequestStep(this.stepId, contextKey, bodyGenerator, headerAppenders, this.injectHostHeader, this.timeout, sla);
        return Arrays.asList(new Step[]{prepare, step});
    }

    public static class CompressionBuilder
    implements BuilderBase<CompressionBuilder> {
        private final HttpRequestStepBuilder parent;
        private String encoding;
        private CompressionType type = CompressionType.CONTENT_ENCODING;

        public CompressionBuilder() {
            this(null);
        }

        public CompressionBuilder(HttpRequestStepBuilder parent) {
            this.parent = parent;
        }

        public CompressionBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public CompressionBuilder type(CompressionType type) {
            this.type = type;
            return this;
        }

        public HttpRequestStepBuilder end() {
            return this.parent;
        }

        public void prepareBuild() {
            if (this.encoding != null) {
                AsciiString expectedHeader;
                if (!this.encoding.equalsIgnoreCase("gzip")) {
                    throw new BenchmarkDefinitionException("The only supported compression encoding is 'gzip'");
                }
                Unique encoding = new Unique(Locator.current().sequence().rootSequence().concurrency() > 0);
                if (this.type == CompressionType.CONTENT_ENCODING) {
                    this.parent.headerAppender(new StaticHeaderWriter(HttpHeaderNames.ACCEPT_ENCODING.toString(), this.encoding));
                    expectedHeader = HttpHeaderNames.CONTENT_ENCODING;
                } else if (this.type == CompressionType.TRANSFER_ENCODING) {
                    this.parent.headerAppender(new StaticHeaderWriter((CharSequence)HttpHeaderNames.TE, this.encoding));
                    expectedHeader = HttpHeaderNames.TRANSFER_ENCODING;
                } else {
                    throw new BenchmarkDefinitionException("Unexpected compression type: " + this.type);
                }
                this.parent.handler.header(((FilterHeaderHandler.Builder)new FilterHeaderHandler.Builder().header().equalTo((CharSequence)expectedHeader.toString()).end()).processor((Processor.Builder)new StoreProcessor.Builder().toVar((Object)encoding)));
                this.parent.handler.wrapBodyHandlers(handlers -> ((GzipInflatorProcessor.Builder)new GzipInflatorProcessor.Builder().processors(handlers)).encodingVar((Object)encoding));
            }
        }
    }

    public static interface BodyGeneratorBuilder
    extends BuilderBase<BodyGeneratorBuilder> {
        public SerializableBiFunction<Session, Connection, ByteBuf> build();
    }

    public static class HeadersBuilder
    extends PairBuilder.OfString
    implements PartialBuilder {
        private final HttpRequestStepBuilder parent;

        public HeadersBuilder(HttpRequestStepBuilder builder) {
            this.parent = builder;
        }

        public HeadersBuilder header(CharSequence header, CharSequence value) {
            this.warnIfUsingHostHeader(header);
            this.parent.headerAppender(new StaticHeaderWriter(header, value));
            return this;
        }

        public void accept(String header, String value) {
            this.withKey(header).pattern(value);
        }

        public HttpRequestStepBuilder endHeaders() {
            return this.parent;
        }

        public PartialHeadersBuilder withKey(String key) {
            this.warnIfUsingHostHeader(key);
            return new PartialHeadersBuilder(this, key);
        }

        private void warnIfUsingHostHeader(CharSequence key) {
            if (key.toString().equalsIgnoreCase("host")) {
                log.warn("Setting `host` header explicitly is not recommended. Use the HTTP host and adjust actual target using `addresses` property.");
                this.parent.injectHostHeader = false;
            }
        }
    }

    public static class CompensationBuilder {
        private static final String DELAY_SESSION_START = "__delay-session-start";
        private final HttpRequestStepBuilder parent;
        public SerializableBiFunction<String, String, String> metricSelector;
        public double targetRate;
        public double targetRateIncrement;
        private DoubleIncrementBuilder targetRateBuilder;

        public CompensationBuilder(HttpRequestStepBuilder parent) {
            this.parent = parent;
        }

        public CompensationBuilder targetRate(double targetRate) {
            this.targetRate = targetRate;
            return this;
        }

        public DoubleIncrementBuilder targetRate() {
            this.targetRateBuilder = new DoubleIncrementBuilder((base, inc) -> {
                this.targetRate = base;
                this.targetRateIncrement = inc;
            });
            return this.targetRateBuilder;
        }

        public CompensationBuilder metric(String name) {
            this.metricSelector = new ProvidedMetricSelector(name);
            return this;
        }

        public PathMetricSelector metric() {
            PathMetricSelector metricSelector;
            this.metricSelector = metricSelector = new PathMetricSelector();
            return metricSelector;
        }

        public void prepareBuild() {
            ScenarioBuilder scenario;
            PhaseBuilder phaseBuilder;
            if (this.targetRateBuilder != null) {
                this.targetRateBuilder.apply();
            }
            if (!((phaseBuilder = (scenario = Locator.current().scenario()).endScenario()) instanceof PhaseBuilder.Always)) {
                throw new BenchmarkDefinitionException("delaySessionStart step makes sense only in phase type 'always'");
            }
            if (!scenario.hasSequence(DELAY_SESSION_START)) {
                List prev = scenario.resetInitialSequences();
                scenario.initialSequence(DELAY_SESSION_START).step((Step)new DelaySessionStartStep((String[])prev.stream().map(SequenceBuilder::name).toArray(String[]::new), this.targetRate, this.targetRateIncrement, true));
            } else {
                log.warn("Scenario for phase {} contains multiple compensating HTTP requests: make sure that all use the same rate.", (Object)phaseBuilder.name());
            }
            this.parent.handler.onCompletion(new CompensatedResponseRecorder.Builder().metric(this.metricSelector));
        }

        public HttpRequestStepBuilder end() {
            return this.parent;
        }
    }

    private static class ReleaseSyncAction
    implements Action {
        @Visitor.Ignore
        private final BeforeSyncRequestStep beforeSyncRequestStep;

        ReleaseSyncAction(BeforeSyncRequestStep beforeSyncRequestStep) {
            this.beforeSyncRequestStep = beforeSyncRequestStep;
        }

        public void run(Session s) {
            ((BitSetResource)s.getResource((Session.ResourceKey)this.beforeSyncRequestStep)).set(s.currentSequence().index());
        }
    }

    public static class CompensatedResponseRecorder
    implements Action {
        private final int stepId;
        private final SerializableBiFunction<String, String, String> metricSelector;

        public CompensatedResponseRecorder(int stepId, SerializableBiFunction<String, String, String> metricSelector) {
            this.stepId = stepId;
            this.metricSelector = metricSelector;
        }

        public void run(Session session) {
            HttpRequest request = HttpRequest.ensure(session.currentRequest());
            if (request == null) {
                return;
            }
            String metric = (String)this.metricSelector.apply((Object)request.authority, (Object)request.path);
            Statistics statistics = session.statistics(this.stepId, metric);
            DelaySessionStartStep.Holder holder = (DelaySessionStartStep.Holder)session.getResource(DelaySessionStartStep.KEY);
            long startTimeMs = holder.lastStartTime();
            statistics.incrementRequests(startTimeMs);
            if (request.cacheControl.wasCached) {
                HttpStats.addCacheHit(statistics, startTimeMs);
            } else {
                long now = System.currentTimeMillis();
                log.trace("#{} Session start {}, now {}, diff {}", (Object)session.uniqueId(), (Object)startTimeMs, (Object)now, (Object)(now - startTimeMs));
                statistics.recordResponse(startTimeMs, TimeUnit.MILLISECONDS.toNanos(now - startTimeMs));
            }
        }

        public static class Builder
        implements Action.Builder {
            private SerializableBiFunction<String, String, String> metricSelector;

            public Action build() {
                HttpRequestStepBuilder stepBuilder = (HttpRequestStepBuilder)Locator.current().step();
                PrefixMetricSelector metricSelector = this.metricSelector;
                if (metricSelector == null) {
                    metricSelector = new PrefixMetricSelector("compensated-", (SerializableBiFunction<String, String, String>)stepBuilder.metricSelector);
                }
                return new CompensatedResponseRecorder(stepBuilder.id(), metricSelector);
            }

            public Builder metric(SerializableBiFunction<String, String, String> metricSelector) {
                this.metricSelector = metricSelector;
                return this;
            }
        }
    }

    private static class FromVarHeaderWriter
    implements SerializableBiConsumer<Session, HttpRequestWriter> {
        private final CharSequence header;
        private final ReadAccess fromVar;

        FromVarHeaderWriter(CharSequence header, ReadAccess fromVar) {
            this.fromVar = fromVar;
            this.header = header;
        }

        public void accept(Session session, HttpRequestWriter writer) {
            Object value = this.fromVar.getObject(session);
            if (value instanceof CharSequence) {
                writer.putHeader(this.header, (CharSequence)value);
            } else {
                log.error("#{} Cannot convert variable {}: {} to CharSequence", (Object)session.uniqueId(), (Object)this.fromVar, value);
            }
        }
    }

    public static class PartialHeadersBuilder
    implements InitFromParam<PartialHeadersBuilder> {
        private final HeadersBuilder parent;
        private final String header;
        private boolean added;

        private PartialHeadersBuilder(HeadersBuilder parent, String header) {
            this.parent = parent;
            this.header = header;
        }

        public PartialHeadersBuilder init(String param) {
            return this.pattern(param);
        }

        public PartialHeadersBuilder fromVar(String var) {
            this.ensureOnce();
            this.parent.parent.headerAppenders.add(() -> new FromVarHeaderWriter(this.header, SessionFactory.readAccess((Object)var)));
            return this;
        }

        public PartialHeadersBuilder pattern(String patternString) {
            this.ensureOnce();
            this.parent.parent.headerAppenders.add(() -> new PatternHeaderWriter(this.header, new Pattern(patternString, false)));
            return this;
        }

        private void ensureOnce() {
            if (this.added) {
                throw new BenchmarkDefinitionException("Trying to add header " + this.header + " twice. Use only one of: fromVar, pattern");
            }
            this.added = true;
        }

        public HeadersBuilder end() {
            return this.parent;
        }

        private static class PatternHeaderWriter
        implements SerializableBiConsumer<Session, HttpRequestWriter> {
            private final String header;
            private final Pattern pattern;

            PatternHeaderWriter(String header, Pattern pattern) {
                this.header = header;
                this.pattern = pattern;
            }

            public void accept(Session session, HttpRequestWriter writer) {
                writer.putHeader(this.header, this.pattern.apply(session));
            }
        }
    }

    private static class StaticHeaderWriter
    implements SerializableBiConsumer<Session, HttpRequestWriter> {
        private final CharSequence header;
        private final CharSequence value;

        private StaticHeaderWriter(CharSequence header, CharSequence value) {
            this.header = header;
            this.value = value;
        }

        public void accept(Session session, HttpRequestWriter writer) {
            writer.putHeader(this.header, this.value);
        }
    }

    private static class PrefixMetricSelector
    implements SerializableBiFunction<String, String, String> {
        private final String prefix;
        private final SerializableBiFunction<String, String, String> delegate;

        private PrefixMetricSelector(String prefix, SerializableBiFunction<String, String, String> delegate) {
            this.prefix = prefix;
            this.delegate = delegate;
        }

        public String apply(String authority, String path) {
            return this.prefix + (String)this.delegate.apply((Object)authority, (Object)path);
        }
    }

    public static enum CompressionType {
        CONTENT_ENCODING,
        TRANSFER_ENCODING;

    }
}

