/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.handlers.ConditionalAction;
import io.hyperfoil.core.handlers.ConditionalProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.AwaitDelayStep;
import io.hyperfoil.core.steps.PushQueueAction;
import io.hyperfoil.core.steps.ScheduleDelayStep;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.function.SerializableToLongFunction;
import io.hyperfoil.http.api.FollowRedirect;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.cookie.CookieRecorder;
import io.hyperfoil.http.handlers.ConditionalHeaderHandler;
import io.hyperfoil.http.handlers.Location;
import io.hyperfoil.http.handlers.RangeStatusValidator;
import io.hyperfoil.http.handlers.Redirect;
import io.hyperfoil.http.html.HtmlHandler;
import io.hyperfoil.http.html.MetaRefreshHandler;
import io.hyperfoil.http.html.RefreshHandler;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpRequestStepBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class HttpResponseHandlersImpl
implements HttpResponseHandlers,
Serializable {
    private static final Logger log = LogManager.getLogger(HttpResponseHandlersImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    final StatusHandler[] statusHandlers;
    final HeaderHandler[] headerHandlers;
    final Processor[] bodyHandlers;
    final Action[] completionHandlers;
    final RawBytesHandler[] rawBytesHandlers;

    private HttpResponseHandlersImpl(StatusHandler[] statusHandlers, HeaderHandler[] headerHandlers, Processor[] bodyHandlers, Action[] completionHandlers, RawBytesHandler[] rawBytesHandlers) {
        this.statusHandlers = statusHandlers;
        this.headerHandlers = headerHandlers;
        this.bodyHandlers = bodyHandlers;
        this.completionHandlers = completionHandlers;
        this.rawBytesHandlers = rawBytesHandlers;
    }

    @Override
    public void handleStatus(HttpRequest request, int status, String reason) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace("#{} Ignoring status {} as the request has been marked completed (failed).", (Object)session.uniqueId(), (Object)status);
            }
            return;
        }
        if (trace) {
            log.trace("#{} Received status {}: {}", (Object)session.uniqueId(), (Object)status, (Object)reason);
        }
        try {
            switch (request.method) {
                case GET: 
                case HEAD: {
                    if (status == 200 || !request.hasCacheControl()) break;
                    request.cacheControl.noStore = true;
                    break;
                }
                case POST: 
                case PUT: 
                case DELETE: 
                case PATCH: {
                    if (!request.hasCacheControl()) break;
                    if (status >= 200 && status <= 399) {
                        HttpCache.get(request.session).invalidate(request.authority, request.path);
                        request.cacheControl.invalidate = true;
                    }
                    request.cacheControl.noStore = true;
                }
            }
            HttpStats.addStatus(request.statistics(), request.startTimestampMillis(), status);
            if (this.statusHandlers != null) {
                for (Serializable serializable : this.statusHandlers) {
                    serializable.handleStatus(request, status);
                }
            }
            if (this.headerHandlers != null) {
                for (Serializable serializable : this.headerHandlers) {
                    serializable.beforeHeaders(request);
                }
            }
            if (this.bodyHandlers != null) {
                for (Serializable serializable : this.bodyHandlers) {
                    serializable.before(request.session);
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Message)new FormattedMessage("#{} Response status processing failed on {}", (Object)session.uniqueId(), (Object)this), t);
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace("#{} Ignoring header on a failed request: {}: {}", (Object)session.uniqueId(), (Object)header, (Object)value);
            }
            return;
        }
        if (trace) {
            log.trace("#{} Received header {}: {}", (Object)session.uniqueId(), (Object)header, (Object)value);
        }
        try {
            HttpCache httpCache;
            HttpCache httpCache2 = httpCache = request.hasCacheControl() ? HttpCache.get(session) : null;
            if (httpCache != null && request.cacheControl.invalidate && (AsciiString.contentEqualsIgnoreCase((CharSequence)header, (CharSequence)HttpHeaderNames.LOCATION) || AsciiString.contentEqualsIgnoreCase((CharSequence)header, (CharSequence)HttpHeaderNames.CONTENT_LOCATION))) {
                httpCache.invalidate(request.authority, value);
            }
            if (this.headerHandlers != null) {
                for (HeaderHandler handler : this.headerHandlers) {
                    handler.handleHeader(request, header, value);
                }
            }
            if (httpCache != null) {
                httpCache.responseHeader(request, header, value);
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Message)new FormattedMessage("#{} Response header processing failed on {}", (Object)session.uniqueId(), (Object)this), t);
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleThrowable(HttpRequest request, Throwable throwable) {
        Session session = request.session;
        if (log.isDebugEnabled()) {
            log.debug((Message)new FormattedMessage("#{} {} Received exception", (Object)session.uniqueId(), (Object)request), throwable);
        }
        if (request.isCompleted()) {
            if (trace) {
                log.trace("#{} Request has been already completed", (Object)session.uniqueId());
            }
            return;
        }
        if (request.isValid()) {
            request.markInvalid();
        }
        try {
            if (request.isRunning()) {
                request.statistics().incrementConnectionErrors(request.startTimestampMillis());
                request.setCompleting();
                if (this.completionHandlers != null) {
                    for (Action handler : this.completionHandlers) {
                        handler.run(session);
                    }
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            t.addSuppressed(throwable);
            log.error((Message)new FormattedMessage("#{} Exception {} thrown while handling another exception: ", (Object)session.uniqueId(), (Object)throwable.toString()), t);
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            session.stop();
        }
        finally {
            request.setCompleted();
        }
    }

    @Override
    public void handleBodyPart(HttpRequest request, ByteBuf data, int offset, int length, boolean isLastPart) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace("#{} Ignoring body part ({} bytes) on a failed request.", (Object)session.uniqueId(), (Object)data.readableBytes());
            }
            return;
        }
        if (trace) {
            log.trace("#{} Received part ({} bytes):\n{}", (Object)session.uniqueId(), (Object)length, (Object)data.toString(offset, length, StandardCharsets.UTF_8));
        }
        try {
            int dataStartIndex = data.readerIndex();
            if (this.bodyHandlers != null) {
                for (Processor handler : this.bodyHandlers) {
                    handler.process(request.session, data, offset, length, isLastPart);
                    data.readerIndex(dataStartIndex);
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Message)new FormattedMessage("#{} Response body processing failed on {}", (Object)session.uniqueId(), (Object)this), t);
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEnd(HttpRequest request, boolean executed) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace("#{} Request has been already completed.", (Object)session.uniqueId());
            }
            return;
        }
        if (trace) {
            log.trace("#{} Completed request on {}", (Object)session.uniqueId(), (Object)request.connection());
        }
        try {
            if (request.isRunning()) {
                request.setCompleting();
                if (executed) {
                    request.recordResponse(System.nanoTime());
                    if (this.headerHandlers != null) {
                        for (HeaderHandler headerHandler : this.headerHandlers) {
                            headerHandler.afterHeaders(request);
                        }
                    }
                    if (this.bodyHandlers != null) {
                        for (Processor processor : this.bodyHandlers) {
                            processor.after(request.session);
                        }
                    }
                    if (request.hasCacheControl()) {
                        HttpCache.get(request.session).tryStore(request);
                    }
                }
                if (this.completionHandlers != null) {
                    for (Action action : this.completionHandlers) {
                        action.run(session);
                    }
                }
            }
        }
        catch (SessionStopException sessionStopException) {
            throw sessionStopException;
        }
        catch (Throwable throwable) {
            log.error((Message)new FormattedMessage("#{} Response completion failed on {}, stopping the session.", (Object)request.session.uniqueId(), (Object)this), throwable);
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
        finally {
            if (executed && !request.isValid() && !request.isCompleted()) {
                request.statistics().addInvalid(request.startTimestampMillis());
            }
            request.setCompleted();
        }
    }

    @Override
    public void handleRawRequest(HttpRequest request, ByteBuf data, int offset, int length) {
        if (this.rawBytesHandlers == null) {
            return;
        }
        try {
            for (RawBytesHandler rawBytesHandler : this.rawBytesHandlers) {
                rawBytesHandler.onRequest((Request)request, data, offset, length);
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Message)new FormattedMessage("#{} Raw request processing failed on {}", (Object)request.session.uniqueId(), (Object)this), t);
            request.markInvalid();
            request.session.stop();
        }
    }

    @Override
    public void handleRawResponse(HttpRequest request, ByteBuf data, int offset, int length, boolean isLastPart) {
        if (this.rawBytesHandlers == null) {
            return;
        }
        try {
            for (RawBytesHandler rawBytesHandler : this.rawBytesHandlers) {
                rawBytesHandler.onResponse((Request)request, data, offset, length, isLastPart);
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Message)new FormattedMessage("#{} Raw response processing failed on {}", (Object)request.session.uniqueId(), (Object)this), t);
            request.markInvalid();
            request.session.stop();
        }
    }

    private static class StopOnInvalidAction
    implements Action {
        private static final Action INSTANCE = new StopOnInvalidAction();

        private StopOnInvalidAction() {
        }

        public void run(Session session) {
            Request request = session.currentRequest();
            if (!request.isValid()) {
                log.info("#{} Stopping session due to invalid response {} on connection {}", (Object)session.uniqueId(), (Object)request, (Object)request.connection());
                session.stop();
            }
        }
    }

    public static class Builder
    implements BuilderBase<Builder> {
        private final HttpRequestStepBuilder parent;
        private Boolean autoRangeCheck;
        private Boolean stopOnInvalid;
        private FollowRedirect followRedirect;
        private List<StatusHandler.Builder> statusHandlers = new ArrayList<StatusHandler.Builder>();
        private List<HeaderHandler.Builder> headerHandlers = new ArrayList<HeaderHandler.Builder>();
        private List<Processor.Builder> bodyHandlers = new ArrayList<Processor.Builder>();
        private List<Action.Builder> completionHandlers = new ArrayList<Action.Builder>();
        private List<RawBytesHandler.Builder> rawBytesHandlers = new ArrayList<RawBytesHandler.Builder>();

        public static Builder forTesting() {
            return new Builder(null);
        }

        public Builder(HttpRequestStepBuilder parent) {
            this.parent = parent;
        }

        public Builder status(StatusHandler.Builder builder) {
            this.statusHandlers.add(builder);
            return this;
        }

        public Builder status(StatusHandler handler) {
            this.statusHandlers.add(() -> handler);
            return this;
        }

        public ServiceLoadedBuilderProvider<StatusHandler.Builder> status() {
            return new ServiceLoadedBuilderProvider(StatusHandler.Builder.class, this.statusHandlers::add);
        }

        public Builder header(HeaderHandler handler) {
            return this.header(() -> handler);
        }

        public Builder header(HeaderHandler.Builder builder) {
            this.headerHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<HeaderHandler.Builder> header() {
            return new ServiceLoadedBuilderProvider(HeaderHandler.Builder.class, this.headerHandlers::add);
        }

        public Builder body(Processor.Builder builder) {
            this.bodyHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<Processor.Builder> body() {
            return new ServiceLoadedBuilderProvider(Processor.Builder.class, this.bodyHandlers::add);
        }

        public Builder onCompletion(Action handler) {
            return this.onCompletion(() -> handler);
        }

        public Builder onCompletion(Action.Builder builder) {
            this.completionHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> onCompletion() {
            return new ServiceLoadedBuilderProvider(Action.Builder.class, this.completionHandlers::add);
        }

        public Builder rawBytes(RawBytesHandler handler) {
            this.rawBytesHandlers.add(() -> handler);
            return this;
        }

        public Builder rawBytes(RawBytesHandler.Builder builder) {
            this.rawBytesHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<RawBytesHandler.Builder> rawBytes() {
            return new ServiceLoadedBuilderProvider(RawBytesHandler.Builder.class, this::rawBytes);
        }

        public Builder autoRangeCheck(boolean autoRangeCheck) {
            this.autoRangeCheck = autoRangeCheck;
            return this;
        }

        public Builder stopOnInvalid(boolean stopOnInvalid) {
            this.stopOnInvalid = stopOnInvalid;
            return this;
        }

        public Builder followRedirect(FollowRedirect followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public HttpRequestStepBuilder endHandler() {
            return this.parent;
        }

        public Builder wrapBodyHandlers(Function<Collection<Processor.Builder>, Processor.Builder> func) {
            Processor.Builder wrapped = func.apply(this.bodyHandlers);
            this.bodyHandlers = new ArrayList<Processor.Builder>();
            this.bodyHandlers.add(wrapped);
            return this;
        }

        public void prepareBuild() {
            HttpErgonomics ergonomics = ((HttpPluginBuilder)Locator.current().benchmark().plugin(HttpPluginBuilder.class)).ergonomics();
            if (ergonomics.repeatCookies()) {
                this.header(new CookieRecorder());
            }
            this.statusHandlers.forEach(BuilderBase::prepareBuild);
            this.headerHandlers.forEach(BuilderBase::prepareBuild);
            this.bodyHandlers.forEach(BuilderBase::prepareBuild);
            this.completionHandlers.forEach(BuilderBase::prepareBuild);
            this.rawBytesHandlers.forEach(BuilderBase::prepareBuild);
            if (this.autoRangeCheck != null ? this.autoRangeCheck != false : ergonomics.autoRangeCheck()) {
                this.statusHandlers.add(new RangeStatusValidator.Builder().min(200).max(399));
            }
            if (this.stopOnInvalid != null ? this.stopOnInvalid != false : ergonomics.stopOnInvalid()) {
                this.completionHandlers.add(() -> StopOnInvalidAction.INSTANCE);
            }
            FollowRedirect followRedirect = this.followRedirect != null ? this.followRedirect : ergonomics.followRedirect();
            switch (followRedirect) {
                case LOCATION_ONLY: {
                    this.applyRedirect(true, false);
                    break;
                }
                case HTML_ONLY: {
                    this.applyRedirect(false, true);
                    break;
                }
                case ALWAYS: {
                    this.applyRedirect(true, true);
                }
            }
        }

        private void applyRedirect(boolean location, boolean html) {
            Locator locator = Locator.current();
            Unique coordsVar = new Unique();
            String redirectSequenceName = String.format("%s_redirect_%08x", locator.sequence().name(), ThreadLocalRandom.current().nextInt());
            String delaySequenceName = String.format("%s_delay_%08x", locator.sequence().name(), ThreadLocalRandom.current().nextInt());
            Queue.Key queueKey = new Queue.Key();
            Queue.Key delayedQueueKey = new Queue.Key();
            Unique delayedCoordVar = new Unique();
            int concurrency = Math.max(1, locator.sequence().rootSequence().concurrency());
            if (html) {
                Unique delay = new Unique();
                SequenceBuilder delaySequence = locator.scenario().sequence(delaySequenceName);
                ((SequenceBuilder)((SequenceBuilder)((SequenceBuilder)delaySequence.concurrency(Math.max(1, concurrency)).step(() -> {
                    ReadAccess inputVar = SessionFactory.sequenceScopedReadAccess((Object)delayedCoordVar);
                    ObjectAccess delayVar = SessionFactory.sequenceScopedObjectAccess((Object)delay);
                    SerializableToLongFunction & Serializable delayFunc = (SerializableToLongFunction & Serializable)session -> TimeUnit.SECONDS.toMillis(((Redirect.Coords)inputVar.getObject((Session)session)).delay);
                    return new ScheduleDelayStep(delayVar, ScheduleDelayStep.Type.FROM_NOW, (SerializableToLongFunction)delayFunc);
                })).step(() -> new AwaitDelayStep(SessionFactory.sequenceScopedReadAccess((Object)delay)))).stepBuilder((StepBuilder)new StepBuilder.ActionAdapter(() -> new PushQueueAction(SessionFactory.sequenceScopedReadAccess((Object)delayedCoordVar), queueKey)))).step((Step & Serializable)session -> {
                    ((Queue)session.getResource((Session.ResourceKey)delayedQueueKey)).consumed(session);
                    return true;
                });
                Locator.push(null, (BaseSequenceBuilder)delaySequence);
                delaySequence.prepareBuild();
                Locator.pop();
            }
            int redirectConcurrency = 2 * concurrency;
            LimitedPoolResource.Key poolKey = new LimitedPoolResource.Key();
            Unique newTempCoordsVar = new Unique(true);
            HttpRequestStepBuilder step = (HttpRequestStepBuilder)locator.step();
            HttpRequestStepBuilder.BodyGeneratorBuilder bodyBuilder = step.bodyBuilder();
            HttpRequestStepBuilder httpRequest = new HttpRequestStepBuilder().method(() -> new Redirect.GetMethod(SessionFactory.sequenceScopedReadAccess((Object)coordsVar))).path(() -> new Location.GetPath(SessionFactory.sequenceScopedReadAccess((Object)coordsVar))).authority(() -> new Location.GetAuthority(SessionFactory.sequenceScopedReadAccess((Object)coordsVar))).headerAppenders(step.headerAppenders()).body(bodyBuilder == null ? null : (HttpRequestStepBuilder.BodyGeneratorBuilder)bodyBuilder.copy(null)).sync(false).handler().followRedirect(FollowRedirect.NEVER).endHandler();
            if (location) {
                httpRequest.handler().status((StatusHandler.Builder)new Redirect.StatusHandler.Builder().poolKey((LimitedPoolResource.Key<Redirect.Coords>)poolKey).concurrency(redirectConcurrency).coordsVar(newTempCoordsVar).handlers(this.statusHandlers)).header(new Redirect.LocationRecorder.Builder().originalSequenceSupplier(() -> new Redirect.GetOriginalSequence(SessionFactory.sequenceScopedReadAccess((Object)coordsVar))).concurrency(redirectConcurrency).inputVar(newTempCoordsVar).outputVar(coordsVar).queueKey((Session.ResourceKey<Queue>)queueKey).sequence(redirectSequenceName));
            }
            if (!this.headerHandlers.isEmpty()) {
                Redirect.WrappingHeaderHandler.Builder wrappingHandler = (Redirect.WrappingHeaderHandler.Builder)new Redirect.WrappingHeaderHandler.Builder().coordVar(coordsVar).handlers(this.headerHandlers);
                if (location) {
                    httpRequest.handler().header((HeaderHandler.Builder)((ConditionalHeaderHandler.Builder)new ConditionalHeaderHandler.Builder().condition().stringCondition().fromVar((Object)newTempCoordsVar).isSet(false).end()).handler(wrappingHandler));
                } else {
                    httpRequest.handler().header(wrappingHandler);
                }
            }
            if (!this.bodyHandlers.isEmpty() || html) {
                Consumer<Processor.Builder> handlerConsumer;
                Redirect.WrappingProcessor.Builder wrappingProcessor = (Redirect.WrappingProcessor.Builder)new Redirect.WrappingProcessor.Builder().coordVar(coordsVar).processors(this.bodyHandlers);
                if (location) {
                    if (!this.bodyHandlers.isEmpty() || html) {
                        ConditionalProcessor.Builder conditionalBodyHandler = ((ConditionalProcessor.Builder)new ConditionalProcessor.Builder().condition().stringCondition().fromVar((Object)newTempCoordsVar).isSet(false).end()).processor((Processor.Builder)wrappingProcessor);
                        handlerConsumer = arg_0 -> ((ConditionalProcessor.Builder)conditionalBodyHandler).processor(arg_0);
                        httpRequest.handler().body((Processor.Builder)conditionalBodyHandler);
                    } else {
                        handlerConsumer = null;
                    }
                } else {
                    assert (html);
                    httpRequest.handler().body((Processor.Builder)wrappingProcessor);
                    handlerConsumer = httpRequest.handler()::body;
                }
                if (html) {
                    handlerConsumer.accept(new HtmlHandler.Builder().handler(new MetaRefreshHandler.Builder().processor(fragmented -> new RefreshHandler(queueKey, delayedQueueKey, (LimitedPoolResource.Key<Redirect.Coords>)poolKey, redirectConcurrency, SessionFactory.objectAccess((Object)coordsVar), SessionFactory.objectAccess((Object)delayedCoordVar), redirectSequenceName, delaySequenceName, SessionFactory.objectAccess((Object)newTempCoordsVar), new Redirect.GetOriginalSequence(SessionFactory.sequenceScopedReadAccess((Object)coordsVar))))));
                }
            }
            if (!this.completionHandlers.isEmpty()) {
                httpRequest.handler().onCompletion((Action.Builder)((ConditionalAction.Builder)new ConditionalAction.Builder().condition().stringCondition().fromVar((Object)newTempCoordsVar).isSet(false).end()).action((Action.Builder)new Redirect.WrappingAction.Builder().coordVar(coordsVar).actions(this.completionHandlers)));
            }
            httpRequest.handler().onCompletion(() -> new Location.Complete(poolKey, queueKey, SessionFactory.sequenceScopedObjectAccess((Object)coordsVar)));
            SequenceBuilder redirectSequence = ((SequenceBuilder)locator.scenario().sequence(redirectSequenceName).concurrency(redirectConcurrency).stepBuilder((StepBuilder)httpRequest)).rootSequence();
            Locator.push(null, (BaseSequenceBuilder)redirectSequence);
            redirectSequence.prepareBuild();
            Locator.pop();
            Unique tempCoordsVar = new Unique(locator.sequence().rootSequence().concurrency() > 0);
            if (location) {
                this.statusHandlers = Collections.singletonList(new Redirect.StatusHandler.Builder().poolKey((LimitedPoolResource.Key<Redirect.Coords>)poolKey).concurrency(redirectConcurrency).coordsVar(tempCoordsVar).handlers(this.statusHandlers));
                ArrayList<HeaderHandler.Builder> headerHandlers = new ArrayList<HeaderHandler.Builder>();
                headerHandlers.add(new Redirect.LocationRecorder.Builder().originalSequenceSupplier(() -> Session::currentSequence).concurrency(redirectConcurrency).inputVar(tempCoordsVar).outputVar(coordsVar).queueKey((Session.ResourceKey<Queue>)queueKey).sequence(redirectSequenceName));
                if (!this.headerHandlers.isEmpty()) {
                    headerHandlers.add((HeaderHandler.Builder)((ConditionalHeaderHandler.Builder)new ConditionalHeaderHandler.Builder().condition().stringCondition().fromVar((Object)tempCoordsVar).isSet(false).end()).handlers(this.headerHandlers));
                }
                this.headerHandlers = headerHandlers;
            }
            if (!this.bodyHandlers.isEmpty() || html) {
                Consumer<Processor.Builder> handlerConsumer;
                ConditionalProcessor.Builder conditionalBodyHandler = null;
                if (location) {
                    conditionalBodyHandler = ((ConditionalProcessor.Builder)new ConditionalProcessor.Builder().condition().stringCondition().fromVar((Object)tempCoordsVar).isSet(false).end()).processors(this.bodyHandlers);
                    handlerConsumer = arg_0 -> ((ConditionalProcessor.Builder)conditionalBodyHandler).processor(arg_0);
                } else {
                    handlerConsumer = this.bodyHandlers::add;
                }
                if (html) {
                    handlerConsumer.accept(new HtmlHandler.Builder().handler(new MetaRefreshHandler.Builder().processor(fragmented -> new RefreshHandler(queueKey, delayedQueueKey, (LimitedPoolResource.Key<Redirect.Coords>)poolKey, redirectConcurrency, SessionFactory.objectAccess((Object)coordsVar), SessionFactory.objectAccess((Object)delayedCoordVar), redirectSequenceName, delaySequenceName, SessionFactory.objectAccess((Object)tempCoordsVar), (SerializableFunction<Session, SequenceInstance>)((SerializableFunction & Serializable)Session::currentSequence)))));
                }
                if (location) {
                    this.bodyHandlers = Collections.singletonList(conditionalBodyHandler);
                }
            }
            if (!this.completionHandlers.isEmpty()) {
                this.completionHandlers = Collections.singletonList(((ConditionalAction.Builder)new ConditionalAction.Builder().condition().stringCondition().fromVar((Object)tempCoordsVar).isSet(false).end()).actions(this.completionHandlers));
            }
        }

        public HttpResponseHandlersImpl build() {
            return new HttpResponseHandlersImpl(Builder.toArray(this.statusHandlers, StatusHandler.Builder::build, StatusHandler[]::new), Builder.toArray(this.headerHandlers, HeaderHandler.Builder::build, HeaderHandler[]::new), Builder.toArray(this.bodyHandlers, b -> b.build(true), Processor[]::new), Builder.toArray(this.completionHandlers, Action.Builder::build, Action[]::new), Builder.toArray(this.rawBytesHandlers, RawBytesHandler.Builder::build, RawBytesHandler[]::new));
        }

        private static <B, T> T[] toArray(List<B> list, Function<B, T> build, IntFunction<T[]> generator) {
            if (list.isEmpty()) {
                return null;
            }
            return list.stream().map(build).toArray(generator);
        }
    }
}

