/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.metric.MetricSelector;
import io.hyperfoil.core.steps.StatisticsStep;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.steps.HttpRequestContext;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrepareHttpRequestStep
extends StatisticsStep
implements ResourceUtilizer {
    private static final Logger log = LogManager.getLogger(PrepareHttpRequestStep.class);
    final HttpRequestContext.Key contextKey;
    final SerializableFunction<Session, HttpMethod> method;
    final SerializableFunction<Session, String> endpoint;
    final SerializableFunction<Session, String> authority;
    final SerializableFunction<Session, String> pathGenerator;
    final MetricSelector metricSelector;
    final HttpResponseHandlersImpl handler;

    public PrepareHttpRequestStep(int stepId, HttpRequestContext.Key contextKey, SerializableFunction<Session, HttpMethod> method, SerializableFunction<Session, String> endpoint, SerializableFunction<Session, String> authority, SerializableFunction<Session, String> pathGenerator, MetricSelector metricSelector, HttpResponseHandlersImpl handler) {
        super(stepId);
        this.contextKey = contextKey;
        this.method = method;
        this.endpoint = endpoint;
        this.authority = authority;
        this.pathGenerator = pathGenerator;
        this.metricSelector = metricSelector;
        this.handler = handler;
    }

    public boolean invoke(Session session) {
        SequenceInstance sequence = session.currentSequence();
        HttpRequestContext context = (HttpRequestContext)session.getResource((Session.ResourceKey)this.contextKey);
        if (context.request == null) {
            context.request = (HttpRequest)((Object)HttpRequestPool.get(session).acquire());
            if (context.request == null) {
                log.warn("#{} Request pool too small; increase it to prevent blocking.", (Object)session.uniqueId());
                return false;
            }
        }
        HttpDestinationTable destinations = HttpDestinationTable.get(session);
        try {
            int pathIndex;
            boolean isUrl;
            HttpRequest request = context.request;
            request.method = (HttpMethod)((Object)this.method.apply((Object)session));
            String path = (String)this.pathGenerator.apply((Object)session);
            boolean isHttp = path.startsWith("http://");
            boolean bl = isUrl = isHttp || path.startsWith("https://");
            request.path = isUrl ? ((pathIndex = path.indexOf(47, HttpUtil.prefixLength(isHttp))) < 0 ? "/" : path.substring(pathIndex)) : path;
            HttpConnectionPool connectionPool = this.getConnectionPool(session, destinations, path, isHttp, isUrl);
            if (connectionPool == null) {
                session.fail((Throwable)new IllegalStateException("Connection pool must not be null."));
                return false;
            }
            request.authority = connectionPool.clientPool().authority();
            String metric = destinations.hasSingleDestination() ? (String)this.metricSelector.apply(null, (Object)request.path) : (String)this.metricSelector.apply((Object)request.authority, (Object)request.path);
            Statistics statistics = session.statistics(this.id(), metric);
            request.start(connectionPool, this.handler, session.currentSequence(), statistics);
            connectionPool.acquire(false, context);
        }
        catch (Throwable t) {
            if (!context.request.isRunning()) {
                context.request.start(sequence, null);
            }
            context.request.setCompleted();
            context.request.release();
            context.reset();
            throw t;
        }
        return true;
    }

    private HttpConnectionPool getConnectionPool(Session session, HttpDestinationTable destinations, String path, boolean isHttp, boolean isUrl) {
        HttpConnectionPool connectionPool;
        String authority;
        String endpoint;
        String string = endpoint = this.endpoint == null ? null : (String)this.endpoint.apply((Object)session);
        if (endpoint != null) {
            HttpConnectionPool connectionPool2 = destinations.getConnectionPoolByName(endpoint);
            if (connectionPool2 == null) {
                throw new IllegalStateException("There is no HTTP destination '" + endpoint + "'");
            }
            return connectionPool2;
        }
        String string2 = authority = this.authority == null ? null : (String)this.authority.apply((Object)session);
        if (authority == null && isUrl) {
            for (String hostPort : destinations.authorities()) {
                if (!HttpUtil.authorityMatch(path, hostPort, isHttp)) continue;
                authority = hostPort;
                break;
            }
            if (authority == null) {
                throw new IllegalStateException("Cannot access " + path + ": no destination configured");
            }
        }
        if ((connectionPool = destinations.getConnectionPoolByAuthority(authority)) == null) {
            if (authority == null) {
                throw new IllegalStateException("There is no default authority and it was not set neither explicitly nor through URL in path.");
            }
            throw new IllegalStateException("There is no connection pool with authority '" + authority + "', available pools are: " + Arrays.asList(destinations.authorities()));
        }
        return connectionPool;
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this.contextKey, HttpRequestContext::new);
    }
}

