/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.android.build.api.dsl.AndroidSourceDirectorySet;
import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.facebook.react.ReactExtension;
import com.facebook.react.ReactPlugin;
import com.facebook.react.TaskConfigurationKt;
import com.facebook.react.internal.PrivateReactExtension;
import com.facebook.react.model.ModelPackageJson;
import com.facebook.react.tasks.GenerateAutolinkingNewArchitecturesFileTask;
import com.facebook.react.tasks.GenerateCodegenArtifactsTask;
import com.facebook.react.tasks.GenerateCodegenSchemaTask;
import com.facebook.react.tasks.GeneratePackageListTask;
import com.facebook.react.utils.AgpConfiguratorUtils;
import com.facebook.react.utils.BackwardCompatUtils;
import com.facebook.react.utils.DependencyUtils;
import com.facebook.react.utils.JdkConfiguratorUtils;
import com.facebook.react.utils.JsonUtils;
import com.facebook.react.utils.NdkConfiguratorUtils;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.jvm.Jvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/ReactPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "checkIfNewArchFlagIsSet", "extension", "Lcom/facebook/react/ReactExtension;", "checkJvmVersion", "configureAutolinking", "configureCodegen", "localExtension", "rootExtension", "Lcom/facebook/react/internal/PrivateReactExtension;", "isLibrary", "", "react-native-gradle-plugin"})
public final class ReactPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.checkJvmVersion(project);
        Object[] objectArray = new Object[]{project};
        ReactExtension extension = (ReactExtension)project.getExtensions().create("react", ReactExtension.class, objectArray);
        Intrinsics.checkNotNull((Object)extension);
        this.checkIfNewArchFlagIsSet(project, extension);
        PrivateReactExtension privateReactExtension = (PrivateReactExtension)project.getRootProject().getExtensions().findByType(PrivateReactExtension.class);
        if (privateReactExtension == null) {
            Object[] objectArray2 = new Object[]{project};
            privateReactExtension = (PrivateReactExtension)project.getRootProject().getExtensions().create("privateReact", PrivateReactExtension.class, objectArray2);
        }
        PrivateReactExtension rootExtension = privateReactExtension;
        rootExtension.getRoot().set((Provider)extension.getRoot());
        rootExtension.getReactNativeDir().set((Provider)extension.getReactNativeDir());
        rootExtension.getCodegenDir().set((Provider)extension.getCodegenDir());
        rootExtension.getNodeExecutableAndArgs().set((Provider)extension.getNodeExecutableAndArgs());
        project.afterEvaluate(arg_0 -> ReactPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(extension, project){
            final /* synthetic */ ReactExtension $extension;
            final /* synthetic */ Project $project;
            {
                this.$extension = $extension;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                File reactNativeDir = ((Directory)this.$extension.getReactNativeDir().get()).getAsFile();
                File propertiesFile = new File(reactNativeDir, "ReactAndroid/gradle.properties");
                Pair<String, String> versionAndGroupStrings = DependencyUtils.INSTANCE.readVersionAndGroupStrings(propertiesFile);
                String versionString = (String)versionAndGroupStrings.getFirst();
                String groupString = (String)versionAndGroupStrings.getSecond();
                DependencyUtils.INSTANCE.configureDependencies(this.$project, versionString, groupString);
                Intrinsics.checkNotNull((Object)reactNativeDir);
                DependencyUtils.INSTANCE.configureRepositories(this.$project, reactNativeDir);
            }
        }, arg_0));
        NdkConfiguratorUtils.INSTANCE.configureReactNativeNdk(project, extension);
        AgpConfiguratorUtils.INSTANCE.configureBuildConfigFieldsForApp(project, extension);
        AgpConfiguratorUtils.INSTANCE.configureDevPorts(project);
        BackwardCompatUtils.INSTANCE.configureBackwardCompatibilityReactMap(project);
        JdkConfiguratorUtils.INSTANCE.configureJavaToolChains(project);
        Object object = project.getExtensions().getByType(AndroidComponentsExtension.class);
        AndroidComponentsExtension $this$apply_u24lambda_u241 = (AndroidComponentsExtension)object;
        boolean bl = false;
        $this$apply_u24lambda_u241.onVariants($this$apply_u24lambda_u241.selector().all(), (Function1)new Function1<Variant, Unit>(project, extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $extension;
            {
                this.$project = $project;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                ReactExtension reactExtension = this.$extension;
                Intrinsics.checkNotNullExpressionValue((Object)reactExtension, (String)"$extension");
                TaskConfigurationKt.configureReactTasks(this.$project, variant, reactExtension);
            }
        });
        this.configureAutolinking(project, extension);
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> ReactPlugin.apply$lambda$2((Function1)new Function1<AppliedPlugin, Unit>(this, project, extension, rootExtension){
            final /* synthetic */ ReactPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $extension;
            final /* synthetic */ PrivateReactExtension $rootExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$extension = $extension;
                this.$rootExtension = $rootExtension;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                ReactExtension reactExtension = this.$extension;
                Intrinsics.checkNotNullExpressionValue((Object)reactExtension, (String)"$extension");
                PrivateReactExtension privateReactExtension = this.$rootExtension;
                Intrinsics.checkNotNullExpressionValue((Object)privateReactExtension, (String)"$rootExtension");
                ReactPlugin.access$configureCodegen(this.this$0, this.$project, reactExtension, privateReactExtension, false);
            }
        }, arg_0));
        AgpConfiguratorUtils.INSTANCE.configureBuildConfigFieldsForLibraries(project);
        AgpConfiguratorUtils.INSTANCE.configureNamespaceForLibraries(project);
        project.getPluginManager().withPlugin("com.android.library", arg_0 -> ReactPlugin.apply$lambda$3((Function1)new Function1<AppliedPlugin, Unit>(this, project, extension, rootExtension){
            final /* synthetic */ ReactPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $extension;
            final /* synthetic */ PrivateReactExtension $rootExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$extension = $extension;
                this.$rootExtension = $rootExtension;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                ReactExtension reactExtension = this.$extension;
                Intrinsics.checkNotNullExpressionValue((Object)reactExtension, (String)"$extension");
                PrivateReactExtension privateReactExtension = this.$rootExtension;
                Intrinsics.checkNotNullExpressionValue((Object)privateReactExtension, (String)"$rootExtension");
                ReactPlugin.access$configureCodegen(this.this$0, this.$project, reactExtension, privateReactExtension, true);
            }
        }, arg_0));
    }

    private final void checkJvmVersion(Project project) {
        Jvm jvm = Jvm.current();
        String jvmVersion = jvm != null && (jvm = jvm.getJavaVersion()) != null ? jvm.getMajorVersion() : null;
        Object object = jvmVersion;
        if ((object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0) <= 16) {
            project.getLogger().error(StringsKt.trimIndent((String)("\n\n      ********************************************************************************\n\n      ERROR: requires JDK17 or higher.\n      Incompatible major version detected: '" + jvmVersion + "'\n\n      ********************************************************************************\n\n      ")));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void checkIfNewArchFlagIsSet(Project project, ReactExtension extension) {
        if (ProjectUtils.INSTANCE.shouldWarnIfNewArchFlagIsSetInPrealpha$react_native_gradle_plugin(project, extension)) {
            project.getLogger().warn("\n********************************************************************************\n\nWARNING: This version of React Native is ignoring the `newArchEnabled` flag you set. Please set it to true or remove it to suppress this warning.\n\n\n********************************************************************************\n");
        }
    }

    private final void configureCodegen(Project project, ReactExtension localExtension, PrivateReactExtension rootExtension, boolean isLibrary) {
        Provider provider = project.getLayout().getBuildDirectory().dir("generated/source/codegen");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        Provider generatedSrcDir = provider;
        if (isLibrary) {
            localExtension.getJsRootDir().convention(project.getLayout().getProjectDirectory().dir("../"));
        } else {
            localExtension.getJsRootDir().convention((Provider)localExtension.getRoot());
        }
        TaskProvider generateCodegenSchemaTask2 = project.getTasks().register("generateCodegenSchemaFromJavaScript", GenerateCodegenSchemaTask.class, arg_0 -> ReactPlugin.configureCodegen$lambda$4((Function1)new Function1<GenerateCodegenSchemaTask, Unit>(rootExtension, (Provider<Directory>)generatedSrcDir, project, localExtension, isLibrary){
            final /* synthetic */ PrivateReactExtension $rootExtension;
            final /* synthetic */ Provider<Directory> $generatedSrcDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $localExtension;
            final /* synthetic */ boolean $isLibrary;
            {
                this.$rootExtension = $rootExtension;
                this.$generatedSrcDir = $generatedSrcDir;
                this.$project = $project;
                this.$localExtension = $localExtension;
                this.$isLibrary = $isLibrary;
                super(1);
            }

            public final void invoke(GenerateCodegenSchemaTask it) {
                boolean includesGeneratedCode;
                ModelPackageJson parsedPackageJson;
                ModelPackageJson modelPackageJson;
                ModelPackageJson modelPackageJson2;
                File packageJson;
                it.getNodeExecutableAndArgs().set((Provider)this.$rootExtension.getNodeExecutableAndArgs());
                it.getCodegenDir().set((Provider)this.$rootExtension.getCodegenDir());
                it.getGeneratedSrcDir().set(this.$generatedSrcDir);
                File file = packageJson = PathUtils.findPackageJsonFile(this.$project, this.$rootExtension.getRoot());
                if (file != null) {
                    File it2 = file;
                    boolean bl = false;
                    modelPackageJson2 = JsonUtils.INSTANCE.fromPackageJson(it2);
                } else {
                    modelPackageJson2 = null;
                }
                String jsSrcsDirInPackageJson = (modelPackageJson = (parsedPackageJson = modelPackageJson2)) != null && (modelPackageJson = modelPackageJson.getCodegenConfig()) != null ? modelPackageJson.getJsSrcsDir() : null;
                Object object = parsedPackageJson;
                boolean bl = object != null && (object = object.getCodegenConfig()) != null && (object = object.getIncludesGeneratedCode()) != null ? (Boolean)object : (includesGeneratedCode = false);
                if (jsSrcsDirInPackageJson != null) {
                    it.getJsRootDir().set(new File(packageJson.getParentFile(), jsSrcsDirInPackageJson));
                } else {
                    it.getJsRootDir().set((Provider)this.$localExtension.getJsRootDir());
                }
                boolean needsCodegenFromPackageJson = ProjectUtils.INSTANCE.needsCodegenFromPackageJson$react_native_gradle_plugin(this.$project, this.$rootExtension.getRoot());
                it.onlyIf(arg_0 -> configureCodegen.generateCodegenSchemaTask.1.invoke$lambda$1((Function1)new Function1<Task, Boolean>(this.$isLibrary, needsCodegenFromPackageJson, includesGeneratedCode){
                    final /* synthetic */ boolean $isLibrary;
                    final /* synthetic */ boolean $needsCodegenFromPackageJson;
                    final /* synthetic */ boolean $includesGeneratedCode;
                    {
                        this.$isLibrary = $isLibrary;
                        this.$needsCodegenFromPackageJson = $needsCodegenFromPackageJson;
                        this.$includesGeneratedCode = $includesGeneratedCode;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Task it) {
                        return (this.$isLibrary || this.$needsCodegenFromPackageJson) && !this.$includesGeneratedCode;
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, arg_0));
        TaskProvider generateCodegenArtifactsTask2 = project.getTasks().register("generateCodegenArtifactsFromSchema", GenerateCodegenArtifactsTask.class, arg_0 -> ReactPlugin.configureCodegen$lambda$5((Function1)new Function1<GenerateCodegenArtifactsTask, Unit>((TaskProvider<GenerateCodegenSchemaTask>)generateCodegenSchemaTask2, rootExtension, (Provider<Directory>)generatedSrcDir, project, localExtension, isLibrary){
            final /* synthetic */ TaskProvider<GenerateCodegenSchemaTask> $generateCodegenSchemaTask;
            final /* synthetic */ PrivateReactExtension $rootExtension;
            final /* synthetic */ Provider<Directory> $generatedSrcDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $localExtension;
            final /* synthetic */ boolean $isLibrary;
            {
                this.$generateCodegenSchemaTask = $generateCodegenSchemaTask;
                this.$rootExtension = $rootExtension;
                this.$generatedSrcDir = $generatedSrcDir;
                this.$project = $project;
                this.$localExtension = $localExtension;
                this.$isLibrary = $isLibrary;
                super(1);
            }

            public final void invoke(GenerateCodegenArtifactsTask it) {
                ModelPackageJson parsedPackageJson;
                Object object;
                ModelPackageJson modelPackageJson;
                File packageJson;
                Object[] objectArray = new Object[]{this.$generateCodegenSchemaTask};
                it.dependsOn(objectArray);
                it.getReactNativeDir().set((Provider)this.$rootExtension.getReactNativeDir());
                it.getNodeExecutableAndArgs().set((Provider)this.$rootExtension.getNodeExecutableAndArgs());
                it.getGeneratedSrcDir().set(this.$generatedSrcDir);
                it.getPackageJsonFile().set(PathUtils.findPackageJsonFile(this.$project, this.$rootExtension.getRoot()));
                it.getCodegenJavaPackageName().set((Provider)this.$localExtension.getCodegenJavaPackageName());
                it.getLibraryName().set((Provider)this.$localExtension.getLibraryName());
                boolean needsCodegenFromPackageJson = ProjectUtils.INSTANCE.needsCodegenFromPackageJson$react_native_gradle_plugin(this.$project, this.$rootExtension.getRoot());
                File file = packageJson = PathUtils.findPackageJsonFile(this.$project, this.$rootExtension.getRoot());
                if (file != null) {
                    File it2 = file;
                    boolean bl = false;
                    modelPackageJson = JsonUtils.INSTANCE.fromPackageJson(it2);
                } else {
                    modelPackageJson = null;
                }
                boolean includesGeneratedCode = (object = (parsedPackageJson = modelPackageJson)) != null && (object = object.getCodegenConfig()) != null && (object = object.getIncludesGeneratedCode()) != null ? (Boolean)object : false;
                it.onlyIf(arg_0 -> configureCodegen.generateCodegenArtifactsTask.1.invoke$lambda$1((Function1)new Function1<Task, Boolean>(this.$isLibrary, needsCodegenFromPackageJson, includesGeneratedCode){
                    final /* synthetic */ boolean $isLibrary;
                    final /* synthetic */ boolean $needsCodegenFromPackageJson;
                    final /* synthetic */ boolean $includesGeneratedCode;
                    {
                        this.$isLibrary = $isLibrary;
                        this.$needsCodegenFromPackageJson = $needsCodegenFromPackageJson;
                        this.$includesGeneratedCode = $includesGeneratedCode;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Task it) {
                        return (this.$isLibrary || this.$needsCodegenFromPackageJson) && !this.$includesGeneratedCode;
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, arg_0));
        ((AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class)).finalizeDsl(new Function1<CommonExtension<?, ?, ?, ?, ?, ?>, Unit>((Provider<Directory>)generatedSrcDir){
            final /* synthetic */ Provider<Directory> $generatedSrcDir;
            {
                this.$generatedSrcDir = $generatedSrcDir;
                super(1);
            }

            public final void invoke(@NotNull CommonExtension<?, ?, ?, ?, ?, ?> ext) {
                Intrinsics.checkNotNullParameter(ext, (String)"ext");
                AndroidSourceDirectorySet androidSourceDirectorySet = ((AndroidSourceSet)ext.getSourceSets().getByName("main")).getJava();
                File file = ((Directory)this.$generatedSrcDir.get()).dir("java").getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                androidSourceDirectorySet.srcDir((Object)file);
            }
        });
        TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        TaskProvider[] taskProviderArray = new TaskProvider[1];
        Intrinsics.checkNotNull((Object)generateCodegenArtifactsTask2);
        taskProviderArray[0] = generateCodegenArtifactsTask2;
        TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])taskProviderArray);
    }

    private final void configureAutolinking(Project project, ReactExtension extension) {
        Provider provider = project.getLayout().getBuildDirectory().dir("generated/autolinking/src/main/java");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        Provider generatedAutolinkingJavaDir = provider;
        Provider provider2 = project.getLayout().getBuildDirectory().dir("generated/autolinking/src/main/jni");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"dir(...)");
        Provider generatedAutolinkingJniDir = provider2;
        Provider rootGeneratedAutolinkingFile = project.getRootProject().getLayout().getBuildDirectory().file("generated/autolinking/autolinking.json");
        TaskProvider generatePackageListTask2 = project.getTasks().register("generateAutolinkingPackageList", GeneratePackageListTask.class, arg_0 -> ReactPlugin.configureAutolinking$lambda$6((Function1)new Function1<GeneratePackageListTask, Unit>((Provider<RegularFile>)rootGeneratedAutolinkingFile, (Provider<Directory>)generatedAutolinkingJavaDir){
            final /* synthetic */ Provider<RegularFile> $rootGeneratedAutolinkingFile;
            final /* synthetic */ Provider<Directory> $generatedAutolinkingJavaDir;
            {
                this.$rootGeneratedAutolinkingFile = $rootGeneratedAutolinkingFile;
                this.$generatedAutolinkingJavaDir = $generatedAutolinkingJavaDir;
                super(1);
            }

            public final void invoke(GeneratePackageListTask task) {
                task.getAutolinkInputFile().set(this.$rootGeneratedAutolinkingFile);
                task.getGeneratedOutputDirectory().set(this.$generatedAutolinkingJavaDir);
            }
        }, arg_0));
        if (ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(project, extension)) {
            TaskProvider generateAutolinkingNewArchitectureFilesTask2 = project.getTasks().register("generateAutolinkingNewArchitectureFiles", GenerateAutolinkingNewArchitecturesFileTask.class, arg_0 -> ReactPlugin.configureAutolinking$lambda$7((Function1)new Function1<GenerateAutolinkingNewArchitecturesFileTask, Unit>((Provider<RegularFile>)rootGeneratedAutolinkingFile, (Provider<Directory>)generatedAutolinkingJniDir){
                final /* synthetic */ Provider<RegularFile> $rootGeneratedAutolinkingFile;
                final /* synthetic */ Provider<Directory> $generatedAutolinkingJniDir;
                {
                    this.$rootGeneratedAutolinkingFile = $rootGeneratedAutolinkingFile;
                    this.$generatedAutolinkingJniDir = $generatedAutolinkingJniDir;
                    super(1);
                }

                public final void invoke(GenerateAutolinkingNewArchitecturesFileTask task) {
                    task.getAutolinkInputFile().set(this.$rootGeneratedAutolinkingFile);
                    task.getGeneratedOutputDirectory().set(this.$generatedAutolinkingJniDir);
                }
            }, arg_0));
            TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
            TaskProvider[] taskProviderArray = new TaskProvider[1];
            Intrinsics.checkNotNull((Object)generateAutolinkingNewArchitectureFilesTask2);
            taskProviderArray[0] = generateAutolinkingNewArchitectureFilesTask2;
            TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])taskProviderArray);
        }
        TaskProvider taskProvider = project.getTasks().named("preBuild", Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
        Object object = new TaskProvider[1];
        Intrinsics.checkNotNull((Object)generatePackageListTask2);
        object[0] = generatePackageListTask2;
        TaskFactoryUtils.dependsOn((TaskProvider)taskProvider, (TaskProvider[])object);
        object = project.getExtensions().getByType(AndroidComponentsExtension.class);
        AndroidComponentsExtension $this$configureAutolinking_u24lambda_u248 = (AndroidComponentsExtension)object;
        boolean bl = false;
        $this$configureAutolinking_u24lambda_u248.onVariants($this$configureAutolinking_u24lambda_u248.selector().all(), (Function1)new Function1<Variant, Unit>((Provider<Directory>)generatedAutolinkingJavaDir){
            final /* synthetic */ Provider<Directory> $generatedAutolinkingJavaDir;
            {
                this.$generatedAutolinkingJavaDir = $generatedAutolinkingJavaDir;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    SourceDirectories.Flat flat = variant.getSources().getJava();
                    if (flat == null) break block0;
                    String string = ((Directory)this.$generatedAutolinkingJavaDir.get()).getAsFile().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    flat.addStaticSourceDirectory(string);
                }
            }
        });
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCodegen$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureCodegen$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureAutolinking$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureAutolinking$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$configureCodegen(ReactPlugin $this, Project project, ReactExtension localExtension, PrivateReactExtension rootExtension, boolean isLibrary) {
        $this.configureCodegen(project, localExtension, rootExtension, isLibrary);
    }
}

