/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.facebook.react.ReactExtension;
import com.facebook.react.TaskConfigurationKt;
import com.facebook.react.tasks.BundleHermesCTask;
import com.facebook.react.utils.KotlinStdlibCompatUtils;
import com.facebook.react.utils.NdkConfiguratorUtils;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"configureReactTasks", "", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "config", "Lcom/facebook/react/ReactExtension;", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nTaskConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskConfiguration.kt\ncom/facebook/react/TaskConfigurationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1747#2,3:83\n*S KotlinDebug\n*F\n+ 1 TaskConfiguration.kt\ncom/facebook/react/TaskConfigurationKt\n*L\n50#1:83,3\n*E\n"})
public final class TaskConfigurationKt {
    public static final void configureReactTasks(@NotNull Project $this$configureReactTasks, @NotNull Variant variant, @NotNull ReactExtension config) {
        block6: {
            boolean bl;
            boolean isHermesEnabledInThisVariant;
            File cliFile;
            File jsIntermediateSourceMapsDir;
            File jsSourceMapsDir;
            File jsBundleDir;
            File resourcesDir;
            String targetName;
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$configureReactTasks, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                targetName = KotlinStdlibCompatUtils.INSTANCE.capitalizeCompat(variant.getName());
                String targetPath = variant.getName();
                File buildDir = ((Directory)$this$configureReactTasks.getLayout().getBuildDirectory().get()).getAsFile();
                resourcesDir = new File(buildDir, "generated/res/react/" + targetPath);
                jsBundleDir = new File(buildDir, "generated/assets/react/" + targetPath);
                jsSourceMapsDir = new File(buildDir, "generated/sourcemaps/react/" + targetPath);
                jsIntermediateSourceMapsDir = new File(buildDir, "intermediates/sourcemaps/react/" + targetPath);
                cliFile = PathUtils.detectedCliFile(config);
                Project project = $this$configureReactTasks.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                boolean isHermesEnabledInProject = ProjectUtils.INSTANCE.isHermesEnabled$react_native_gradle_plugin(project);
                Object object = config.getEnableHermesOnlyInVariants().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                isHermesEnabledInThisVariant = !((Collection)object).isEmpty() ? ((List)config.getEnableHermesOnlyInVariants().get()).contains(variant.getName()) && isHermesEnabledInProject : isHermesEnabledInProject;
                Object object2 = config.getDebuggableVariants().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Iterable $this$any$iv = (Iterable)object2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it, (String)variant.getName(), (boolean)true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            boolean isDebuggableVariant = bl;
            Project project = $this$configureReactTasks.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            NdkConfiguratorUtils.INSTANCE.configureNewArchPackagingOptions(project, config, variant);
            NdkConfiguratorUtils.INSTANCE.configureJsEnginePackagingOptions(config, variant, isHermesEnabledInThisVariant);
            if (isDebuggableVariant) break block6;
            String entryFileEnvVariable = System.getenv("ENTRY_FILE");
            TaskProvider bundleTask2 = $this$configureReactTasks.getTasks().register("createBundle" + targetName + "JsAndAssets", BundleHermesCTask.class, arg_0 -> TaskConfigurationKt.configureReactTasks$lambda$1((Function1)new Function1<BundleHermesCTask, Unit>(config, cliFile, entryFileEnvVariable, jsBundleDir, resourcesDir, isHermesEnabledInThisVariant, jsIntermediateSourceMapsDir, jsSourceMapsDir){
                final /* synthetic */ ReactExtension $config;
                final /* synthetic */ File $cliFile;
                final /* synthetic */ String $entryFileEnvVariable;
                final /* synthetic */ File $jsBundleDir;
                final /* synthetic */ File $resourcesDir;
                final /* synthetic */ boolean $isHermesEnabledInThisVariant;
                final /* synthetic */ File $jsIntermediateSourceMapsDir;
                final /* synthetic */ File $jsSourceMapsDir;
                {
                    this.$config = $config;
                    this.$cliFile = $cliFile;
                    this.$entryFileEnvVariable = $entryFileEnvVariable;
                    this.$jsBundleDir = $jsBundleDir;
                    this.$resourcesDir = $resourcesDir;
                    this.$isHermesEnabledInThisVariant = $isHermesEnabledInThisVariant;
                    this.$jsIntermediateSourceMapsDir = $jsIntermediateSourceMapsDir;
                    this.$jsSourceMapsDir = $jsSourceMapsDir;
                    super(1);
                }

                public final void invoke(BundleHermesCTask it) {
                    it.getRoot().set((Provider)this.$config.getRoot());
                    it.getNodeExecutableAndArgs().set((Provider)this.$config.getNodeExecutableAndArgs());
                    it.getCliFile().set(this.$cliFile);
                    it.getBundleCommand().set((Provider)this.$config.getBundleCommand());
                    it.getEntryFile().set(PathUtils.detectedEntryFile(this.$config, this.$entryFileEnvVariable));
                    it.getExtraPackagerArgs().set((Provider)this.$config.getExtraPackagerArgs());
                    it.getBundleConfig().set((Provider)this.$config.getBundleConfig());
                    it.getBundleAssetName().set((Provider)this.$config.getBundleAssetName());
                    it.getJsBundleDir().set(this.$jsBundleDir);
                    it.getResourcesDir().set(this.$resourcesDir);
                    it.getHermesEnabled().set((Object)this.$isHermesEnabledInThisVariant);
                    it.getMinifyEnabled().set((Object)(!this.$isHermesEnabledInThisVariant ? 1 : 0));
                    it.getDevEnabled().set((Object)false);
                    it.getJsIntermediateSourceMapsDir().set(this.$jsIntermediateSourceMapsDir);
                    it.getJsSourceMapsDir().set(this.$jsSourceMapsDir);
                    it.getHermesCommand().set((Provider)this.$config.getHermesCommand());
                    it.getHermesFlags().set((Provider)this.$config.getHermesFlags());
                    it.getReactNativeDir().set((Provider)this.$config.getReactNativeDir());
                }
            }, arg_0));
            SourceDirectories.Layered layered = variant.getSources().getRes();
            if (layered != null) {
                Intrinsics.checkNotNull((Object)bundleTask2);
                layered.addGeneratedSourceDirectory(bundleTask2, (Function1)configureReactTasks.1.INSTANCE);
            }
            SourceDirectories.Layered layered2 = variant.getSources().getAssets();
            if (layered2 != null) {
                Intrinsics.checkNotNull((Object)bundleTask2);
                layered2.addGeneratedSourceDirectory(bundleTask2, (Function1)configureReactTasks.2.INSTANCE);
            }
        }
    }

    private static final void configureReactTasks$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

