/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.tasks.BundleHermesCTask;
import com.facebook.react.utils.FileUtilsKt;
import com.facebook.react.utils.Os;
import com.facebook.react.utils.PathUtils;
import com.facebook.react.utils.TaskUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\t\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0000\u00a2\u0006\u0002\b:J3\u0010;\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010<\u001a\u0002082\u0006\u0010=\u001a\u0002082\u0006\u0010>\u001a\u0002082\u0006\u0010?\u001a\u000208H\u0000\u00a2\u0006\u0002\b@J+\u0010A\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010B\u001a\u0002082\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\bCJ\u0015\u0010D\u001a\u0002082\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u0002082\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u0002082\u0006\u0010\u0003\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u00020KH\u0007J\u0016\u0010L\u001a\u00020K2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020605H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0007R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0014\u0010\u001f\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\rR\u0014\u0010%\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0018R\u0014\u0010+\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\"R\u0014\u0010-\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\"R\u0014\u0010/\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\"R\u0013\u00101\u001a\u0002028G\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006N"}, d2={"Lcom/facebook/react/tasks/BundleHermesCTask;", "Lorg/gradle/api/DefaultTask;", "()V", "bundleAssetName", "Lorg/gradle/api/provider/Property;", "", "getBundleAssetName", "()Lorg/gradle/api/provider/Property;", "bundleCommand", "getBundleCommand", "bundleConfig", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleConfig", "()Lorg/gradle/api/file/RegularFileProperty;", "cliFile", "getCliFile", "devEnabled", "", "getDevEnabled", "entryFile", "getEntryFile", "extraPackagerArgs", "Lorg/gradle/api/provider/ListProperty;", "getExtraPackagerArgs", "()Lorg/gradle/api/provider/ListProperty;", "hermesCommand", "getHermesCommand", "hermesEnabled", "getHermesEnabled", "hermesFlags", "getHermesFlags", "jsBundleDir", "Lorg/gradle/api/file/DirectoryProperty;", "getJsBundleDir", "()Lorg/gradle/api/file/DirectoryProperty;", "jsIntermediateSourceMapsDir", "getJsIntermediateSourceMapsDir", "jsSourceMapsDir", "getJsSourceMapsDir", "minifyEnabled", "getMinifyEnabled", "nodeExecutableAndArgs", "getNodeExecutableAndArgs", "reactNativeDir", "getReactNativeDir", "resourcesDir", "getResourcesDir", "root", "getRoot", "sources", "Lorg/gradle/api/file/ConfigurableFileTree;", "getSources", "()Lorg/gradle/api/file/ConfigurableFileTree;", "", "", "bundleFile", "Ljava/io/File;", "sourceMapFile", "getBundleCommand$react_native_gradle_plugin", "getComposeSourceMapsCommand", "composeScript", "packagerSourceMap", "compilerSourceMap", "outputSourceMap", "getComposeSourceMapsCommand$react_native_gradle_plugin", "getHermescCommand", "bytecodeFile", "getHermescCommand$react_native_gradle_plugin", "resolveCompilerSourceMap", "resolveCompilerSourceMap$react_native_gradle_plugin", "resolveOutputSourceMap", "resolveOutputSourceMap$react_native_gradle_plugin", "resolvePackagerSourceMapFile", "resolvePackagerSourceMapFile$react_native_gradle_plugin", "run", "", "runCommand", "command", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBundleHermesCTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleHermesCTask.kt\ncom/facebook/react/tasks/BundleHermesCTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,200:1\n37#2,2:201\n37#2,2:203\n*S KotlinDebug\n*F\n+ 1 BundleHermesCTask.kt\ncom/facebook/react/tasks/BundleHermesCTask\n*L\n181#1:201,2\n192#1:203,2\n*E\n"})
public abstract class BundleHermesCTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileTree sources;

    public BundleHermesCTask() {
        this.setGroup("react");
        ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)this.getRoot(), arg_0 -> BundleHermesCTask.sources$lambda$0(sources.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileTree, (String)"fileTree(...)");
        this.sources = configurableFileTree;
    }

    @Internal
    @NotNull
    public abstract DirectoryProperty getRoot();

    @InputFiles
    @NotNull
    public final ConfigurableFileTree getSources() {
        return this.sources;
    }

    @Input
    @NotNull
    public abstract ListProperty<String> getNodeExecutableAndArgs();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getCliFile();

    @Internal
    @NotNull
    public abstract DirectoryProperty getReactNativeDir();

    @Input
    @NotNull
    public abstract Property<String> getBundleCommand();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getEntryFile();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getBundleConfig();

    @Input
    @NotNull
    public abstract Property<String> getBundleAssetName();

    @Input
    @NotNull
    public abstract Property<Boolean> getMinifyEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getHermesEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getDevEnabled();

    @Input
    @NotNull
    public abstract ListProperty<String> getExtraPackagerArgs();

    @Input
    @NotNull
    public abstract Property<String> getHermesCommand();

    @Input
    @NotNull
    public abstract ListProperty<String> getHermesFlags();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJsBundleDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResourcesDir();

    @OutputDirectory
    @NotNull
    public abstract RegularFileProperty getJsIntermediateSourceMapsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getJsSourceMapsDir();

    @TaskAction
    public final void run() {
        ((Directory)this.getJsBundleDir().get()).getAsFile().mkdirs();
        ((Directory)this.getResourcesDir().get()).getAsFile().mkdirs();
        ((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile().mkdirs();
        ((Directory)this.getJsSourceMapsDir().get()).getAsFile().mkdirs();
        String bundleAssetFilename = (String)this.getBundleAssetName().get();
        File bundleFile = new File(((Directory)this.getJsBundleDir().get()).getAsFile(), bundleAssetFilename);
        Intrinsics.checkNotNull((Object)bundleAssetFilename);
        File packagerSourceMap = this.resolvePackagerSourceMapFile$react_native_gradle_plugin(bundleAssetFilename);
        List<Object> bundleCommand = this.getBundleCommand$react_native_gradle_plugin(bundleFile, packagerSourceMap);
        this.runCommand(bundleCommand);
        Object object = this.getHermesEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            File file = ((Directory)this.getRoot().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            Object object2 = this.getHermesCommand().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            String detectedHermesCommand = PathUtils.detectOSAwareHermesCommand(file, (String)object2);
            File bytecodeFile = new File(bundleFile + ".hbc");
            File outputSourceMap = this.resolveOutputSourceMap$react_native_gradle_plugin(bundleAssetFilename);
            File compilerSourceMap = this.resolveCompilerSourceMap$react_native_gradle_plugin(bundleAssetFilename);
            List<Object> hermesCommand = this.getHermescCommand$react_native_gradle_plugin(detectedHermesCommand, bytecodeFile, bundleFile);
            this.runCommand(hermesCommand);
            FileUtilsKt.moveTo(bytecodeFile, bundleFile);
            if (((List)this.getHermesFlags().get()).contains("-output-source-map")) {
                File hermesTempSourceMapFile = new File(bytecodeFile + ".map");
                FileUtilsKt.moveTo(hermesTempSourceMapFile, compilerSourceMap);
                File reactNativeDir = ((Directory)this.getReactNativeDir().get()).getAsFile();
                File composeScriptFile = new File(reactNativeDir, "scripts/compose-source-maps.js");
                List<Object> composeSourceMapsCommand = this.getComposeSourceMapsCommand$react_native_gradle_plugin(composeScriptFile, packagerSourceMap, compilerSourceMap, outputSourceMap);
                this.runCommand(composeSourceMapsCommand);
            }
        }
    }

    @NotNull
    public final File resolvePackagerSourceMapFile$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        Object object = this.getHermesEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object != false ? new File(((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile(), bundleAssetName + ".packager.map") : this.resolveOutputSourceMap$react_native_gradle_plugin(bundleAssetName);
    }

    @NotNull
    public final File resolveOutputSourceMap$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        return new File(((Directory)this.getJsSourceMapsDir().get()).getAsFile(), bundleAssetName + ".map");
    }

    @NotNull
    public final File resolveCompilerSourceMap$react_native_gradle_plugin(@NotNull String bundleAssetName) {
        Intrinsics.checkNotNullParameter((Object)bundleAssetName, (String)"bundleAssetName");
        return new File(((RegularFile)this.getJsIntermediateSourceMapsDir().get()).getAsFile(), bundleAssetName + ".compiler.map");
    }

    private final void runCommand(List<? extends Object> command) {
        this.getProject().exec(arg_0 -> BundleHermesCTask.runCommand$lambda$1((Function1)new Function1<ExecSpec, Unit>(this, command){
            final /* synthetic */ BundleHermesCTask this$0;
            final /* synthetic */ List<Object> $command;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                super(1);
            }

            public final void invoke(ExecSpec it) {
                it.workingDir((Object)((Directory)this.this$0.getRoot().get()).getAsFile());
                it.commandLine((Iterable)this.$command);
            }
        }, arg_0));
    }

    @NotNull
    public final List<Object> getBundleCommand$react_native_gradle_plugin(@NotNull File bundleFile, @NotNull File sourceMapFile) {
        List list;
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkNotNullParameter((Object)sourceMapFile, (String)"sourceMapFile");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        List $this$getBundleCommand_u24lambda_u242 = list = (List)new ArrayList();
        boolean bl = false;
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u242.addAll((Collection)object);
        File file = ((RegularFile)this.getCliFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Intrinsics.checkNotNull((Object)rootFile);
        $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(file, rootFile));
        Object object2 = this.getBundleCommand().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u242.add(object2);
        $this$getBundleCommand_u24lambda_u242.add("--platform");
        $this$getBundleCommand_u24lambda_u242.add("android");
        $this$getBundleCommand_u24lambda_u242.add("--dev");
        $this$getBundleCommand_u24lambda_u242.add(String.valueOf(this.getDevEnabled().get()));
        $this$getBundleCommand_u24lambda_u242.add("--reset-cache");
        $this$getBundleCommand_u24lambda_u242.add("--entry-file");
        File file2 = ((RegularFile)this.getEntryFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(file2, rootFile));
        $this$getBundleCommand_u24lambda_u242.add("--bundle-output");
        $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(bundleFile, rootFile));
        $this$getBundleCommand_u24lambda_u242.add("--assets-dest");
        File file3 = ((Directory)this.getResourcesDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
        $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(file3, rootFile));
        $this$getBundleCommand_u24lambda_u242.add("--sourcemap-output");
        $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(sourceMapFile, rootFile));
        if (this.getBundleConfig().isPresent()) {
            $this$getBundleCommand_u24lambda_u242.add("--config");
            File file4 = ((RegularFile)this.getBundleConfig().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
            $this$getBundleCommand_u24lambda_u242.add(Os.INSTANCE.cliPath(file4, rootFile));
        }
        $this$getBundleCommand_u24lambda_u242.add("--minify");
        $this$getBundleCommand_u24lambda_u242.add(String.valueOf(this.getMinifyEnabled().get()));
        Object object3 = this.getExtraPackagerArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        $this$getBundleCommand_u24lambda_u242.addAll((Collection)object3);
        $this$getBundleCommand_u24lambda_u242.add("--verbose");
        List commandLine = list;
        return TaskUtilsKt.windowsAwareCommandLine((List)commandLine);
    }

    @NotNull
    public final List<Object> getHermescCommand$react_native_gradle_plugin(@NotNull String hermesCommand, @NotNull File bytecodeFile, @NotNull File bundleFile) {
        Intrinsics.checkNotNullParameter((Object)hermesCommand, (String)"hermesCommand");
        Intrinsics.checkNotNullParameter((Object)bytecodeFile, (String)"bytecodeFile");
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        SpreadBuilder spreadBuilder = new SpreadBuilder(7);
        spreadBuilder.add((Object)hermesCommand);
        spreadBuilder.add((Object)"-emit-binary");
        spreadBuilder.add((Object)"-max-diagnostic-width=80");
        spreadBuilder.add((Object)"-out");
        Intrinsics.checkNotNull((Object)rootFile);
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(bytecodeFile, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(bundleFile, rootFile));
        Object object = this.getHermesFlags().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    @NotNull
    public final List<Object> getComposeSourceMapsCommand$react_native_gradle_plugin(@NotNull File composeScript, @NotNull File packagerSourceMap, @NotNull File compilerSourceMap, @NotNull File outputSourceMap) {
        Intrinsics.checkNotNullParameter((Object)composeScript, (String)"composeScript");
        Intrinsics.checkNotNullParameter((Object)packagerSourceMap, (String)"packagerSourceMap");
        Intrinsics.checkNotNullParameter((Object)compilerSourceMap, (String)"compilerSourceMap");
        Intrinsics.checkNotNullParameter((Object)outputSourceMap, (String)"outputSourceMap");
        File rootFile = ((Directory)this.getRoot().get()).getAsFile();
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        Intrinsics.checkNotNull((Object)rootFile);
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(composeScript, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(packagerSourceMap, rootFile));
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(compilerSourceMap, rootFile));
        spreadBuilder.add((Object)"-o");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(outputSourceMap, rootFile));
        return TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }

    private static final void sources$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void runCommand$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

