/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.model.ModelAutolinkingConfigJson;
import com.facebook.react.model.ModelAutolinkingDependenciesJson;
import com.facebook.react.model.ModelAutolinkingDependenciesPlatformAndroidJson;
import com.facebook.react.model.ModelAutolinkingDependenciesPlatformJson;
import com.facebook.react.tasks.GenerateAutolinkingNewArchitecturesFileTask;
import com.facebook.react.utils.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0002\b\u0014J\u001b\u0010\u0015\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/tasks/GenerateAutolinkingNewArchitecturesFileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "autolinkInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAutolinkInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generatedOutputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getGeneratedOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "filterAndroidPackages", "", "Lcom/facebook/react/model/ModelAutolinkingDependenciesPlatformAndroidJson;", "model", "Lcom/facebook/react/model/ModelAutolinkingConfigJson;", "filterAndroidPackages$react_native_gradle_plugin", "generateCmakeFileContent", "", "packages", "generateCmakeFileContent$react_native_gradle_plugin", "generateCppFileContent", "generateCppFileContent$react_native_gradle_plugin", "taskAction", "", "Companion", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateAutolinkingNewArchitecturesFileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateAutolinkingNewArchitecturesFileTask.kt\ncom/facebook/react/tasks/GenerateAutolinkingNewArchitecturesFileTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1#2:247\n1#2:258\n1603#3,9:248\n1855#3:257\n1856#3:259\n1612#3:260\n766#3:261\n857#3,2:262\n766#3:264\n857#3,2:265\n766#3:267\n857#3,2:268\n*S KotlinDebug\n*F\n+ 1 GenerateAutolinkingNewArchitecturesFileTask.kt\ncom/facebook/react/tasks/GenerateAutolinkingNewArchitecturesFileTask\n*L\n49#1:258\n49#1:248,9\n49#1:257\n49#1:259\n49#1:260\n94#1:261\n94#1:262,2\n124#1:264\n124#1:265,2\n138#1:267\n138#1:268,2\n*E\n"})
public abstract class GenerateAutolinkingNewArchitecturesFileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CMAKE_FILENAME = "Android-autolinking.cmake";
    @NotNull
    public static final String H_FILENAME = "autolinking.h";
    @NotNull
    public static final String CPP_FILENAME = "autolinking.cpp";
    @NotNull
    public static final String CODEGEN_LIB_PREFIX = "react_codegen_";
    @NotNull
    public static final String COMPONENT_DESCRIPTOR_FILENAME = "ComponentDescriptors.h";
    @NotNull
    public static final String COMPONENT_INCLUDE_PATH = "react/renderer/components";
    @NotNull
    private static final String CMAKE_TEMPLATE = "# This code was generated by [React Native](https://www.npmjs.com/package/@react-native/gradle-plugin)\ncmake_minimum_required(VERSION 3.13)\nset(CMAKE_VERBOSE_MAKEFILE on)\n\n{{ libraryIncludes }}\n\nset(AUTOLINKED_LIBRARIES\n  {{ libraryModules }}\n)";
    @NotNull
    private static final String CPP_TEMPLATE = "/**\n * This code was generated by [React Native](https://www.npmjs.com/package/@react-native/gradle-plugin).\n *\n * Do not edit this file as changes may cause incorrect behavior and will be lost\n * once the code is regenerated.\n *\n */\n\n#include \"autolinking.h\"\n{{ autolinkingCppIncludes }}\n\nnamespace facebook {\nnamespace react {\n\nstd::shared_ptr<TurboModule> autolinking_ModuleProvider(const std::string moduleName, const JavaTurboModule::InitParams &params) {\n{{ autolinkingCppTurboModuleJavaProviders }}\n  return nullptr;\n}\n\nstd::shared_ptr<TurboModule> autolinking_cxxModuleProvider(const std::string moduleName, const std::shared_ptr<CallInvoker>& jsInvoker) {\n{{ autolinkingCppTurboModuleCxxProviders }}\n  return nullptr;\n}\n\nvoid autolinking_registerProviders(std::shared_ptr<ComponentDescriptorProviderRegistry const> providerRegistry) {\n{{ autolinkingCppComponentDescriptors }}\n  return;\n}\n\n} // namespace react\n} // namespace facebook";
    @NotNull
    private static final String hTemplate = "/**\n * This code was generated by [React Native](https://www.npmjs.com/package/@react-native/gradle-plugin).\n *\n * Do not edit this file as changes may cause incorrect behavior and will be lost\n * once the code is regenerated.\n *\n */\n\n#pragma once\n\n#include <ReactCommon/CallInvoker.h>\n#include <ReactCommon/JavaTurboModule.h>\n#include <ReactCommon/TurboModule.h>\n#include <jsi/jsi.h>\n#include <react/renderer/componentregistry/ComponentDescriptorProviderRegistry.h>\n\nnamespace facebook {\nnamespace react {\n\nstd::shared_ptr<TurboModule> autolinking_ModuleProvider(const std::string moduleName, const JavaTurboModule::InitParams &params);\nstd::shared_ptr<TurboModule> autolinking_cxxModuleProvider(const std::string moduleName, const std::shared_ptr<CallInvoker>& jsInvoker);\nvoid autolinking_registerProviders(std::shared_ptr<ComponentDescriptorProviderRegistry const> providerRegistry);\n\n} // namespace react\n} // namespace facebook";

    public GenerateAutolinkingNewArchitecturesFileTask() {
        this.setGroup("react");
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getAutolinkInputFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getGeneratedOutputDirectory();

    @TaskAction
    public final void taskAction() {
        File file;
        File file2 = ((RegularFile)this.getAutolinkInputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        ModelAutolinkingConfigJson model = JsonUtils.INSTANCE.fromAutolinkingConfigJson(file2);
        List<ModelAutolinkingDependenciesPlatformAndroidJson> packages = this.filterAndroidPackages$react_native_gradle_plugin(model);
        String cmakeFileContent = this.generateCmakeFileContent$react_native_gradle_plugin(packages);
        String cppFileContent = this.generateCppFileContent$react_native_gradle_plugin(packages);
        File outputDir = ((Directory)this.getGeneratedOutputDirectory().get()).getAsFile();
        outputDir.mkdirs();
        File $this$taskAction_u24lambda_u240 = file = new File(outputDir, CMAKE_FILENAME);
        boolean bl = false;
        FilesKt.writeText$default((File)$this$taskAction_u24lambda_u240, (String)cmakeFileContent, null, (int)2, null);
        File $this$taskAction_u24lambda_u241 = file = new File(outputDir, CPP_FILENAME);
        boolean bl2 = false;
        FilesKt.writeText$default((File)$this$taskAction_u24lambda_u241, (String)cppFileContent, null, (int)2, null);
        File $this$taskAction_u24lambda_u242 = file = new File(outputDir, H_FILENAME);
        boolean bl3 = false;
        FilesKt.writeText$default((File)$this$taskAction_u24lambda_u242, (String)hTemplate, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModelAutolinkingDependenciesPlatformAndroidJson> filterAndroidPackages$react_native_gradle_plugin(@Nullable ModelAutolinkingConfigJson model) {
        List list;
        Object object = model;
        if (object != null && (object = object.getDependencies()) != null && (object = object.values()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ModelAutolinkingDependenciesPlatformAndroidJson it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ModelAutolinkingDependenciesJson it = (ModelAutolinkingDependenciesJson)element$iv$iv;
                boolean bl2 = false;
                ModelAutolinkingDependenciesPlatformJson modelAutolinkingDependenciesPlatformJson = it.getPlatforms();
                if ((modelAutolinkingDependenciesPlatformJson != null ? modelAutolinkingDependenciesPlatformJson.getAndroid() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String generateCmakeFileContent$react_native_gradle_plugin(@NotNull List<ModelAutolinkingDependenciesPlatformAndroidJson> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        String libraryIncludes2 = CollectionsKt.joinToString$default((Iterable)packages, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateCmakeFileContent.libraryIncludes.1.INSTANCE, (int)30, null);
        String libraryModules2 = CollectionsKt.joinToString$default((Iterable)packages, (CharSequence)"\n  ", null, null, (int)0, null, (Function1)generateCmakeFileContent.libraryModules.1.INSTANCE, (int)30, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)CMAKE_TEMPLATE, (String)"{{ libraryIncludes }}", (String)libraryIncludes2, (boolean)false, (int)4, null), (String)"{{ libraryModules }}", (String)libraryModules2, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateCppFileContent$react_native_gradle_plugin(@NotNull List<ModelAutolinkingDependenciesPlatformAndroidJson> packages) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Iterable $this$filter$iv3 = packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv3;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            ModelAutolinkingDependenciesPlatformAndroidJson android = (ModelAutolinkingDependenciesPlatformAndroidJson)element$iv$iv;
            boolean bl = false;
            if (!(android.getLibraryName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List packagesWithLibraryNames = (List)destination$iv$iv;
        String cppIncludes2 = CollectionsKt.joinToString$default((Iterable)packagesWithLibraryNames, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateCppFileContent.cppIncludes.1.INSTANCE, (int)30, null);
        String cppTurboModuleJavaProviders2 = CollectionsKt.joinToString$default((Iterable)packagesWithLibraryNames, (CharSequence)"\n", null, null, (int)0, null, (Function1)generateCppFileContent.cppTurboModuleJavaProviders.1.INSTANCE, (int)30, null);
        destination$iv$iv = packagesWithLibraryNames;
        boolean $i$f$filter22 = false;
        Iterator iterator = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ModelAutolinkingDependenciesPlatformAndroidJson it = (ModelAutolinkingDependenciesPlatformAndroidJson)element$iv$iv;
            boolean bl = false;
            if (!(it.getCxxModuleHeaderName() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String cppTurboModuleCxxProviders2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateCppFileContent.cppTurboModuleCxxProviders.2.INSTANCE, (int)30, null);
        Iterable $i$f$filter22 = packagesWithLibraryNames;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelAutolinkingDependenciesPlatformAndroidJson it = (ModelAutolinkingDependenciesPlatformAndroidJson)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getComponentDescriptors()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        String cppComponentDescriptors2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateCppFileContent.cppComponentDescriptors.2.INSTANCE, (int)30, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)CPP_TEMPLATE, (String)"{{ autolinkingCppIncludes }}", (String)cppIncludes2, (boolean)false, (int)4, null), (String)"{{ autolinkingCppTurboModuleJavaProviders }}", (String)cppTurboModuleJavaProviders2, (boolean)false, (int)4, null), (String)"{{ autolinkingCppTurboModuleCxxProviders }}", (String)cppTurboModuleCxxProviders2, (boolean)false, (int)4, null), (String)"{{ autolinkingCppComponentDescriptors }}", (String)cppComponentDescriptors2, (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/tasks/GenerateAutolinkingNewArchitecturesFileTask$Companion;", "", "()V", "CMAKE_FILENAME", "", "CMAKE_TEMPLATE", "getCMAKE_TEMPLATE", "()Ljava/lang/String;", "CODEGEN_LIB_PREFIX", "COMPONENT_DESCRIPTOR_FILENAME", "COMPONENT_INCLUDE_PATH", "CPP_FILENAME", "CPP_TEMPLATE", "getCPP_TEMPLATE", "H_FILENAME", "hTemplate", "getHTemplate", "react-native-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCMAKE_TEMPLATE() {
            return CMAKE_TEMPLATE;
        }

        @NotNull
        public final String getCPP_TEMPLATE() {
            return CPP_TEMPLATE;
        }

        @NotNull
        public final String getHTemplate() {
            return hTemplate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

