/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.tasks.GenerateCodegenSchemaTask;
import com.facebook.react.utils.Os;
import com.facebook.react.utils.TaskUtilsKt;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\r\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u001b\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/facebook/react/tasks/GenerateCodegenSchemaTask;", "Lorg/gradle/api/tasks/Exec;", "()V", "codegenDir", "Lorg/gradle/api/file/DirectoryProperty;", "getCodegenDir", "()Lorg/gradle/api/file/DirectoryProperty;", "generatedSchemaFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getGeneratedSchemaFile", "()Lorg/gradle/api/provider/Provider;", "generatedSrcDir", "getGeneratedSrcDir", "jsInputFiles", "Lorg/gradle/api/file/ConfigurableFileTree;", "kotlin.jvm.PlatformType", "getJsInputFiles", "()Lorg/gradle/api/file/ConfigurableFileTree;", "jsRootDir", "getJsRootDir", "nodeExecutableAndArgs", "Lorg/gradle/api/provider/ListProperty;", "", "getNodeExecutableAndArgs", "()Lorg/gradle/api/provider/ListProperty;", "exec", "", "setupCommandLine", "setupCommandLine$react_native_gradle_plugin", "wipeOutputDir", "wipeOutputDir$react_native_gradle_plugin", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateCodegenSchemaTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateCodegenSchemaTask.kt\ncom/facebook/react/tasks/GenerateCodegenSchemaTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,77:1\n37#2,2:78\n*S KotlinDebug\n*F\n+ 1 GenerateCodegenSchemaTask.kt\ncom/facebook/react/tasks/GenerateCodegenSchemaTask\n*L\n62#1:78,2\n*E\n"})
public abstract class GenerateCodegenSchemaTask
extends Exec {
    private final ConfigurableFileTree jsInputFiles = this.getProject().fileTree((Object)this.getJsRootDir(), arg_0 -> GenerateCodegenSchemaTask.jsInputFiles$lambda$0(jsInputFiles.1.INSTANCE, arg_0));
    @NotNull
    private final Provider<RegularFile> generatedSchemaFile;

    public GenerateCodegenSchemaTask() {
        Provider provider = this.getGeneratedSrcDir().file("schema.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        this.generatedSchemaFile = provider;
    }

    @Internal
    @NotNull
    public abstract DirectoryProperty getJsRootDir();

    @Internal
    @NotNull
    public abstract DirectoryProperty getCodegenDir();

    @Internal
    @NotNull
    public abstract DirectoryProperty getGeneratedSrcDir();

    @Input
    @NotNull
    public abstract ListProperty<String> getNodeExecutableAndArgs();

    @InputFiles
    public final ConfigurableFileTree getJsInputFiles() {
        return this.jsInputFiles;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getGeneratedSchemaFile() {
        return this.generatedSchemaFile;
    }

    protected void exec() {
        this.wipeOutputDir$react_native_gradle_plugin();
        this.setupCommandLine$react_native_gradle_plugin();
        super.exec();
    }

    public final void wipeOutputDir$react_native_gradle_plugin() {
        Object object = this.getGeneratedSrcDir().getAsFile().get();
        File $this$wipeOutputDir_u24lambda_u241 = (File)object;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$wipeOutputDir_u24lambda_u241);
        FilesKt.deleteRecursively((File)$this$wipeOutputDir_u24lambda_u241);
        $this$wipeOutputDir_u24lambda_u241.mkdirs();
    }

    public final void setupCommandLine$react_native_gradle_plugin() {
        File workingDir = this.getProject().getProjectDir();
        SpreadBuilder spreadBuilder = new SpreadBuilder(8);
        Object object = this.getNodeExecutableAndArgs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        File file = ((RegularFile)this.getCodegenDir().file("lib/cli/combine/combine-js-to-schema-cli.js").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Intrinsics.checkNotNull((Object)workingDir);
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(file, workingDir));
        spreadBuilder.add((Object)"--platform");
        spreadBuilder.add((Object)"android");
        spreadBuilder.add((Object)"--exclude");
        spreadBuilder.add((Object)"NativeSampleTurboModule");
        File file2 = ((RegularFile)this.generatedSchemaFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath(file2, workingDir));
        Object object2 = this.getJsRootDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        spreadBuilder.add((Object)Os.INSTANCE.cliPath((File)object2, workingDir));
        this.commandLine(TaskUtilsKt.windowsAwareCommandLine((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()])));
    }

    private static final void jsInputFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

