/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.tasks;

import com.facebook.react.model.ModelAutolinkingConfigJson;
import com.facebook.react.model.ModelAutolinkingDependenciesJson;
import com.facebook.react.model.ModelAutolinkingDependenciesPlatformAndroidJson;
import com.facebook.react.model.ModelAutolinkingDependenciesPlatformJson;
import com.facebook.react.utils.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ)\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u0015J)\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u0017J#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/facebook/react/tasks/GeneratePackageListTask;", "Lorg/gradle/api/DefaultTask;", "()V", "autolinkInputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAutolinkInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generatedOutputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getGeneratedOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "composeFileContent", "", "packageImports", "packageClassInstance", "composeFileContent$react_native_gradle_plugin", "composePackageImports", "packageName", "packages", "", "Lcom/facebook/react/model/ModelAutolinkingDependenciesPlatformAndroidJson;", "composePackageImports$react_native_gradle_plugin", "composePackageInstance", "composePackageInstance$react_native_gradle_plugin", "filterAndroidPackages", "model", "Lcom/facebook/react/model/ModelAutolinkingConfigJson;", "filterAndroidPackages$react_native_gradle_plugin", "taskAction", "", "Companion", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGeneratePackageListTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratePackageListTask.kt\ncom/facebook/react/tasks/GeneratePackageListTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n766#2:194\n857#2,2:195\n819#2:197\n847#2,2:198\n1179#2,2:200\n1253#2,4:202\n*S KotlinDebug\n*F\n+ 1 GeneratePackageListTask.kt\ncom/facebook/react/tasks/GeneratePackageListTask\n*L\n87#1:194\n87#1:195,2\n89#1:197\n89#1:198,2\n90#1:200,2\n90#1:202,4\n*E\n"})
public abstract class GeneratePackageListTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GENERATED_FILENAME = "com/facebook/react/PackageList.java";
    @NotNull
    private static final String generatedFileContentsTemplate = "package com.facebook.react;\n\nimport android.app.Application;\nimport android.content.Context;\nimport android.content.res.Resources;\n\nimport com.facebook.react.ReactPackage;\nimport com.facebook.react.shell.MainPackageConfig;\nimport com.facebook.react.shell.MainReactPackage;\nimport java.util.Arrays;\nimport java.util.ArrayList;\n\n{{ packageImports }}\n\npublic class PackageList {\n  private Application application;\n  private ReactNativeHost reactNativeHost;\n  private MainPackageConfig mConfig;\n\n  public PackageList(ReactNativeHost reactNativeHost) {\n    this(reactNativeHost, null);\n  }\n\n  public PackageList(Application application) {\n    this(application, null);\n  }\n\n  public PackageList(ReactNativeHost reactNativeHost, MainPackageConfig config) {\n    this.reactNativeHost = reactNativeHost;\n    mConfig = config;\n  }\n\n  public PackageList(Application application, MainPackageConfig config) {\n    this.reactNativeHost = null;\n    this.application = application;\n    mConfig = config;\n  }\n\n  private ReactNativeHost getReactNativeHost() {\n    return this.reactNativeHost;\n  }\n\n  private Resources getResources() {\n    return this.getApplication().getResources();\n  }\n\n  private Application getApplication() {\n    if (this.reactNativeHost == null) return this.application;\n    return this.reactNativeHost.getApplication();\n  }\n\n  private Context getApplicationContext() {\n    return this.getApplication().getApplicationContext();\n  }\n\n  public ArrayList<ReactPackage> getPackages() {\n    return new ArrayList<>(Arrays.<ReactPackage>asList(\n      new MainReactPackage(mConfig){{ packageClassInstances }}\n    ));\n  }\n}";

    public GeneratePackageListTask() {
        this.setGroup("react");
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getAutolinkInputFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getGeneratedOutputDirectory();

    @TaskAction
    public final void taskAction() {
        File file;
        File file2 = ((RegularFile)this.getAutolinkInputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        ModelAutolinkingConfigJson model = JsonUtils.INSTANCE.fromAutolinkingConfigJson(file2);
        Object object = model;
        if (object == null || (object = object.getProject()) == null || (object = object.getAndroid()) == null || (object = object.getPackageName()) == null) {
            throw new IllegalStateException("RNGP - Autolinking: Could not find project.android.packageName in react-native config output! Could not autolink packages without this field.".toString());
        }
        Object packageName = object;
        Map<String, ModelAutolinkingDependenciesPlatformAndroidJson> androidPackages = this.filterAndroidPackages$react_native_gradle_plugin(model);
        String packageImports = this.composePackageImports$react_native_gradle_plugin((String)packageName, androidPackages);
        String packageClassInstance = this.composePackageInstance$react_native_gradle_plugin((String)packageName, androidPackages);
        String generatedFileContents = this.composeFileContent$react_native_gradle_plugin(packageImports, packageClassInstance);
        File outputDir = ((Directory)this.getGeneratedOutputDirectory().get()).getAsFile();
        outputDir.mkdirs();
        File $this$taskAction_u24lambda_u240 = file = new File(outputDir, GENERATED_FILENAME);
        boolean bl = false;
        $this$taskAction_u24lambda_u240.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$taskAction_u24lambda_u240, (String)generatedFileContents, null, (int)2, null);
    }

    @NotNull
    public final String composePackageImports$react_native_gradle_plugin(@NotNull String packageName, @NotNull Map<String, ModelAutolinkingDependenciesPlatformAndroidJson> packages) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        return CollectionsKt.joinToString$default((Iterable)packages.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends ModelAutolinkingDependenciesPlatformAndroidJson>, CharSequence>(packageName){
            final /* synthetic */ String $packageName;
            {
                this.$packageName = $packageName;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<String, ModelAutolinkingDependenciesPlatformAndroidJson> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                String name = entry.getKey();
                ModelAutolinkingDependenciesPlatformAndroidJson dep = entry.getValue();
                String string = dep.getPackageImportPath();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "RNGP - Autolinking: Missing `packageImportPath` in `config` for dependency " + name + ". This is required to generate the autolinking package list.";
                    throw new IllegalArgumentException(string2.toString());
                }
                String packageImportPath = string;
                return "// " + name + "\n" + GeneratePackageListTask.Companion.interpolateDynamicValues$react_native_gradle_plugin(packageImportPath, this.$packageName);
            }
        }), (int)30, null);
    }

    @NotNull
    public final String composePackageInstance$react_native_gradle_plugin(@NotNull String packageName, @NotNull Map<String, ModelAutolinkingDependenciesPlatformAndroidJson> packages) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        return packages.isEmpty() ? "" : ",\n      " + CollectionsKt.joinToString$default((Iterable)packages.entrySet(), (CharSequence)",\n      ", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends ModelAutolinkingDependenciesPlatformAndroidJson>, CharSequence>(packageName){
            final /* synthetic */ String $packageName;
            {
                this.$packageName = $packageName;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<String, ModelAutolinkingDependenciesPlatformAndroidJson> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                String name = entry.getKey();
                ModelAutolinkingDependenciesPlatformAndroidJson dep = entry.getValue();
                String string = dep.getPackageInstance();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "RNGP - Autolinking: Missing `packageInstance` in `config` for dependency " + name + ". This is required to generate the autolinking package list.";
                    throw new IllegalArgumentException(string2.toString());
                }
                String packageInstance = string;
                return GeneratePackageListTask.Companion.interpolateDynamicValues$react_native_gradle_plugin(packageInstance, this.$packageName);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, ModelAutolinkingDependenciesPlatformAndroidJson> filterAndroidPackages$react_native_gradle_plugin(@Nullable ModelAutolinkingConfigJson model) {
        void $this$associateTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        ModelAutolinkingDependenciesJson it;
        Iterable $this$filterTo$iv$iv;
        Object object = model;
        if (object == null || (object = object.getDependencies()) == null || (object = object.values()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object packages = object;
        Iterable $this$filter$iv = (Iterable)packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModelAutolinkingDependenciesJson)element$iv$iv;
            boolean bl = false;
            ModelAutolinkingDependenciesPlatformJson modelAutolinkingDependenciesPlatformJson = it.getPlatforms();
            if (!((modelAutolinkingDependenciesPlatformJson != null ? modelAutolinkingDependenciesPlatformJson.getAndroid() : null) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ModelAutolinkingDependenciesJson)element$iv$iv;
            boolean bl = false;
            ModelAutolinkingDependenciesPlatformJson modelAutolinkingDependenciesPlatformJson = it.getPlatforms();
            if (modelAutolinkingDependenciesPlatformJson != null && (modelAutolinkingDependenciesPlatformJson = modelAutolinkingDependenciesPlatformJson.getAndroid()) != null ? Intrinsics.areEqual((Object)modelAutolinkingDependenciesPlatformJson.isPureCxxDependency(), (Object)true) : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            ModelAutolinkingDependenciesJson it2 = (ModelAutolinkingDependenciesJson)element$iv$iv;
            boolean bl = false;
            ModelAutolinkingDependenciesPlatformJson modelAutolinkingDependenciesPlatformJson = it2.getPlatforms();
            Object object2 = modelAutolinkingDependenciesPlatformJson != null ? modelAutolinkingDependenciesPlatformJson.getAndroid() : null;
            if (object2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Pair pair = TuplesKt.to((Object)it2.getName(), (Object)object2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @NotNull
    public final String composeFileContent$react_native_gradle_plugin(@NotNull String packageImports, @NotNull String packageClassInstance) {
        Intrinsics.checkNotNullParameter((Object)packageImports, (String)"packageImports");
        Intrinsics.checkNotNullParameter((Object)packageClassInstance, (String)"packageClassInstance");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)generatedFileContentsTemplate, (String)"{{ packageImports }}", (String)packageImports, (boolean)false, (int)4, null), (String)"{{ packageClassInstances }}", (String)packageClassInstance, (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/facebook/react/tasks/GeneratePackageListTask$Companion;", "", "()V", "GENERATED_FILENAME", "", "generatedFileContentsTemplate", "getGeneratedFileContentsTemplate", "()Ljava/lang/String;", "interpolateDynamicValues", "input", "packageName", "interpolateDynamicValues$react_native_gradle_plugin", "react-native-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String interpolateDynamicValues$react_native_gradle_plugin(@NotNull String input, @NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            CharSequence charSequence = input;
            Regex regex = new Regex("([^.\\w])(BuildConfig|R)(\\W)");
            Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(packageName){
                final /* synthetic */ String $packageName;
                {
                    this.$packageName = $packageName;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult match) {
                    Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                    MatchResult.Destructured destructured = match.getDestructured();
                    String prefix = (String)destructured.getMatch().getGroupValues().get(1);
                    String className = (String)destructured.getMatch().getGroupValues().get(2);
                    String suffix = (String)destructured.getMatch().getGroupValues().get(3);
                    return prefix + this.$packageName + "." + className + suffix;
                }
            };
            return regex.replace(charSequence, function1);
        }

        @NotNull
        public final String getGeneratedFileContentsTemplate() {
            return generatedFileContentsTemplate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

