/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.facebook.react.ReactExtension;
import com.facebook.react.utils.AgpConfiguratorUtils;
import com.facebook.react.utils.ProjectUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.AppliedPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/facebook/react/utils/AgpConfiguratorUtils;", "", "()V", "configureBuildConfigFieldsForApp", "", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/facebook/react/ReactExtension;", "configureBuildConfigFieldsForLibraries", "appProject", "configureDevPorts", "configureNamespaceForLibraries", "react-native-gradle-plugin"})
public final class AgpConfiguratorUtils {
    @NotNull
    public static final AgpConfiguratorUtils INSTANCE = new AgpConfiguratorUtils();

    private AgpConfiguratorUtils() {
    }

    public final void configureBuildConfigFieldsForApp(@NotNull Project project, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Action action2 = arg_0 -> AgpConfiguratorUtils.configureBuildConfigFieldsForApp$lambda$0(project, extension, arg_0);
        project.getPluginManager().withPlugin("com.android.application", action2);
        project.getPluginManager().withPlugin("com.android.library", action2);
    }

    public final void configureBuildConfigFieldsForLibraries(@NotNull Project appProject) {
        Intrinsics.checkNotNullParameter((Object)appProject, (String)"appProject");
        appProject.getRootProject().allprojects(arg_0 -> AgpConfiguratorUtils.configureBuildConfigFieldsForLibraries$lambda$1(configureBuildConfigFieldsForLibraries.1.INSTANCE, arg_0));
    }

    public final void configureDevPorts(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object v = project.getProperties().get("reactNativeDevServerPort");
        if (v == null || (v = v.toString()) == null) {
            v = "8081";
        }
        Object devServerPort = v;
        Action action2 = arg_0 -> AgpConfiguratorUtils.configureDevPorts$lambda$2(project, devServerPort, arg_0);
        project.getPluginManager().withPlugin("com.android.application", action2);
        project.getPluginManager().withPlugin("com.android.library", action2);
    }

    public final void configureNamespaceForLibraries(@NotNull Project appProject) {
        Intrinsics.checkNotNullParameter((Object)appProject, (String)"appProject");
        appProject.getRootProject().allprojects(arg_0 -> AgpConfiguratorUtils.configureNamespaceForLibraries$lambda$3(configureNamespaceForLibraries.1.INSTANCE, arg_0));
    }

    private static final void configureBuildConfigFieldsForApp$lambda$0(Project $project, ReactExtension $extension, AppliedPlugin it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        ((AndroidComponentsExtension)$project.getExtensions().getByType(AndroidComponentsExtension.class)).finalizeDsl(new Function1<CommonExtension<?, ?, ?, ?, ?, ?>, Unit>($project, $extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $extension;
            {
                this.$project = $project;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(@NotNull CommonExtension<?, ?, ?, ?, ?, ?> ext) {
                Intrinsics.checkNotNullParameter(ext, (String)"ext");
                ext.getBuildFeatures().setBuildConfig(Boolean.valueOf(true));
                ext.getDefaultConfig().buildConfigField("boolean", "IS_NEW_ARCHITECTURE_ENABLED", String.valueOf(ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(this.$project, this.$extension)));
                ext.getDefaultConfig().buildConfigField("boolean", "IS_HERMES_ENABLED", String.valueOf(ProjectUtils.INSTANCE.isHermesEnabled$react_native_gradle_plugin(this.$project)));
            }
        });
    }

    private static final void configureBuildConfigFieldsForLibraries$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDevPorts$lambda$2(Project $project, String $devServerPort, AppliedPlugin it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$devServerPort, (String)"$devServerPort");
        ((AndroidComponentsExtension)$project.getExtensions().getByType(AndroidComponentsExtension.class)).finalizeDsl(new Function1<CommonExtension<?, ?, ?, ?, ?, ?>, Unit>($devServerPort){
            final /* synthetic */ String $devServerPort;
            {
                this.$devServerPort = $devServerPort;
                super(1);
            }

            public final void invoke(@NotNull CommonExtension<?, ?, ?, ?, ?, ?> ext) {
                Intrinsics.checkNotNullParameter(ext, (String)"ext");
                ext.getDefaultConfig().resValue("integer", "react_native_dev_server_port", this.$devServerPort);
            }
        });
    }

    private static final void configureNamespaceForLibraries$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

