/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/utils/BackwardCompatUtils;", "", "()V", "configureBackwardCompatibilityReactMap", "", "project", "Lorg/gradle/api/Project;", "react-native-gradle-plugin"})
public final class BackwardCompatUtils {
    @NotNull
    public static final BackwardCompatUtils INSTANCE = new BackwardCompatUtils();

    private BackwardCompatUtils() {
    }

    public final void configureBackwardCompatibilityReactMap(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.getExtensions().getExtraProperties().has("react")) {
            Map reactMap;
            Object object = project.getExtensions().getExtraProperties().get("react");
            Map map = object instanceof Map ? (Map)object : null;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            if (!(reactMap = map).isEmpty()) {
                project.getLogger().error("********************************************************************************\n\nERROR: Using old project.ext.react configuration.\nWe identified that your project is using a old configuration block as:\n\nproject.ext.react = [\n    // ...\n]\n\nYou should migrate to the new configuration:\n\nreact {\n    // ...\n}\nYou can find documentation inside `android/app/build.gradle` on how to use it.\n\n********************************************************************************");
            }
        }
        project.getExtensions().getExtraProperties().set("react", (Object)MapsKt.emptyMap());
    }
}

