/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.facebook.react.utils.DependencyUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ7\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0010J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/utils/DependencyUtils;", "", "()V", "configureDependencies", "", "project", "Lorg/gradle/api/Project;", "versionString", "", "groupString", "configureRepositories", "reactNativeDir", "Ljava/io/File;", "getDependencySubstitutions", "", "Lkotlin/Triple;", "getDependencySubstitutions$react_native_gradle_plugin", "readVersionAndGroupStrings", "Lkotlin/Pair;", "propertiesFile", "mavenRepoFromURI", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "uri", "Ljava/net/URI;", "mavenRepoFromUrl", "url", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyUtils.kt\ncom/facebook/react/utils/DependencyUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class DependencyUtils {
    @NotNull
    public static final DependencyUtils INSTANCE = new DependencyUtils();

    private DependencyUtils() {
    }

    public final void configureRepositories(@NotNull Project project, @NotNull File reactNativeDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reactNativeDir, (String)"reactNativeDir");
        project.getRootProject().allprojects(arg_0 -> DependencyUtils.configureRepositories$lambda$0((Function1)new Function1<Project, Unit>(reactNativeDir){
            final /* synthetic */ File $reactNativeDir;
            {
                this.$reactNativeDir = $reactNativeDir;
                super(1);
            }

            public final void invoke(Project eachProject) {
                File file = this.$reactNativeDir;
                Project $this$invoke_u24lambda_u241 = eachProject;
                boolean bl = false;
                if ($this$invoke_u24lambda_u241.hasProperty("react.internal.mavenLocalRepo")) {
                    Object object = $this$invoke_u24lambda_u241.property("react.internal.mavenLocalRepo");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    String mavenLocalRepoPath = (String)object;
                    Intrinsics.checkNotNull((Object)$this$invoke_u24lambda_u241);
                    URI uRI = new File(mavenLocalRepoPath).toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    DependencyUtils.INSTANCE.mavenRepoFromURI($this$invoke_u24lambda_u241, uRI);
                }
                Intrinsics.checkNotNull((Object)$this$invoke_u24lambda_u241);
                DependencyUtils.INSTANCE.mavenRepoFromUrl($this$invoke_u24lambda_u241, "https://oss.sonatype.org/content/repositories/snapshots/");
                $this$invoke_u24lambda_u241.getRepositories().mavenCentral(arg_0 -> configureRepositories.1.invoke$lambda$1$lambda$0((Function1)new Function1<MavenArtifactRepository, Unit>($this$invoke_u24lambda_u241){
                    final /* synthetic */ Project $this_with;
                    {
                        this.$this_with = $receiver;
                        super(1);
                    }

                    public final void invoke(MavenArtifactRepository repo) {
                        repo.content(arg_0 -> configureRepositories.1.1.invoke$lambda$0(configureRepositories.1.1.INSTANCE, arg_0));
                        if (this.$this_with.hasProperty("react.internal.mavenLocalRepo")) {
                            repo.content(arg_0 -> configureRepositories.1.1.invoke$lambda$1(configureRepositories.1.2.INSTANCE, arg_0));
                        }
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }

                    private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
                if (file.exists()) {
                    URI uRI = new File(file, "../jsc-android/dist").toURI();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
                    DependencyUtils.INSTANCE.mavenRepoFromURI($this$invoke_u24lambda_u241, uRI);
                }
                $this$invoke_u24lambda_u241.getRepositories().google();
                DependencyUtils.INSTANCE.mavenRepoFromUrl($this$invoke_u24lambda_u241, "https://www.jitpack.io");
            }

            private static final void invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    public final void configureDependencies(@NotNull Project project, @NotNull String versionString, @NotNull String groupString) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Intrinsics.checkNotNullParameter((Object)groupString, (String)"groupString");
        if (StringsKt.isBlank((CharSequence)versionString)) {
            return;
        }
        project.getRootProject().allprojects(arg_0 -> DependencyUtils.configureDependencies$lambda$1((Function1)new Function1<Project, Unit>(groupString, versionString){
            final /* synthetic */ String $groupString;
            final /* synthetic */ String $versionString;
            {
                this.$groupString = $groupString;
                this.$versionString = $versionString;
                super(1);
            }

            public final void invoke(Project eachProject) {
                eachProject.getConfigurations().all(arg_0 -> configureDependencies.1.invoke$lambda$0((Function1)new Function1<Configuration, Unit>(this.$groupString, this.$versionString, eachProject){
                    final /* synthetic */ String $groupString;
                    final /* synthetic */ String $versionString;
                    final /* synthetic */ Project $eachProject;
                    {
                        this.$groupString = $groupString;
                        this.$versionString = $versionString;
                        this.$eachProject = $eachProject;
                        super(1);
                    }

                    public final void invoke(Configuration configuration) {
                        configuration.getResolutionStrategy().dependencySubstitution(arg_0 -> configureDependencies.1.invoke$lambda$0((Function1)new Function1<DependencySubstitutions, Unit>(this.$versionString, this.$groupString){
                            final /* synthetic */ String $versionString;
                            final /* synthetic */ String $groupString;
                            {
                                this.$versionString = $versionString;
                                this.$groupString = $groupString;
                                super(1);
                            }

                            public final void invoke(DependencySubstitutions it) {
                                Iterable $this$forEach$iv = DependencyUtils.INSTANCE.getDependencySubstitutions$react_native_gradle_plugin(this.$versionString, this.$groupString);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Triple triple = (Triple)element$iv;
                                    boolean bl = false;
                                    String module = (String)triple.component1();
                                    String dest = (String)triple.component2();
                                    String reason = (String)triple.component3();
                                    it.substitute(it.module(module)).using(it.module(dest)).because(reason);
                                }
                            }
                        }, arg_0));
                        Object[] objectArray = new Object[]{this.$groupString + ":react-android:" + this.$versionString};
                        configuration.getResolutionStrategy().force(objectArray);
                        objectArray = this.$eachProject.findProperty("react.internal.useHermesNightly");
                        if (!Boolean.parseBoolean(objectArray instanceof String ? (String)objectArray : null)) {
                            objectArray = new Object[]{this.$groupString + ":hermes-android:" + this.$versionString};
                            configuration.getResolutionStrategy().force(objectArray);
                        }
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    public static /* synthetic */ void configureDependencies$default(DependencyUtils dependencyUtils, Project project, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "com.facebook.react";
        }
        dependencyUtils.configureDependencies(project, string, string2);
    }

    @NotNull
    public final List<Triple<String, String, String>> getDependencySubstitutions$react_native_gradle_plugin(@NotNull String versionString, @NotNull String groupString) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Intrinsics.checkNotNullParameter((Object)groupString, (String)"groupString");
        List dependencySubstitution = new ArrayList();
        dependencySubstitution.add(new Triple((Object)"com.facebook.react:react-native", (Object)(groupString + ":react-android:" + versionString), (Object)"The react-native artifact was deprecated in favor of react-android due to https://github.com/facebook/react-native/issues/35210."));
        dependencySubstitution.add(new Triple((Object)"com.facebook.react:hermes-engine", (Object)(groupString + ":hermes-android:" + versionString), (Object)"The hermes-engine artifact was deprecated in favor of hermes-android due to https://github.com/facebook/react-native/issues/35210."));
        if (!Intrinsics.areEqual((Object)groupString, (Object)"com.facebook.react")) {
            dependencySubstitution.add(new Triple((Object)"com.facebook.react:react-android", (Object)(groupString + ":react-android:" + versionString), (Object)"The react-android dependency was modified to use the correct Maven group."));
            dependencySubstitution.add(new Triple((Object)"com.facebook.react:hermes-android", (Object)(groupString + ":hermes-android:" + versionString), (Object)"The hermes-android dependency was modified to use the correct Maven group."));
        }
        return dependencySubstitution;
    }

    public static /* synthetic */ List getDependencySubstitutions$react_native_gradle_plugin$default(DependencyUtils dependencyUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "com.facebook.react";
        }
        return dependencyUtils.getDependencySubstitutions$react_native_gradle_plugin(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<String, String> readVersionAndGroupStrings(@NotNull File propertiesFile) {
        String versionStringFromFile;
        Intrinsics.checkNotNullParameter((Object)propertiesFile, (String)"propertiesFile");
        Properties reactAndroidProperties = new Properties();
        Closeable closeable = new FileInputStream(propertiesFile);
        Object object = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            reactAndroidProperties.load(it);
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            object = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        object = reactAndroidProperties.get("VERSION_NAME");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "";
        }
        String versionString = StringsKt.startsWith$default((String)(versionStringFromFile = string), (String)"0.0.0", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)versionStringFromFile, (CharSequence)"-nightly-", (boolean)false, (int)2, null) ? versionStringFromFile + "-SNAPSHOT" : versionStringFromFile;
        Object object2 = reactAndroidProperties.get("react.internal.publishingGroup");
        String string2 = object2 instanceof String ? (String)object2 : null;
        if (string2 == null) {
            string2 = "com.facebook.react";
        }
        String groupString = string2;
        return new Pair((Object)versionString, (Object)groupString);
    }

    @NotNull
    public final MavenArtifactRepository mavenRepoFromUrl(@NotNull Project $this$mavenRepoFromUrl, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$mavenRepoFromUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        MavenArtifactRepository mavenArtifactRepository = $this$mavenRepoFromUrl.getProject().getRepositories().maven(arg_0 -> DependencyUtils.mavenRepoFromUrl$lambda$3((Function1)new Function1<MavenArtifactRepository, Unit>(url){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            public final void invoke(MavenArtifactRepository it) {
                it.setUrl(URI.create(this.$url));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifactRepository, (String)"maven(...)");
        return mavenArtifactRepository;
    }

    @NotNull
    public final MavenArtifactRepository mavenRepoFromURI(@NotNull Project $this$mavenRepoFromURI, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)$this$mavenRepoFromURI, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        MavenArtifactRepository mavenArtifactRepository = $this$mavenRepoFromURI.getProject().getRepositories().maven(arg_0 -> DependencyUtils.mavenRepoFromURI$lambda$4((Function1)new Function1<MavenArtifactRepository, Unit>(uri){
            final /* synthetic */ URI $uri;
            {
                this.$uri = $uri;
                super(1);
            }

            public final void invoke(MavenArtifactRepository it) {
                it.setUrl(this.$uri);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mavenArtifactRepository, (String)"maven(...)");
        return mavenArtifactRepository;
    }

    private static final void configureRepositories$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencies$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void mavenRepoFromUrl$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void mavenRepoFromURI$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

