/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.facebook.react.ReactExtension;
import com.facebook.react.utils.ProjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.AppliedPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J&\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/utils/NdkConfiguratorUtils;", "", "()V", "configureJsEnginePackagingOptions", "", "config", "Lcom/facebook/react/ReactExtension;", "variant", "Lcom/android/build/api/variant/Variant;", "hermesEnabled", "", "configureNewArchPackagingOptions", "project", "Lorg/gradle/api/Project;", "extension", "configureReactNativeNdk", "getPackagingOptionsForVariant", "Lkotlin/Pair;", "", "", "react-native-gradle-plugin"})
public final class NdkConfiguratorUtils {
    @NotNull
    public static final NdkConfiguratorUtils INSTANCE = new NdkConfiguratorUtils();

    private NdkConfiguratorUtils() {
    }

    public final void configureReactNativeNdk(@NotNull Project project, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> NdkConfiguratorUtils.configureReactNativeNdk$lambda$0((Function1)new Function1<AppliedPlugin, Unit>(project, extension){
            final /* synthetic */ Project $project;
            final /* synthetic */ ReactExtension $extension;
            {
                this.$project = $project;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(AppliedPlugin it) {
                ((AndroidComponentsExtension)this.$project.getExtensions().getByType(AndroidComponentsExtension.class)).finalizeDsl((Function1)new Function1<CommonExtension<?, ?, ?, ?, ?, ?>, Unit>(this.$project, this.$extension){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ReactExtension $extension;
                    {
                        this.$project = $project;
                        this.$extension = $extension;
                        super(1);
                    }

                    public final void invoke(@NotNull CommonExtension<?, ?, ?, ?, ?, ?> ext) {
                        List<String> architectures;
                        boolean bl;
                        List cmakeArgs;
                        block22: {
                            boolean bl2;
                            String it;
                            boolean $i$f$none;
                            Iterable $this$none$iv;
                            block21: {
                                boolean bl3;
                                block20: {
                                    boolean bl4;
                                    block19: {
                                        Intrinsics.checkNotNullParameter(ext, (String)"ext");
                                        if (!ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(this.$project, this.$extension)) {
                                            return;
                                        }
                                        ext.getBuildFeatures().setPrefab(Boolean.valueOf(true));
                                        if (ext.getExternalNativeBuild().getCmake().getPath() == null) {
                                            ext.getExternalNativeBuild().getCmake().setPath(new File(((Directory)this.$extension.getReactNativeDir().get()).getAsFile(), "ReactAndroid/cmake-utils/default-app-setup/CMakeLists.txt"));
                                        }
                                        cmakeArgs = ext.getDefaultConfig().getExternalNativeBuild().getCmake().getArguments();
                                        $this$none$iv = cmakeArgs;
                                        $i$f$none = false;
                                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                            bl4 = true;
                                        } else {
                                            for (T element$iv : $this$none$iv) {
                                                it = (String)element$iv;
                                                boolean bl5 = false;
                                                if (!StringsKt.startsWith$default((String)it, (String)"-DPROJECT_BUILD_DIR", (boolean)false, (int)2, null)) continue;
                                                bl4 = false;
                                                break block19;
                                            }
                                            bl4 = true;
                                        }
                                    }
                                    if (bl4) {
                                        cmakeArgs.add("-DPROJECT_BUILD_DIR=" + ((Directory)this.$project.getLayout().getBuildDirectory().get()).getAsFile());
                                    }
                                    $this$none$iv = cmakeArgs;
                                    $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl3 = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            it = (String)element$iv;
                                            boolean bl6 = false;
                                            if (!StringsKt.startsWith$default((String)it, (String)"-DREACT_ANDROID_DIR", (boolean)false, (int)2, null)) continue;
                                            bl3 = false;
                                            break block20;
                                        }
                                        bl3 = true;
                                    }
                                }
                                if (bl3) {
                                    cmakeArgs.add("-DREACT_ANDROID_DIR=" + ((RegularFile)this.$extension.getReactNativeDir().file("ReactAndroid").get()).getAsFile());
                                }
                                $this$none$iv = cmakeArgs;
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl2 = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        it = (String)element$iv;
                                        boolean bl7 = false;
                                        if (!StringsKt.startsWith$default((String)it, (String)"-DANDROID_STL", (boolean)false, (int)2, null)) continue;
                                        bl2 = false;
                                        break block21;
                                    }
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                cmakeArgs.add("-DANDROID_STL=c++_shared");
                            }
                            $this$none$iv = cmakeArgs;
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    it = (String)element$iv;
                                    boolean bl8 = false;
                                    if (!StringsKt.startsWith$default((String)it, (String)"-DANDROID_USE_LEGACY_TOOLCHAIN_FILE", (boolean)false, (int)2, null)) continue;
                                    bl = false;
                                    break block22;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            cmakeArgs.add("-DANDROID_USE_LEGACY_TOOLCHAIN_FILE=ON");
                        }
                        if (!((Collection)(architectures = ProjectUtils.INSTANCE.getReactNativeArchitectures$react_native_gradle_plugin(this.$project))).isEmpty() && !ext.getSplits().getAbi().isEnable()) {
                            ext.getDefaultConfig().getNdk().getAbiFilters().addAll((Collection)architectures);
                        }
                    }
                });
            }
        }, arg_0));
    }

    public final void configureNewArchPackagingOptions(@NotNull Project project, @NotNull ReactExtension extension, @NotNull Variant variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (!ProjectUtils.INSTANCE.isNewArchEnabled$react_native_gradle_plugin(project, extension)) {
            Object[] objectArray = new String[]{"**/libfbjni.so", "**/libc++_shared.so"};
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)CollectionsKt.listOf((Object[])objectArray));
        } else {
            Object[] objectArray = new String[]{"**/libfbjni.so", "**/libfabricjni.so", "**/libfolly_runtime.so", "**/libglog.so", "**/libjsi.so", "**/libmapbufferjni.so", "**/libreact_codegen_rncore.so", "**/libreact_debug.so", "**/libreact_nativemodule_core.so", "**/libreact_newarchdefaults.so", "**/libreact_cxxreactpackage.so", "**/libreact_render_componentregistry.so", "**/libreact_render_core.so", "**/libreact_render_debug.so", "**/libreact_render_graphics.so", "**/libreact_render_imagemanager.so", "**/libreact_render_mapbuffer.so", "**/libreact_utils.so", "**/librrc_image.so", "**/librrc_legacyviewmanagerinterop.so", "**/librrc_textinput.so", "**/librrc_view.so", "**/libruntimeexecutor.so", "**/libturbomodulejsijni.so", "**/libyoga.so", "**/libc++_shared.so"};
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)CollectionsKt.listOf((Object[])objectArray));
        }
    }

    public final void configureJsEnginePackagingOptions(@NotNull ReactExtension config, @NotNull Variant variant, boolean hermesEnabled) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Object object = config.getEnableSoCleanup().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            Pair<List<String>, List<String>> pair = this.getPackagingOptionsForVariant(hermesEnabled);
            List excludes = (List)pair.component1();
            List includes = (List)pair.component2();
            variant.getPackaging().getJniLibs().getExcludes().addAll((Iterable)excludes);
            variant.getPackaging().getJniLibs().getPickFirsts().addAll((Iterable)includes);
        }
    }

    @NotNull
    public final Pair<List<String>, List<String>> getPackagingOptionsForVariant(boolean hermesEnabled) {
        List excludes = new ArrayList();
        List includes = new ArrayList();
        if (hermesEnabled) {
            excludes.add("**/libjsc.so");
            excludes.add("**/libjscexecutor.so");
            includes.add("**/libhermes.so");
            includes.add("**/libhermes_executor.so");
        } else {
            excludes.add("**/libhermes.so");
            excludes.add("**/libhermes_executor.so");
            includes.add("**/libjsc.so");
            includes.add("**/libjscexecutor.so");
        }
        return TuplesKt.to((Object)excludes, (Object)includes);
    }

    private static final void configureReactNativeNdk$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

