/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.facebook.react.ReactExtension;
import com.facebook.react.model.ModelPackageJson;
import com.facebook.react.utils.JsonUtils;
import com.facebook.react.utils.Os;
import com.facebook.react.utils.PathUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002\u001a&\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u001a\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\b\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\b\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"HERMESC_BUILT_FROM_SOURCE_DIR", "", "HERMESC_IN_REACT_NATIVE_DIR", "detectCliFile", "Ljava/io/File;", "reactNativeRoot", "preconfiguredCliFile", "detectEntryFile", "entryFile", "reactRoot", "envVariableOverride", "detectOSAwareHermesCommand", "projectRoot", "hermesCommand", "detectedCliFile", "config", "Lcom/facebook/react/ReactExtension;", "detectedEntryFile", "detectedHermesCommand", "findPackageJsonFile", "project", "Lorg/gradle/api/Project;", "rootProperty", "Lorg/gradle/api/file/DirectoryProperty;", "getBuiltHermescFile", "pathOverride", "getHermesCBin", "getHermesOSBin", "projectPathToLibraryName", "projectPath", "readPackageJsonFile", "Lcom/facebook/react/model/ModelPackageJson;", "react-native-gradle-plugin"})
@JvmName(name="PathUtils")
@SourceDebugExtension(value={"SMAP\nPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathUtils.kt\ncom/facebook/react/utils/PathUtils\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n26#2:234\n1#3:235\n*S KotlinDebug\n*F\n+ 1 PathUtils.kt\ncom/facebook/react/utils/PathUtils\n*L\n85#1:234\n*E\n"})
public final class PathUtils {
    @NotNull
    private static final String HERMESC_IN_REACT_NATIVE_DIR = "node_modules/react-native/sdks/hermesc/%OS-BIN%/";
    @NotNull
    private static final String HERMESC_BUILT_FROM_SOURCE_DIR = "node_modules/react-native/ReactAndroid/hermes-engine/build/hermes/bin/";

    @NotNull
    public static final File detectedEntryFile(@NotNull ReactExtension config, @Nullable String envVariableOverride) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        RegularFile regularFile = (RegularFile)config.getEntryFile().getOrNull();
        File file = regularFile != null ? regularFile.getAsFile() : null;
        File file2 = ((Directory)config.getRoot().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        return PathUtils.detectEntryFile(file, file2, envVariableOverride);
    }

    public static /* synthetic */ File detectedEntryFile$default(ReactExtension reactExtension, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return PathUtils.detectedEntryFile(reactExtension, string);
    }

    @NotNull
    public static final File detectedCliFile(@NotNull ReactExtension config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        File file = ((Directory)config.getRoot().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        return PathUtils.detectCliFile(file, (File)config.getCliFile().getAsFile().getOrNull());
    }

    @NotNull
    public static final String detectedHermesCommand(@NotNull ReactExtension config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        File file = ((Directory)config.getRoot().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Object object = config.getHermesCommand().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return PathUtils.detectOSAwareHermesCommand(file, (String)object);
    }

    private static final File detectEntryFile(File entryFile, File reactRoot, String envVariableOverride) {
        File file;
        if (envVariableOverride != null) {
            file = new File(reactRoot, envVariableOverride);
        } else {
            file = entryFile;
            if (file == null) {
                file = new File(reactRoot, "index.android.js").exists() ? new File(reactRoot, "index.android.js") : new File(reactRoot, "index.js");
            }
        }
        return file;
    }

    static /* synthetic */ File detectEntryFile$default(File file, File file2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return PathUtils.detectEntryFile(file, file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File detectCliFile(File reactNativeRoot, File preconfiguredCliFile) {
        File nodeModuleCliJs;
        String string;
        if (preconfiguredCliFile != null && preconfiguredCliFile.exists()) {
            return preconfiguredCliFile;
        }
        String[] stringArray = new String[]{"node", "--print", "require.resolve('react-native/cli');"};
        boolean $i$f$emptyArray = false;
        Process nodeProcess = Runtime.getRuntime().exec(stringArray, new String[0], reactNativeRoot);
        Closeable closeable = nodeProcess.getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            InputStream inputStream = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            string = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String nodeProcessOutput = string;
        if (((CharSequence)nodeProcessOutput).length() > 0 && (nodeModuleCliJs = new File(nodeProcessOutput)).exists()) {
            return nodeModuleCliJs;
        }
        File rootCliJs = new File(reactNativeRoot, "node_modules/react-native/cli.js");
        if (rootCliJs.exists()) {
            return rootCliJs;
        }
        throw new IllegalStateException("Couldn't determine CLI location!\n\nPlease set `react { cliFile = file(...) }` inside your\nbuild.gradle to the path of the react-native cli.js file.\nThis file typically resides in `node_modules/react-native/cli.js`".toString());
    }

    @NotNull
    public static final String detectOSAwareHermesCommand(@NotNull File projectRoot, @NotNull String hermesCommand) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter((Object)hermesCommand, (String)"hermesCommand");
        if (!StringsKt.isBlank((CharSequence)hermesCommand)) {
            String osSpecificHermesCommand = StringsKt.contains$default((CharSequence)hermesCommand, (CharSequence)"%OS-BIN%", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)hermesCommand, (String)"%OS-BIN%", (String)PathUtils.getHermesOSBin(), (boolean)false, (int)4, null) : hermesCommand;
            return StringsKt.replace$default((String)osSpecificHermesCommand, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
        File builtHermesc = PathUtils.getBuiltHermescFile(projectRoot, System.getenv("REACT_NATIVE_OVERRIDE_HERMES_DIR"));
        if (builtHermesc.exists()) {
            return Os.INSTANCE.cliPath(builtHermesc, projectRoot);
        }
        String prebuiltHermesPath = StringsKt.replace$default((String)StringsKt.replace$default((String)(HERMESC_IN_REACT_NATIVE_DIR + PathUtils.getHermesCBin()), (String)"%OS-BIN%", (String)PathUtils.getHermesOSBin(), (boolean)false, (int)4, null), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        File prebuiltHermes = new File(projectRoot, prebuiltHermesPath);
        if (prebuiltHermes.exists()) {
            return Os.INSTANCE.cliPath(prebuiltHermes, projectRoot);
        }
        throw new IllegalStateException("Couldn't determine Hermesc location. Please set `react.hermesCommand` to the path of the hermesc binary file. node_modules/react-native/sdks/hermesc/%OS-BIN%/hermesc".toString());
    }

    @NotNull
    public static final File getBuiltHermescFile(@NotNull File projectRoot, @Nullable String pathOverride) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        CharSequence charSequence = pathOverride;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? new File(pathOverride, "build/bin/" + PathUtils.getHermesCBin()) : new File(projectRoot, HERMESC_BUILT_FROM_SOURCE_DIR + PathUtils.getHermesCBin());
    }

    @NotNull
    public static final String getHermesCBin() {
        return Os.INSTANCE.isWindows() ? "hermesc.exe" : "hermesc";
    }

    @NotNull
    public static final String getHermesOSBin() {
        if (Os.INSTANCE.isWindows()) {
            return "win64-bin";
        }
        if (Os.INSTANCE.isMac()) {
            return "osx-bin";
        }
        if (Os.INSTANCE.isLinuxAmd64()) {
            return "linux64-bin";
        }
        throw new IllegalStateException("OS not recognized. Please set project.react.hermesCommand to the path of a working Hermes compiler.".toString());
    }

    @NotNull
    public static final String projectPathToLibraryName(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        char[] cArray = new char[]{':', '-', '_', '.'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)projectPath, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)projectPathToLibraryName.1.INSTANCE, (int)30, null) + "Spec";
    }

    @Nullable
    public static final File findPackageJsonFile(@NotNull Project project, @NotNull DirectoryProperty rootProperty) {
        File fromExtension;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProperty, (String)"rootProperty");
        File inParent = project.file((Object)"../package.json");
        if (inParent.exists()) {
            return inParent;
        }
        RegularFile regularFile = (RegularFile)rootProperty.file("package.json").getOrNull();
        File file = fromExtension = regularFile != null ? regularFile.getAsFile() : null;
        boolean bl = file != null ? file.exists() : false;
        if (bl) {
            return fromExtension;
        }
        return null;
    }

    @Nullable
    public static final ModelPackageJson readPackageJsonFile(@NotNull Project project, @NotNull DirectoryProperty rootProperty) {
        ModelPackageJson modelPackageJson;
        File packageJson;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootProperty, (String)"rootProperty");
        File file = packageJson = PathUtils.findPackageJsonFile(project, rootProperty);
        if (file != null) {
            File it = file;
            boolean bl = false;
            modelPackageJson = JsonUtils.INSTANCE.fromPackageJson(it);
        } else {
            modelPackageJson = null;
        }
        return modelPackageJson;
    }
}

