/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.utils;

import com.facebook.react.ReactExtension;
import com.facebook.react.model.ModelPackageJson;
import com.facebook.react.utils.JsonUtils;
import com.facebook.react.utils.KotlinStdlibCompatUtils;
import com.facebook.react.utils.PathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u0019\u0010\u0010\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\u00020\u0004*\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0019\u0010\u0017\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001aJ\u0019\u0010\n\u001a\u00020\u000b*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001dJ\u0019\u0010\u001e\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0004*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/facebook/react/utils/ProjectUtils;", "", "()V", "HERMES_FALLBACK", "", "isHermesEnabled", "Lorg/gradle/api/Project;", "isHermesEnabled$react_native_gradle_plugin", "(Lorg/gradle/api/Project;)Z", "shouldEnableNewArchForReactNativeVersion", "reactNativeDir", "", "shouldEnableNewArchForReactNativeVersion$react_native_gradle_plugin", "getReactNativeArchitectures", "", "getReactNativeArchitectures$react_native_gradle_plugin", "hasPropertySetToFalse", "property", "hasPropertySetToFalse$react_native_gradle_plugin", "isNewArchEnabled", "extension", "Lcom/facebook/react/ReactExtension;", "isNewArchEnabled$react_native_gradle_plugin", "needsCodegenFromPackageJson", "model", "Lcom/facebook/react/model/ModelPackageJson;", "needsCodegenFromPackageJson$react_native_gradle_plugin", "rootProperty", "Lorg/gradle/api/file/DirectoryProperty;", "reactNativeDir$react_native_gradle_plugin", "shouldWarnIfNewArchFlagIsSetInPrealpha", "shouldWarnIfNewArchFlagIsSetInPrealpha$react_native_gradle_plugin", "react-native-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectUtils.kt\ncom/facebook/react/utils/ProjectUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n766#2:134\n857#2,2:135\n766#2:137\n857#2,2:138\n*S KotlinDebug\n*F\n+ 1 ProjectUtils.kt\ncom/facebook/react/utils/ProjectUtils\n*L\n75#1:134\n75#1:135,2\n78#1:137\n78#1:138,2\n*E\n"})
public final class ProjectUtils {
    @NotNull
    public static final ProjectUtils INSTANCE = new ProjectUtils();
    public static final boolean HERMES_FALLBACK = true;

    private ProjectUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNewArchEnabled$react_native_gradle_plugin(@NotNull Project $this$isNewArchEnabled, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$isNewArchEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if ($this$isNewArchEnabled.getProject().hasProperty("newArchEnabled")) {
            if (Boolean.parseBoolean(String.valueOf($this$isNewArchEnabled.getProject().property("newArchEnabled")))) return true;
        }
        if ($this$isNewArchEnabled.getProject().hasProperty("react.newArchEnabled")) {
            if (Boolean.parseBoolean(String.valueOf($this$isNewArchEnabled.getProject().property("react.newArchEnabled")))) return true;
        }
        Project project = $this$isNewArchEnabled.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!this.shouldEnableNewArchForReactNativeVersion$react_native_gradle_plugin(this.reactNativeDir$react_native_gradle_plugin(project, extension))) return false;
        return true;
    }

    public final boolean isHermesEnabled$react_native_gradle_plugin(@NotNull Project $this$isHermesEnabled) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isHermesEnabled, (String)"<this>");
        if ($this$isHermesEnabled.getProject().hasProperty("hermesEnabled") || $this$isHermesEnabled.getProject().hasProperty("react.hermesEnabled")) {
            String propertyString = $this$isHermesEnabled.getProject().hasProperty("hermesEnabled") ? "hermesEnabled" : "react.hermesEnabled";
            Boolean bl2 = KotlinStdlibCompatUtils.INSTANCE.toBooleanStrictOrNullCompat(KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat(String.valueOf($this$isHermesEnabled.getProject().property(propertyString))));
            bl = bl2 != null ? bl2 : true;
        } else if ($this$isHermesEnabled.getProject().getExtensions().getExtraProperties().has("react")) {
            Object enableHermesKey;
            Map reactMap;
            Object object = $this$isHermesEnabled.getProject().getExtensions().getExtraProperties().get("react");
            Map map = reactMap = object instanceof Map ? (Map)object : null;
            Object object2 = enableHermesKey = map != null ? map.get("enableHermes") : null;
            if (enableHermesKey instanceof Boolean) {
                bl = (Boolean)enableHermesKey;
            } else if (enableHermesKey instanceof String) {
                Boolean bl3 = KotlinStdlibCompatUtils.INSTANCE.toBooleanStrictOrNullCompat(KotlinStdlibCompatUtils.INSTANCE.lowercaseCompat((String)enableHermesKey));
                bl = bl3 != null ? bl3 : true;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean needsCodegenFromPackageJson$react_native_gradle_plugin(@NotNull Project $this$needsCodegenFromPackageJson, @NotNull DirectoryProperty rootProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$needsCodegenFromPackageJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootProperty, (String)"rootProperty");
        ModelPackageJson parsedPackageJson = PathUtils.readPackageJsonFile($this$needsCodegenFromPackageJson, rootProperty);
        return this.needsCodegenFromPackageJson$react_native_gradle_plugin($this$needsCodegenFromPackageJson, parsedPackageJson);
    }

    public final boolean needsCodegenFromPackageJson$react_native_gradle_plugin(@NotNull Project $this$needsCodegenFromPackageJson, @Nullable ModelPackageJson model) {
        Intrinsics.checkNotNullParameter((Object)$this$needsCodegenFromPackageJson, (String)"<this>");
        ModelPackageJson modelPackageJson = model;
        return (modelPackageJson != null ? modelPackageJson.getCodegenConfig() : null) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getReactNativeArchitectures$react_native_gradle_plugin(@NotNull Project $this$getReactNativeArchitectures) {
        Intrinsics.checkNotNullParameter((Object)$this$getReactNativeArchitectures, (String)"<this>");
        List architectures = new ArrayList();
        if ($this$getReactNativeArchitectures.getProject().hasProperty("reactNativeArchitectures")) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String architecturesString = String.valueOf($this$getReactNativeArchitectures.getProject().property("reactNativeArchitectures"));
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)architecturesString, (String[])object, (boolean)false, (int)0, (int)6, null);
            List list = architectures;
            boolean $i$f$filter = false;
            void var6_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        } else if ($this$getReactNativeArchitectures.getProject().hasProperty("react.nativeArchitectures")) {
            String architecturesString = String.valueOf($this$getReactNativeArchitectures.getProject().property("react.nativeArchitectures"));
            Object $this$filter$iv = new String[]{","};
            $this$filter$iv = StringsKt.split$default((CharSequence)architecturesString, (String[])$this$filter$iv, (boolean)false, (int)0, (int)6, null);
            List list = architectures;
            boolean $i$f$filter = false;
            Object $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
        }
        return architectures;
    }

    @NotNull
    public final String reactNativeDir$react_native_gradle_plugin(@NotNull Project $this$reactNativeDir, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$reactNativeDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = ((Directory)extension.getReactNativeDir().get()).getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    public final boolean shouldEnableNewArchForReactNativeVersion$react_native_gradle_plugin(@NotNull String reactNativeDir) {
        Intrinsics.checkNotNullParameter((Object)reactNativeDir, (String)"reactNativeDir");
        File packageJsonFile = new File(reactNativeDir, "package.json");
        if (!packageJsonFile.exists()) {
            return false;
        }
        ModelPackageJson rnPackageJson = JsonUtils.INSTANCE.fromPackageJson(packageJsonFile);
        if (rnPackageJson == null) {
            return false;
        }
        Regex regex = new Regex("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-(\\w+(?:[-.]\\d+)?))?$");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)rnPackageJson.getVersion(), (int)0, (int)2, null);
        if (matchResult == null) {
            return false;
        }
        String prerelease = ((String)matchResult.getGroupValues().get(4)).toString();
        return StringsKt.contains$default((CharSequence)prerelease, (CharSequence)"prealpha", (boolean)false, (int)2, null);
    }

    public final boolean shouldWarnIfNewArchFlagIsSetInPrealpha$react_native_gradle_plugin(@NotNull Project $this$shouldWarnIfNewArchFlagIsSetInPrealpha, @NotNull ReactExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldWarnIfNewArchFlagIsSetInPrealpha, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean propertySetToFalse = this.hasPropertySetToFalse$react_native_gradle_plugin($this$shouldWarnIfNewArchFlagIsSetInPrealpha, "newArchEnabled") || this.hasPropertySetToFalse$react_native_gradle_plugin($this$shouldWarnIfNewArchFlagIsSetInPrealpha, "react.newArchEnabled");
        boolean shouldEnableNewArch = this.shouldEnableNewArchForReactNativeVersion$react_native_gradle_plugin(this.reactNativeDir$react_native_gradle_plugin($this$shouldWarnIfNewArchFlagIsSetInPrealpha, extension));
        return shouldEnableNewArch && propertySetToFalse;
    }

    public final boolean hasPropertySetToFalse$react_native_gradle_plugin(@NotNull Project $this$hasPropertySetToFalse, @NotNull String property) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPropertySetToFalse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return $this$hasPropertySetToFalse.hasProperty(property) && !Boolean.parseBoolean(String.valueOf($this$hasPropertySetToFalse.property(property)));
    }
}

