/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter.message;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;

public class EMAVideoMessageBody extends EMAFileMessageBody {

	public EMAVideoMessageBody(String localPath, String thumbnailLocalPath) {
		super(localPath, EMAMessageBodyType_VIDEO);
		nativeInit(localPath, thumbnailLocalPath);
	}

	public EMAVideoMessageBody(EMAVideoMessageBody body) {
		super("", EMAMessageBodyType_VIDEO);
		nativeInit(body);
	}
	
	// used by jni_util.cpp: getJObject
	private EMAVideoMessageBody(){
		super("", EMAMessageBodyType_VIDEO);
		nativeInit("", "");
	}

	/**
	 * \brief Set local path of the thumbnail.
	 *
	 * @param  The local path.
	 * @return NA
	 */
	public void setThumbnailLocalPath(String path) {
		nativesetThumbnailLocalPath(path);
	}
	native void nativesetThumbnailLocalPath(String path);

	/**
	 * \brief Get local path of the thumbnail.
	 *
	 * @param  NA
	 * @return The local path.
	 */
	public String thumbnailLocalPath() {
		return nativethumbnailLocalPath();
	}
	native String nativethumbnailLocalPath();

	/**
	 * \brief Set remote path of the thumbnail.
	 *
	 * Note: It's internal used, user should never need to call this method.
	 * @param  The remote path.
	 * @return NA
	 */
	public void setThumbnailRemotePath(String path) {
		nativesetThumbnailRemotePath(path);
	}
	native void nativesetThumbnailRemotePath(String path);

	/**
	 * \brief Get remote path of the thumbnail.
	 *
	 * @param  NA
	 * @return The remote path.
	 */
	public String thumbnailRemotePath() {
		return nativethumbnailRemotePath();
	}
	native String nativethumbnailRemotePath();

	/**
	 * \brief Set secret key of the thumbnail.
	 *
	 * Note: It's internal used, user should never need to call this method.
	 * @param  The secret key.
	 * @return NA
	 */
	public void setThumbnailSecretKey(String secretkey) {
		nativesetThumbnailSecretKey(secretkey);
	}
	native void nativesetThumbnailSecretKey(String secretkey);

	/**
	 * \brief Get secret key of the thumbnail.
	 *
	 * @param  NA
	 * @return The secret key.
	 */
	public String thumbnailSecretKey() {
		return nativethumbnailSecretKey();
	}
	native String nativethumbnailSecretKey();

	/**
	 * \brief Set download status of the thumbnail.
	 *
	 * Note: Usually, user should NOT call this method directly.
	 * @param  The download status.
	 * @return NA
	 */
	public void setThumbnailDownloadStatus(EMADownloadStatus status) {
		int s = status.ordinal();
		nativesetThumbnailDownloadStatus(s);
	}
	native void nativesetThumbnailDownloadStatus(int status);

	/**
	 * \brief Get download status of the thumbnail.
	 *
	 * @param  NA
	 * @return The download status.
	 */
	public EMADownloadStatus thumbnailDownloadStatus() {
        int s = nativethumbnailDownloadStatus();
        
        if (s == EMADownloadStatus.DOWNLOADING.ordinal()) {
            return EMADownloadStatus.DOWNLOADING;
        } else if (s == EMADownloadStatus.SUCCESSED.ordinal()) {
            return EMADownloadStatus.SUCCESSED;
        } else if (s == EMADownloadStatus.FAILED.ordinal()) {
            return EMADownloadStatus.FAILED;
        } else {
            return EMADownloadStatus.PENDING;
        }
	}
	native int nativethumbnailDownloadStatus();


	/**
	 * \brief Get playing duration of the video.
	 *
	 * @param  NA
	 * @return The video playing duration.
	 */
	public int duration() {
		return nativeduration();
	}
	native int nativeduration();

	/**
	 * \brief Set playing duration of the video.
	 *
	 * @param  The video's playing duration.
	 * @return NA
	 */
	public void setDuration(int duration) {
		nativesetDuration(duration);
	}
	native void nativesetDuration(int duration);



	/**
	 * \brief Set size of the image.
	 *
	 * @param  The image's width.
	 * @param  The image's height.
	 * @return NA
	 */
	public void setSize(int width, int height) {
		nativesetSize(width, height);
	}
	native void nativesetSize(int width, int height);


	/**
	 * \brief Get width of the image.
	 *
	 * @param  NA
	 * @return The image width.
	 */
	public int width() {
		return nativewidth();
	}
	native int nativewidth();

	/**
	 * \brief Get height of the image.
	 *
	 * @param  NA
	 * @return The image height.
	 */
	public int height() {
		return nativeheight();
	}
	native int nativeheight();
	
	
	
	
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(String localPath, String thumbnailLocalPath);
	native void nativeInit(EMAVideoMessageBody body);
	native void nativeFinalize();

}
