/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.monitor;

import com.hyphenate.util.EMLog;

import android.annotation.SuppressLint;
import android.net.TrafficStats;
import android.os.Process;

/**
 * network traffic monitor, which calculate the traffic statics for the application
 * @todo, to able to monitor network traffic for hyphenate sdk threads only
 * change to use hearttimer to call the network monitor
 * @author xiaoma
 *
 */
@SuppressLint("NewApi")
public class EMNetworkMonitor {
    static final String TAG = "net";
    protected static EMNetworkMonitor instance = null;
    
    
    static long initRecvBytes = 0;
    static long initSentBytes = 0;
    static long initRecvPackets = 0;
    static long initSentPackets = 0;
    
    static long appRecvBytes = 0;
    static long appSentBytes = 0;
    static long appRecvPackets = 0;
    static long appSentPackets = 0;
    
    static long cycleRecvBytes;
    static long cycleSentBytes;
    static long cycleRecvPackets = 0;
    static long cycleSentPackets = 0;
    
    static long curRecvBytes = 0;
    static long curSentBytes = 0;
    static long curRecvPackets = 0;
    static long curSentPackets = 0;
    
    static int uid;
    static long previousTime = 0;
    static long appStartTime = 0;
    
    static boolean isCollecting = false;
    
    public static void startTrafficStat() {
    	uid = Process.myUid();
    	resetCount();
    	isCollecting = true;
    }
    
    public static void resetCount() {
    	initRecvBytes = TrafficStats.getUidRxBytes(uid);
        initSentBytes = TrafficStats.getUidTxBytes(uid);
        if (android.os.Build.VERSION.SDK_INT >= 12) {
            initRecvPackets = TrafficStats.getUidRxPackets(uid);
            initSentPackets = TrafficStats.getUidTxPackets(uid);
        } else {
        	initRecvPackets = 0;
            initSentPackets = 0;
        }
        
        cycleRecvBytes = 0;
        cycleSentBytes = 0;
        cycleRecvPackets = 0;
        cycleSentPackets = 0;
        
        curRecvBytes = 0;
        curSentBytes = 0;
        curRecvPackets = 0;
        curSentPackets = 0;
        
        appStartTime = System.currentTimeMillis();
        previousTime = System.currentTimeMillis();
    }
    
    public static void stopTrafficStat() {
    	isCollecting = false;
        resetCount();    
    }
    
	public static void collectTrafficStats() {
        if (!isCollecting) {
        	return;
        }
		
		Long currentTime = System.currentTimeMillis();
		long seconds = (currentTime - previousTime) / 1000;
		if (seconds == 0) {
			seconds = 1;
		}

		curRecvBytes = TrafficStats.getUidRxBytes(uid);
		curSentBytes = TrafficStats.getUidTxBytes(uid);
		cycleRecvBytes = curRecvBytes - initRecvBytes;
		cycleSentBytes = curSentBytes - initSentBytes;
		appRecvBytes += cycleRecvBytes;
		appSentBytes += cycleSentBytes;

		if (android.os.Build.VERSION.SDK_INT >= 12) {
			curRecvPackets = TrafficStats.getUidRxPackets(uid);
			curSentPackets = TrafficStats.getUidTxPackets(uid);
			cycleRecvPackets = curRecvPackets - initRecvPackets;
			cycleSentPackets = curSentPackets - initSentPackets;
			appRecvPackets += cycleRecvPackets;
			appSentPackets += cycleSentPackets;
		}

		if (cycleRecvBytes != 0 || cycleSentBytes != 0) {
			EMLog.d(TAG, cycleSentBytes + " bytes send; " + cycleRecvBytes
					+ " bytes received in " + seconds + " sec");
			if (android.os.Build.VERSION.SDK_INT >= 12 && cycleSentPackets > 0) {
				EMLog.d(TAG, cycleSentPackets + " packets send; "
						+ cycleRecvPackets + " packets received in " + seconds
						+ " sec");
			}

			EMLog.d(TAG, "total:" + appSentBytes + " bytes send; "
					+ appRecvBytes + " bytes received");
			if (android.os.Build.VERSION.SDK_INT >= 12 && appSentPackets > 0) {
				long appSeconds = (System.currentTimeMillis() - appStartTime)/1000;
				EMLog.d(TAG, "total:" + appSentPackets + " packets send; "
						+ appRecvPackets + " packets received in " + appSeconds);
			}

			initRecvBytes = curRecvBytes;
			initSentBytes = curSentBytes;
			initRecvPackets = curRecvPackets;
			initSentPackets = curSentPackets;

			previousTime = currentTime;
		} else {
			EMLog.d(TAG, "no network traffice");
		}
	}
    
}
