/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.exceptions;

import com.hyphenate.chat.adapter.EMAError;

public class HyphenateException extends Exception {

	protected int errorCode = -1;
	protected String desc = "";
	
    /** Default for non-checking. */
    private static final long serialVersionUID = 1L;
   
    public HyphenateException() {
        super();
    }
    
    /**
     * Constructs an exception with the given description.
     * @param desc the exception's description. 
     */
    public HyphenateException(String desc) {
        super(desc);
    }
    
    public HyphenateException(EMAError error) {
    	super(error.errMsg());
    	errorCode = error.errCode();
        desc = error.errMsg();
    }
    
    /**
     * Constructs an exception with the given description.
     * @param desc the exception's description. 
     * @param cause the exception's cause.
     */
    public HyphenateException(String desc, Throwable cause) {
        super(desc);
        super.initCause(cause);
    }

    public HyphenateException(int errorCode, String desc){
    	 super(desc);
    	 this.errorCode = errorCode;
    	 this.desc = desc;
    }
    
	public int getErrorCode() {
		return errorCode;
	}
	
	public String getDescription() {
	    return this.desc;
	}

	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}
    
    
}
