/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * 
 * @author youni
 * The utils for zip files
 */
public class ZipUtils {
    private static final int BUFF_SIZE = 1024 * 1024; // 1M Byte

    /**
     * 
     * @param folder file or folder
     * @param zipFile the oupput zip file
     * @throws IOException
     */
    public static void zip(File folder, File zipFile) throws IOException{
    	if(!folder.exists())
    		return;

    	ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), BUFF_SIZE));
    	
    	zipFiles(folder,zipOut,"");
    	zipOut.flush();
        zipOut.close();
    	
    }

    /**
     * 
     * @param srcFileList The files to be zipped
     * @param zipFile     The zip file to be produced
     * @throws IOException
     */
    static void zipFiles(File file, ZipOutputStream zipOut, String dir) throws IOException{
        
    	if(!file.exists())
    		return;
    	
    	if(file.isDirectory()){
    		File files[] = file.listFiles();
    		if(files != null){
    			for(File f:files){
        			zipFiles(f,zipOut,dir+"\\"+f.getName());
        		}
    		}
    	} else {
    		zipFile(file,zipOut,dir);
    	}
    }

    static void zipFile(final File srcFile, ZipOutputStream zipOut, String dir) throws IOException{
        byte buffer[] = new byte[BUFF_SIZE];
        BufferedInputStream in = null;

        try {
            in = new BufferedInputStream(new FileInputStream(srcFile), BUFF_SIZE);

            String entryName = null;

            if ("".equals(dir)) {
                entryName = srcFile.getName();
            } else {
                entryName = dir + "\\" + srcFile.getName();
            }
            zipOut.putNextEntry(new ZipEntry(dir));

            int len;
            while ((len = in.read(buffer)) != -1) {
                zipOut.write(buffer, 0, len);
            }
            zipOut.flush();
            zipOut.closeEntry();
        } catch (Exception e) {
            throw e;
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (Exception e) {

                }
            }
        }
    } 
}
