/*
 * Decompiled with CFR 0.152.
 */
package io.idml.datanodes.modules;

import io.idml.BadDateFormat$;
import io.idml.CastFailed$;
import io.idml.CastUnsupported$;
import io.idml.IdmlInt;
import io.idml.IdmlString;
import io.idml.IdmlValue;
import io.idml.datanodes.IDate;
import io.idml.datanodes.IDate$;
import io.idml.datanodes.IDateFormats$;
import java.io.Serializable;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DateModule$ {
    public static final DateModule$ MODULE$ = new DateModule$();
    private static final DateTimeFormatter DefaultDateFormat;

    static {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        DefaultDateFormat = IDateFormats$.MODULE$.RFC822Printer();
    }

    public DateTimeFormatter DefaultDateFormat() {
        return DefaultDateFormat;
    }

    public IdmlValue millisToDate(IdmlValue n, Object pfmt) {
        IdmlValue idmlValue;
        Object object = pfmt;
        if (object instanceof IdmlString) {
            IdmlValue idmlValue2;
            IdmlString idmlString = (IdmlString)object;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> DateTimeFormat.forPattern((String)idmlString.value()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                DateTimeFormatter fmt = (DateTimeFormatter)success.value();
                idmlValue2 = this.millisToDateFMT(n, fmt);
            } else {
                idmlValue2 = BadDateFormat$.MODULE$;
            }
            idmlValue = idmlValue2;
        } else if (object instanceof DateTimeFormatter) {
            DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)object;
            idmlValue = this.millisToDateFMT(n, dateTimeFormatter);
        } else {
            idmlValue = CastUnsupported$.MODULE$;
        }
        return idmlValue;
    }

    public Object millisToDate$default$2() {
        return this.DefaultDateFormat();
    }

    private IdmlValue millisToDateFMT(IdmlValue n, DateTimeFormatter fmt) {
        IdmlValue idmlValue;
        IdmlValue idmlValue2 = n;
        if (idmlValue2 instanceof IdmlInt) {
            IdmlInt idmlInt = (IdmlInt)((Object)idmlValue2);
            idmlValue = new IDate(new DateTime(idmlInt.value()), fmt);
        } else if (idmlValue2 instanceof IdmlString) {
            IdmlValue idmlValue3;
            IdmlString idmlString = (IdmlString)((Object)idmlValue2);
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new IDate(new DateTime(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(idmlString.value()))), fmt));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                IDate date = (IDate)success.value();
                idmlValue3 = date;
            } else if (try_ instanceof Failure) {
                idmlValue3 = CastUnsupported$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            idmlValue = idmlValue3;
        } else {
            idmlValue = CastUnsupported$.MODULE$;
        }
        return idmlValue;
    }

    public IdmlValue applyTimezone(IDate supplied, String tzStr) {
        IdmlValue idmlValue;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> IDateFormats$.MODULE$.TimezoneFormatter().withOffsetParsed().parseDateTime(tzStr));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DateTime tz = (DateTime)success.value();
            idmlValue = new IDate(supplied.dateVal().withZone(tz.getZone()), IDate$.MODULE$.apply$default$2());
        } else if (try_ instanceof Failure) {
            IdmlValue idmlValue2;
            Success success;
            TimeZone tz;
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> TimeZone.getTimeZone(tzStr));
            if (try_2 instanceof Success && (tz = (TimeZone)(success = (Success)try_2).value()) != null) {
                TimeZone timeZone = tz;
                idmlValue2 = new IDate(supplied.dateVal().withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)), IDate$.MODULE$.apply$default$2());
            } else if (try_2 instanceof Failure) {
                idmlValue2 = CastFailed$.MODULE$;
            } else {
                throw new MatchError((Object)try_2);
            }
            idmlValue = idmlValue2;
        } else {
            throw new MatchError((Object)try_);
        }
        return idmlValue;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public IdmlValue stringToDate(String str, DateTimeFormatter df) {
        void var3_10;
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> df.parseDateTime(str));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DateTime date = (DateTime)success.value();
            IDate iDate = new IDate(date, IDate$.MODULE$.$lessinit$greater$default$2());
            return var3_10;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable x = failure.exception();
            if (x instanceof IllegalArgumentException) {
                CastFailed$ castFailed$ = CastFailed$.MODULE$;
                return var3_10;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        throw e;
    }

    public IdmlValue stringToDate(String str) {
        IdmlValue idmlValue;
        Object object = new Object();
        try {
            IDateFormats$.MODULE$.Formatters().foreach((Function1 & Serializable)df -> {
                DateModule$.$anonfun$stringToDate$2(str, object, df);
                return BoxedUnit.UNIT;
            });
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new DateTime((Object)str));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                DateTime date = (DateTime)success.value();
                return new IDate(date, IDate$.MODULE$.$lessinit$greater$default$2());
            }
            if (!(try_ instanceof Failure)) {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            idmlValue = CastFailed$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                idmlValue = (IdmlValue)ex.value();
            }
            throw ex;
        }
        return idmlValue;
    }

    public IdmlValue timestampToDate(long num) {
        return num > 0L && num < Integer.MAX_VALUE ? new IDate(new DateTime(num * 1000L), IDate$.MODULE$.$lessinit$greater$default$2()) : CastFailed$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$stringToDate$2(String str$2, Object nonLocalReturnKey1$1, DateTimeFormatter df) {
        block6: {
            Try try_;
            Failure failure;
            boolean bl;
            block5: {
                bl = false;
                failure = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> df.withOffsetParsed().parseDateTime(str$2));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    DateTime date = (DateTime)success.value();
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new IDate(date, IDate$.MODULE$.$lessinit$greater$default$2()));
                }
                if (!(try_ instanceof Failure)) break block5;
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (e instanceof IllegalArgumentException) break block6;
            }
            if (bl) {
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DateModule$() {
    }
}

