/*
 * Decompiled with CFR 0.152.
 */
package io.idml.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class IdmlUUID {
    public static UUID nameUUIDFromBytes5(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("SHA-1 not supported", noSuchAlgorithmException);
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x50);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return IdmlUUID.create(byArray2);
    }

    public static UUID create(byte[] byArray) {
        int n;
        long l = 0L;
        long l2 = 0L;
        assert (byArray.length == 16) : "data must be 16 bytes in length";
        for (n = 0; n < 8; ++n) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
        }
        for (n = 8; n < 16; ++n) {
            l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
        }
        return new UUID(l, l2);
    }
}

