package io.imast.work4j.worker;

/**
 * The definitions of job management constants
 * 
 * @author davitp
 */
public class JobConstants {
   
    /**
     * The default cluster name
     */
    public static final String DEFAULT_CLUSTER = "DEFAULT_CLUSTER";
    
    /**
     * The job session context
     */
    public static final String JOB_SESSION_CONTEXT = "SESSION";
    
    /**
     * The job definition
     */
    public static final String JOB_DEFINITION = "DEFINITION";
    
    /**
     * The job id key
     */
    public static final String PAYLOAD_JOB_ID = "_PLD_JOB_ID";
    
    /**
     * The job code key
     */
    public static final String PAYLOAD_JOB_CODE = "_PLD_JOB_CODE";
    
    /**
     * The job group key
     */
    public static final String PAYLOAD_JOB_GROUP = "_PLD_JOB_GROUP";
    
    /**
     * The job type key
     */
    public static final String PAYLOAD_JOB_TYPE = "_PLD_JOB_TYPE";
    
    /**
     * The job tenant key
     */
    public static final String PAYLOAD_JOB_TENANT = "_PLD_JOB_TENANT";
    
    /**
     * The job status key
     */
    public static final String PAYLOAD_JOB_STATUS = "_PLD_JOB_STATUS";
    
    /**
     * The job cluster key
     */
    public static final String PAYLOAD_JOB_CLUSTER = "_PLD_JOB_CLUSTER";
    
    /**
     * The job execution key
     */
    public static final String PAYLOAD_JOB_EXECUTION = "_PLD_JOB_EXECUTION";
    
    /**
     * The job created key
     */
    public static final String PAYLOAD_JOB_CREATED = "_PLD_JOB_CREATED";
    
    /**
     * The job modified key
     */
    public static final String PAYLOAD_JOB_MODIFIED = "_PLD_JOB_MODIFIED";
    
    /**
     * The job modules
     */
    public static final String JOB_MODULES = "JOB_MODULES";
    
    /**
     * The job factory
     */
    public static final String WORKER_FACTORY = "WORKER_FACTORY";
    
    /**
     * The unknown job type constant
     */
    public static final String UNKNOWN_JOB_TYPE = "__UNKNOWN_JOB";
    
    /**
     * The dry run job type constant
     */
    public static final String DRY_RUN_JOB_TYPE = "__DRY_RUN_JOB";
}
