/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.composite.password;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.authn.CredentialDefinition;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.exceptions.WrongArgumentException;
import pl.edu.icm.unity.base.identity.IllegalIdentityValueException;
import pl.edu.icm.unity.base.json.JsonUtil;
import pl.edu.icm.unity.composite.password.CompositePasswordHelper;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.TooManyAttempts;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.identity.IdentityResolver;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredential;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredentialResetSettings;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEngine;

public class CompositePasswordResetImpl
implements CredentialReset {
    private PasswordCredentialResetImpl resetBackend;
    private final CredentialHelper credentialHelper;
    private final List<LocalCredentialVerificator> localVerificators;
    private final IdentityResolver identityResolver;
    private final NotificationProducer notificationProducer;
    private final PasswordEngine passwordEngine;

    public CompositePasswordResetImpl(CredentialHelper credentialHelper, List<LocalCredentialVerificator> localVerificators, IdentityResolver identityResolver, NotificationProducer notificationProducer, PasswordEngine passwordEngine) {
        this.credentialHelper = credentialHelper;
        this.localVerificators = localVerificators;
        this.identityResolver = identityResolver;
        this.notificationProducer = notificationProducer;
        this.passwordEngine = passwordEngine;
    }

    public String getSettings() {
        if (this.resetBackend == null) {
            PasswordCredentialResetSettings settings = new PasswordCredentialResetSettings();
            settings.setRequireSecurityQuestion(true);
            settings.setQuestions(Arrays.asList(""));
            settings.setEnabled(true);
            ObjectNode node = Constants.MAPPER.createObjectNode();
            settings.serializeTo(node);
            return JsonUtil.toJsonString((Object)node);
        }
        return this.resetBackend.getSettings();
    }

    public void setSubject(AuthenticationSubject subject) {
        Optional<EntityWithCredential> resolvedEntity = CompositePasswordHelper.getLocalEntity(this.identityResolver, subject);
        if (resolvedEntity.isPresent()) {
            for (LocalCredentialVerificator localVerificator : this.localVerificators) {
                boolean isCredSet = CompositePasswordHelper.checkIfUserHasCredential(localVerificator, resolvedEntity.get().getEntityId());
                if (!isCredSet) continue;
                this.resetBackend = this.getResetBackend(localVerificator);
            }
            if (this.resetBackend == null) {
                LocalCredentialVerificator firstVerificator = this.localVerificators.iterator().next();
                this.resetBackend = this.getResetBackend(firstVerificator);
            }
        } else {
            LocalCredentialVerificator firstVerificator = this.localVerificators.iterator().next();
            this.resetBackend = this.getResetBackend(firstVerificator);
        }
        this.resetBackend.setSubject(subject);
    }

    private PasswordCredentialResetImpl getResetBackend(LocalCredentialVerificator verificator) {
        Optional<CredentialDefinition> credDef = CompositePasswordHelper.getCredentialDefinition(this.credentialHelper, verificator.getCredentialName());
        if (!credDef.isPresent()) {
            throw new InternalException("Invalid configuration of the verificator, local credential " + verificator.getCredentialName() + " is undefined");
        }
        PasswordCredential passwordCredential = new PasswordCredential();
        passwordCredential.setSerializedConfiguration(JsonUtil.parse((String)credDef.get().getConfiguration()));
        return new PasswordCredentialResetImpl(this.notificationProducer, this.identityResolver, verificator, this.credentialHelper, verificator.getCredentialName(), passwordCredential.getSerializedConfiguration(), passwordCredential.getPasswordResetSettings(), this.passwordEngine);
    }

    public String getSecurityQuestion() {
        return this.resetBackend.getSecurityQuestion();
    }

    public void verifyStaticData(String answer) throws WrongArgumentException, IllegalIdentityValueException, TooManyAttempts {
        this.resetBackend.verifyStaticData(answer);
    }

    public void verifyDynamicData(String emailCode) throws WrongArgumentException, TooManyAttempts {
        this.resetBackend.verifyDynamicData(emailCode);
    }

    public void sendCode(String messageTemplateId, boolean onlyNumberCode) throws EngineException {
        this.resetBackend.sendCode(messageTemplateId, onlyNumberCode);
    }

    public String getCredentialConfiguration() {
        return this.resetBackend.getCredentialConfiguration();
    }

    public void updateCredential(String newCredential) throws EngineException {
        this.resetBackend.updateCredential(newCredential);
    }

    public Long getEntityId() {
        return this.resetBackend.getEntityId();
    }
}

