/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.composite.password;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.authn.CredentialDefinition;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.json.JsonUtil;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.composite.password.CompositePasswordHelper;
import pl.edu.icm.unity.composite.password.CompositePasswordProperties;
import pl.edu.icm.unity.composite.password.CompositePasswordResetImpl;
import pl.edu.icm.unity.engine.api.authn.AbstractCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.AbstractVerificator;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.AuthenticationSubject;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.CredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.CredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.EntityWithCredential;
import pl.edu.icm.unity.engine.api.authn.LocalAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.local.CredentialHelper;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.local.LocalCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.remote.AuthenticationTriggeringContext;
import pl.edu.icm.unity.engine.api.notification.NotificationProducer;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.ldap.client.LdapPasswordVerificator;
import pl.edu.icm.unity.pam.PAMVerificator;
import pl.edu.icm.unity.stdext.credential.NoCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.pass.PasswordCredential;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEncodingPoolProvider;
import pl.edu.icm.unity.stdext.credential.pass.PasswordEngine;
import pl.edu.icm.unity.stdext.credential.pass.PasswordExchange;
import pl.edu.icm.unity.stdext.credential.pass.PasswordVerificator;

@PrototypeComponent
public class CompositePasswordVerificator
extends AbstractVerificator
implements PasswordExchange {
    private static final Logger log = Log.getLogger((String)"unity.server.authn", CompositePasswordVerificator.class);
    public static final String NAME = "composite-password";
    public static final String DESC = "Verifies local or remote password";
    private Map<String, CredentialVerificatorFactory> credentialVerificatorFactories;
    private CredentialHelper credentialHelper;
    private List<LocalCredentialVerificator> localVerificators;
    private List<CredentialVerificator> remoteVerificators;
    private CompositePasswordProperties compositePasswordProperties;
    private NotificationProducer notificationProducer;
    private PasswordEngine passwordEngine;

    @Autowired
    public CompositePasswordVerificator(PasswordVerificator.Factory passwordVerificator, PAMVerificator.Factory pamVerificator, LdapPasswordVerificator.Factory ldapVerificator, CredentialHelper credentialHelper, NotificationProducer notificationProducer, Optional<PasswordEncodingPoolProvider> threadPoolProvider) {
        super(NAME, DESC, "password exchange");
        this.credentialHelper = credentialHelper;
        this.notificationProducer = notificationProducer;
        this.credentialVerificatorFactories = new HashMap<String, CredentialVerificatorFactory>();
        this.credentialVerificatorFactories.put("password", (CredentialVerificatorFactory)passwordVerificator);
        this.credentialVerificatorFactories.put("pam", (CredentialVerificatorFactory)pamVerificator);
        this.credentialVerificatorFactories.put("ldap", (CredentialVerificatorFactory)ldapVerificator);
        this.localVerificators = new ArrayList<LocalCredentialVerificator>();
        this.remoteVerificators = new ArrayList<CredentialVerificator>();
        this.passwordEngine = new PasswordEngine(threadPoolProvider.map(pp -> pp.pool).orElse(ForkJoinPool.commonPool()));
    }

    public String getSerializedConfiguration() {
        StringWriter sbw = new StringWriter();
        try {
            this.compositePasswordProperties.getProperties().store(sbw, "");
        }
        catch (IOException e) {
            throw new InternalException("Can't serialize composite-password verificator configuration", (Throwable)e);
        }
        return sbw.toString();
    }

    private LocalCredentialVerificator getLocalVerificator(CredentialVerificator verificator, String credential) {
        Optional<CredentialDefinition> credDef = CompositePasswordHelper.getCredentialDefinition(this.credentialHelper, credential);
        if (!credDef.isPresent()) {
            throw new InternalException("Invalid configuration of the verificator, local credential " + credential + " is undefined");
        }
        verificator.setSerializedConfiguration(credDef.get().getConfiguration());
        verificator.setIdentityResolver(this.identityResolver);
        LocalCredentialVerificator localVerificator = (LocalCredentialVerificator)verificator;
        localVerificator.setCredentialName(credential);
        return localVerificator;
    }

    public void setSerializedConfiguration(String config) {
        this.localVerificators.clear();
        this.remoteVerificators.clear();
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(config));
        }
        catch (IOException e) {
            throw new InternalException("Invalid configuration of the composite-password verificator", (Throwable)e);
        }
        this.compositePasswordProperties = new CompositePasswordProperties(properties);
        Set verificatorList = this.compositePasswordProperties.getStructuredListKeys("verificators.");
        for (String verificatorKey : verificatorList) {
            String type = this.compositePasswordProperties.getValue(verificatorKey + "verificatorType");
            CredentialVerificatorFactory credentialVerificatorFactory = this.credentialVerificatorFactories.get(type);
            CredentialVerificator verificator = credentialVerificatorFactory.newInstance();
            verificator.setIdentityResolver(this.identityResolver);
            verificator.setInstanceName(NAME);
            if (credentialVerificatorFactory instanceof LocalCredentialVerificatorFactory) {
                String credential = this.compositePasswordProperties.getValue(verificatorKey + "verificatorCredential");
                this.localVerificators.add(this.getLocalVerificator(verificator, credential));
                continue;
            }
            verificator.setSerializedConfiguration(this.getRemoteAuthenticatorConfig(verificatorKey));
            this.remoteVerificators.add(verificator);
        }
    }

    private String getRemoteAuthenticatorConfig(String verificatorKey) {
        if (!this.compositePasswordProperties.isSet(verificatorKey + "verificatorConfigEmbedded") && !this.compositePasswordProperties.isSet(verificatorKey + "verificatorConfig")) {
            throw new InternalException("Misconfigured composite-password verificator, remote verificator has no defined configuration");
        }
        if (!this.compositePasswordProperties.isSet(verificatorKey + "verificatorConfig")) {
            return this.compositePasswordProperties.getValue(verificatorKey + "verificatorConfigEmbedded");
        }
        try {
            return FileUtils.readFileToString((File)this.compositePasswordProperties.getFileValue(verificatorKey + "verificatorConfig", false), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new InternalException("Misconfigured composite-password verificator composite-password, remote verificator config file is not available", (Throwable)e);
        }
    }

    public AuthenticationResult checkPassword(String username, String password, String formForUnknown, boolean enableAssociation, AuthenticationTriggeringContext triggeringContext) throws AuthenticationException {
        Optional<EntityWithCredential> resolveIdentity = CompositePasswordHelper.getLocalEntity(this.identityResolver, AuthenticationSubject.identityBased((String)username));
        if (resolveIdentity.isPresent()) {
            for (LocalCredentialVerificator localVerificator : this.localVerificators) {
                boolean isCredSet = CompositePasswordHelper.checkIfUserHasCredential(localVerificator, resolveIdentity.get().getEntityId());
                if (!isCredSet) continue;
                log.debug("Checking >{}< password using verificator with local credential >{}<", (Object)username, (Object)localVerificator.getCredentialName());
                PasswordExchange passExchange = (PasswordExchange)localVerificator;
                return passExchange.checkPassword(username, password, formForUnknown, enableAssociation, triggeringContext);
            }
        }
        for (CredentialVerificator remoteVerificator : this.remoteVerificators) {
            log.debug("Checking >{}< password using remote verificator >{}<", (Object)username, (Object)remoteVerificator.getName());
            PasswordExchange passExchange = (PasswordExchange)remoteVerificator;
            AuthenticationResult result = passExchange.checkPassword(username, password, formForUnknown, enableAssociation, triggeringContext);
            if (result.getStatus().equals((Object)AuthenticationResult.Status.deny) || result.getStatus().equals((Object)AuthenticationResult.Status.notApplicable)) continue;
            return result;
        }
        log.info("Password provided by {} is invalid", (Object)username);
        return LocalAuthenticationResult.failed((AuthenticationResult.ResolvableError)new AuthenticationResult.ResolvableError("WebPasswordRetrieval.wrongPassword", new Object[0]));
    }

    private List<LocalCredentialVerificator> getVerificatorsWithCredentialResetSupport() {
        ArrayList<LocalCredentialVerificator> ret = new ArrayList<LocalCredentialVerificator>();
        for (LocalCredentialVerificator localVerificator : this.localVerificators) {
            Optional<CredentialDefinition> credDef = CompositePasswordHelper.getCredentialDefinition(this.credentialHelper, localVerificator.getCredentialName());
            if (!credDef.isPresent()) continue;
            PasswordCredential passCred = new PasswordCredential();
            passCred.setSerializedConfiguration(JsonUtil.parse((String)credDef.get().getConfiguration()));
            if (!passCred.getPasswordResetSettings().isEnabled()) continue;
            ret.add(localVerificator);
        }
        return ret;
    }

    public CredentialReset getCredentialResetBackend() {
        List<LocalCredentialVerificator> localVerificatorWithReset = this.getVerificatorsWithCredentialResetSupport();
        if (localVerificatorWithReset.isEmpty()) {
            return new NoCredentialResetImpl();
        }
        return new CompositePasswordResetImpl(this.credentialHelper, localVerificatorWithReset, this.identityResolver, this.notificationProducer, this.passwordEngine);
    }

    public CredentialVerificator.VerificatorType getType() {
        return CredentialVerificator.VerificatorType.Mixed;
    }

    @Component
    public static class Factory
    extends AbstractCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<CompositePasswordVerificator> factory) {
            super(CompositePasswordVerificator.NAME, CompositePasswordVerificator.DESC, factory);
        }
    }
}

