/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.composite.password.web;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.accordion.AccordionPanel;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.ValueProvider;
import eu.unicore.util.configuration.ConfigurationException;
import io.imunity.vaadin.auth.authenticators.AuthenticatorEditor;
import io.imunity.vaadin.auth.authenticators.AuthenticatorEditorFactory;
import io.imunity.vaadin.auth.authenticators.BaseAuthenticatorEditor;
import io.imunity.vaadin.auth.extensions.PasswordRetrievalProperties;
import io.imunity.vaadin.elements.CSSVars;
import io.imunity.vaadin.elements.CssClassNames;
import io.imunity.vaadin.elements.LocalizedTextFieldDetails;
import io.imunity.vaadin.elements.NotificationPresenter;
import io.imunity.vaadin.elements.grid.GridWithActionColumn;
import io.imunity.vaadin.elements.grid.SingleActionHandler;
import io.imunity.vaadin.endpoint.common.api.SubViewSwitcher;
import io.imunity.vaadin.endpoint.common.api.UnitySubView;
import io.imunity.vaadin.endpoint.common.exceptions.FormValidationException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import pl.edu.icm.unity.base.authn.CredentialDefinition;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.i18n.I18nString;
import pl.edu.icm.unity.base.message.MessageSource;
import pl.edu.icm.unity.composite.password.CompositePasswordProperties;
import pl.edu.icm.unity.composite.password.web.EditRemoteAuthenticatorSubView;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorDefinition;
import pl.edu.icm.unity.ldap.client.console.LdapAuthenticatorEditorFactory;
import pl.edu.icm.unity.pam.web.PamAuthenticatorEditorFactory;

class CompositePasswordAuthenticatorEditor
extends BaseAuthenticatorEditor
implements AuthenticatorEditor {
    private final MessageSource msg;
    private final Collection<CredentialDefinition> credentialDefinitions;
    private final PamAuthenticatorEditorFactory pamFactory;
    private final LdapAuthenticatorEditorFactory ldapFactory;
    private final NotificationPresenter notificationPresenter;
    private Binder<CompositePasswordConfiguration> configBinder;
    private SubViewSwitcher subViewSwitcher;

    CompositePasswordAuthenticatorEditor(MessageSource msg, Collection<CredentialDefinition> credentialDefinitions, PamAuthenticatorEditorFactory pamFactory, LdapAuthenticatorEditorFactory ldapFactory, NotificationPresenter notificationPresenter) {
        super(msg);
        this.msg = msg;
        this.credentialDefinitions = credentialDefinitions;
        this.pamFactory = pamFactory;
        this.ldapFactory = ldapFactory;
        this.notificationPresenter = notificationPresenter;
    }

    public Component getEditor(AuthenticatorDefinition toEdit, SubViewSwitcher switcher, boolean forceNameEditable) {
        this.subViewSwitcher = switcher;
        boolean editMode = this.init(this.msg.getMessage("CompositePasswordAuthenticatorEditor.defaultName", new Object[0]), toEdit, forceNameEditable);
        this.configBinder = new Binder(CompositePasswordConfiguration.class);
        MultiSelectComboBox localCredentials = new MultiSelectComboBox();
        localCredentials.setItems((Collection)this.credentialDefinitions.stream().filter(c -> c.getTypeId().equals("password")).map(CredentialDefinition::getName).collect(Collectors.toList()));
        localCredentials.setWidth(CSSVars.TEXT_FIELD_MEDIUM.value());
        this.configBinder.forField((HasValue)localCredentials).withConverter(List::copyOf, HashSet::new).bind(CompositePasswordConfiguration::getLocalCredentials, CompositePasswordConfiguration::setLocalCredentials);
        RemoteAuthenticatorsComponent remoteAuthn = new RemoteAuthenticatorsComponent();
        this.configBinder.forField((HasValue)remoteAuthn).bind(CompositePasswordConfiguration::getRemoteAuthenticators, CompositePasswordConfiguration::setRemoteAuthenticators);
        AccordionPanel interactiveLoginSettings = this.buildInteractiveLoginSettingsSection();
        interactiveLoginSettings.setWidthFull();
        CompositePasswordConfiguration config = new CompositePasswordConfiguration();
        if (editMode) {
            config.fromProperties(toEdit.configuration, this.msg);
        }
        this.configBinder.setBean((Object)config);
        FormLayout header = new FormLayout();
        header.addClassName(CssClassNames.MEDIUM_VAADIN_FORM_ITEM_LABEL.getName());
        header.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        header.addFormItem((Component)this.name, this.msg.getMessage("BaseAuthenticatorEditor.name", new Object[0]));
        header.addFormItem((Component)localCredentials, this.msg.getMessage("CompositePasswordAuthenticatorEditor.localCredentials", new Object[0]));
        header.addFormItem((Component)remoteAuthn, this.msg.getMessage("CompositePasswordAuthenticatorEditor.remoteAuthenticators", new Object[0]));
        VerticalLayout main = new VerticalLayout();
        main.setPadding(false);
        main.add(new Component[]{header, interactiveLoginSettings});
        return main;
    }

    private AccordionPanel buildInteractiveLoginSettingsSection() {
        FormLayout formLayout = new FormLayout();
        formLayout.addClassName(CssClassNames.MEDIUM_VAADIN_FORM_ITEM_LABEL.getName());
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        LocalizedTextFieldDetails retrievalName = new LocalizedTextFieldDetails(this.msg.getEnabledLocales().values(), this.msg.getLocale());
        retrievalName.setWidth(CSSVars.TEXT_FIELD_MEDIUM.value());
        this.configBinder.forField((HasValue)retrievalName).withConverter(I18nString::new, I18nString::getLocalizedMap).bind(CompositePasswordConfiguration::getRetrievalName, CompositePasswordConfiguration::setRetrievalName);
        formLayout.addFormItem((Component)retrievalName, this.msg.getMessage("CompositePasswordAuthenticatorEditor.passwordName", new Object[0]));
        return new AccordionPanel(this.msg.getMessage("BaseAuthenticatorEditor.interactiveLoginSettings", new Object[0]), (Component)formLayout);
    }

    private String getConfiguration() throws FormValidationException {
        if (this.configBinder.validate().hasErrors()) {
            throw new FormValidationException();
        }
        try {
            return ((CompositePasswordConfiguration)this.configBinder.getBean()).toProperties(this.msg);
        }
        catch (ConfigurationException e) {
            throw new FormValidationException("Invalid configuration of the composite-password verificator", (Throwable)e);
        }
    }

    public AuthenticatorDefinition getAuthenticatorDefinition() throws FormValidationException {
        return new AuthenticatorDefinition(this.getName(), "composite-password", this.getConfiguration(), null);
    }

    public static class CompositePasswordConfiguration {
        private I18nString retrievalName = new I18nString();
        private List<String> localCredentials = new ArrayList<String>();
        private List<SimpleAuthenticatorInfo> remoteAuthenticators = new ArrayList<SimpleAuthenticatorInfo>();

        public String toProperties(MessageSource msg) {
            Properties raw = new Properties();
            String prefix = "compositePassword.";
            int i = 1;
            if (this.localCredentials != null) {
                for (String credential : this.localCredentials) {
                    raw.put(prefix + "verificators." + i + ".verificatorType", CompositePasswordProperties.VerificatorTypes.password.toString());
                    raw.put(prefix + "verificators." + i + ".verificatorCredential", credential);
                    ++i;
                }
            }
            for (SimpleAuthenticatorInfo remoteAuth : this.remoteAuthenticators) {
                raw.put(prefix + "verificators." + i + ".verificatorName", remoteAuth.name);
                raw.put(prefix + "verificators." + i + ".verificatorType", remoteAuth.type.toString());
                raw.put(prefix + "verificators." + i + ".verificatorConfigEmbedded", remoteAuth.config);
                ++i;
            }
            if (this.getRetrievalName() != null) {
                this.getRetrievalName().toProperties(raw, "retrieval.password.name", msg);
            }
            CompositePasswordProperties prop = new CompositePasswordProperties(raw);
            return prop.getAsString();
        }

        public void fromProperties(String properties, MessageSource msg) {
            Properties raw = new Properties();
            try {
                raw.load(new StringReader(properties));
            }
            catch (IOException e) {
                throw new InternalException("Invalid configuration of the composite-password verificator", (Throwable)e);
            }
            CompositePasswordProperties compositePasswordProp = new CompositePasswordProperties(raw);
            this.localCredentials = new ArrayList<String>();
            Set verfKeys = compositePasswordProp.getStructuredListKeys("verificators.");
            for (String verfKey : verfKeys) {
                CompositePasswordProperties.VerificatorTypes type = (CompositePasswordProperties.VerificatorTypes)compositePasswordProp.getEnumValue(verfKey + "verificatorType", CompositePasswordProperties.VerificatorTypes.class);
                if (type.equals((Object)CompositePasswordProperties.VerificatorTypes.password)) {
                    this.localCredentials.add(compositePasswordProp.getValue(verfKey + "verificatorCredential"));
                    continue;
                }
                String name = compositePasswordProp.getValue(verfKey + "verificatorName");
                if (name == null) {
                    name = verfKey.split("\\.")[1];
                }
                String stringConfig = null;
                if (compositePasswordProp.isSet(verfKey + "verificatorConfig")) {
                    File config = compositePasswordProp.getFileValue(verfKey + "verificatorConfig", false);
                    stringConfig = this.getConfigFromFile(config);
                } else {
                    stringConfig = compositePasswordProp.getValue(verfKey + "verificatorConfigEmbedded");
                }
                this.remoteAuthenticators.add(new SimpleAuthenticatorInfo(type, name, stringConfig));
            }
            PasswordRetrievalProperties passwordRetrievalProperties = new PasswordRetrievalProperties(raw);
            this.setRetrievalName(passwordRetrievalProperties.getLocalizedStringWithoutFallbackToDefault(msg, "name"));
        }

        private String getConfigFromFile(File configFile) {
            try {
                return configFile == null ? null : FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new InternalException("Can not read remote authenticator config file", (Throwable)e);
            }
        }

        public I18nString getRetrievalName() {
            return this.retrievalName;
        }

        public void setRetrievalName(I18nString retrievalName) {
            this.retrievalName = retrievalName;
        }

        public List<String> getLocalCredentials() {
            return this.localCredentials;
        }

        public void setLocalCredentials(List<String> localCredentials) {
            this.localCredentials = localCredentials;
        }

        public List<SimpleAuthenticatorInfo> getRemoteAuthenticators() {
            return this.remoteAuthenticators;
        }

        public void setRemoteAuthenticators(List<SimpleAuthenticatorInfo> remoteAuthenticators) {
            this.remoteAuthenticators = remoteAuthenticators;
        }
    }

    private class RemoteAuthenticatorsComponent
    extends CustomField<List<SimpleAuthenticatorInfo>> {
        private GridWithActionColumn<SimpleAuthenticatorInfo> remoteAuthnGrid;
        private List<SimpleAuthenticatorInfo> remoteAuthnList;

        public RemoteAuthenticatorsComponent() {
            this.initUI();
        }

        protected List<SimpleAuthenticatorInfo> generateModelValue() {
            return this.getValue();
        }

        protected void setPresentationValue(List<SimpleAuthenticatorInfo> simpleAuthenticatorInfos) {
            this.setValue(simpleAuthenticatorInfos);
        }

        public void setValue(List<SimpleAuthenticatorInfo> authenticators) {
            this.remoteAuthnList.addAll(authenticators);
        }

        private void initUI() {
            VerticalLayout main = new VerticalLayout();
            main.setWidth("35em");
            main.setHeight("20em");
            main.setMargin(false);
            Button addPam = new Button(CompositePasswordAuthenticatorEditor.this.msg.getMessage("RemoteAuthenticatorsComponent.addPam", new Object[0]));
            addPam.addClickListener((ComponentEventListener & Serializable)e -> this.getAddButtonClickListener(CompositePasswordProperties.VerificatorTypes.pam));
            addPam.setIcon((Component)VaadinIcon.PLUS_CIRCLE_O.create());
            Button addLdap = new Button(CompositePasswordAuthenticatorEditor.this.msg.getMessage("RemoteAuthenticatorsComponent.addLdap", new Object[0]));
            addLdap.setIcon((Component)VaadinIcon.PLUS_CIRCLE_O.create());
            addLdap.addClickListener((ComponentEventListener & Serializable)e -> this.getAddButtonClickListener(CompositePasswordProperties.VerificatorTypes.ldap));
            HorizontalLayout buttons = new HorizontalLayout();
            buttons.setMargin(false);
            buttons.add(new Component[]{addPam, addLdap});
            main.add(new Component[]{buttons});
            main.setAlignItems(FlexComponent.Alignment.END);
            this.remoteAuthnList = new ArrayList<SimpleAuthenticatorInfo>();
            this.remoteAuthnGrid = new GridWithActionColumn(x$0 -> CompositePasswordAuthenticatorEditor.this.msg.getMessage(x$0, new Object[0]), this.getActionsHandlers());
            this.remoteAuthnGrid.enableRowReordering(() -> this.updateValue());
            this.remoteAuthnGrid.addColumn((ValueProvider & Serializable)t -> t.name).setHeader(CompositePasswordAuthenticatorEditor.this.msg.getMessage("RemoteAuthenticatorsComponent.name", new Object[0]));
            this.remoteAuthnGrid.addColumn((ValueProvider & Serializable)t -> t.type.toString()).setHeader(CompositePasswordAuthenticatorEditor.this.msg.getMessage("RemoteAuthenticatorsComponent.type", new Object[0]));
            this.remoteAuthnGrid.setItems(this.remoteAuthnList);
            main.add(new Component[]{this.remoteAuthnGrid});
            this.add(new Component[]{main});
        }

        private void getAddButtonClickListener(CompositePasswordProperties.VerificatorTypes forType) {
            this.gotoEditRemoteAuthSubView((AuthenticatorEditorFactory)(forType.equals((Object)CompositePasswordProperties.VerificatorTypes.ldap) ? CompositePasswordAuthenticatorEditor.this.ldapFactory : CompositePasswordAuthenticatorEditor.this.pamFactory), null, this.remoteAuthnList.stream().map(p -> p.name).collect(Collectors.toSet()), c -> {
                CompositePasswordAuthenticatorEditor.this.subViewSwitcher.exitSubViewAndShowUpdateInfo();
                this.remoteAuthnList.add(new SimpleAuthenticatorInfo(forType, c.id, c.configuration));
                this.remoteAuthnGrid.getDataProvider().refreshAll();
            });
        }

        private void gotoEditRemoteAuthSubView(AuthenticatorEditorFactory factory, SimpleAuthenticatorInfo authenticator, Set<String> names, Consumer<AuthenticatorDefinition> onConfirm) {
            EditRemoteAuthenticatorSubView subView = new EditRemoteAuthenticatorSubView(CompositePasswordAuthenticatorEditor.this.msg, factory, authenticator != null ? new AuthenticatorDefinition(authenticator.name, null, authenticator.config, null) : null, r -> {
                onConfirm.accept((AuthenticatorDefinition)r);
                this.fireChange();
                this.remoteAuthnGrid.focus();
            }, () -> {
                CompositePasswordAuthenticatorEditor.this.subViewSwitcher.exitSubView();
                this.remoteAuthnGrid.focus();
            }, CompositePasswordAuthenticatorEditor.this.subViewSwitcher, CompositePasswordAuthenticatorEditor.this.notificationPresenter);
            CompositePasswordAuthenticatorEditor.this.subViewSwitcher.goToSubView((UnitySubView)subView);
        }

        private List<SingleActionHandler<SimpleAuthenticatorInfo>> getActionsHandlers() {
            SingleActionHandler edit = SingleActionHandler.builder4Edit(x$0 -> CompositePasswordAuthenticatorEditor.this.msg.getMessage(x$0, new Object[0]), SimpleAuthenticatorInfo.class).withHandler(r -> {
                SimpleAuthenticatorInfo edited = (SimpleAuthenticatorInfo)r.iterator().next();
                this.gotoEditRemoteAuthSubView((AuthenticatorEditorFactory)(edited.type.equals((Object)CompositePasswordProperties.VerificatorTypes.ldap) ? CompositePasswordAuthenticatorEditor.this.ldapFactory : CompositePasswordAuthenticatorEditor.this.pamFactory), edited, this.remoteAuthnList.stream().filter(p -> !Objects.equals(p.name, edited.name)).map(p -> p.name).collect(Collectors.toSet()), c -> {
                    this.remoteAuthnList.remove(edited);
                    this.remoteAuthnList.add(new SimpleAuthenticatorInfo(edited.type, c.id, c.configuration));
                    CompositePasswordAuthenticatorEditor.this.subViewSwitcher.exitSubViewAndShowUpdateInfo();
                    this.remoteAuthnGrid.getDataProvider().refreshAll();
                });
            }).build();
            SingleActionHandler remove = SingleActionHandler.builder4Delete(x$0 -> CompositePasswordAuthenticatorEditor.this.msg.getMessage(x$0, new Object[0]), SimpleAuthenticatorInfo.class).withHandler(r -> {
                this.remoteAuthnList.remove(r.iterator().next());
                this.fireChange();
                this.remoteAuthnGrid.focus();
                this.remoteAuthnGrid.getDataProvider().refreshAll();
            }).build();
            SingleActionHandler reorder = new SingleActionHandler.Builder().withIcon(VaadinIcon.RESIZE_H).build();
            return Arrays.asList(reorder, edit, remove);
        }

        public List<SimpleAuthenticatorInfo> getValue() {
            return List.copyOf(this.remoteAuthnList);
        }

        private void fireChange() {
            this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, List.copyOf(this.remoteAuthnList), false));
        }
    }

    public record SimpleAuthenticatorInfo(CompositePasswordProperties.VerificatorTypes type, String name, String config) {
    }
}

