/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.composite.password.web;

import io.imunity.vaadin.auth.authenticators.AuthenticatorEditor;
import io.imunity.vaadin.auth.authenticators.AuthenticatorEditorFactory;
import io.imunity.vaadin.elements.NotificationPresenter;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.message.MessageSource;
import pl.edu.icm.unity.composite.password.web.CompositePasswordAuthenticatorEditor;
import pl.edu.icm.unity.engine.api.CredentialManagement;
import pl.edu.icm.unity.ldap.client.console.LdapAuthenticatorEditorFactory;
import pl.edu.icm.unity.pam.web.PamAuthenticatorEditorFactory;

@Component
class CompositePasswordAuthenticatorEditorFactory
implements AuthenticatorEditorFactory {
    private final MessageSource msg;
    private final CredentialManagement credMan;
    private final PamAuthenticatorEditorFactory pamFactory;
    private final LdapAuthenticatorEditorFactory ldapFactory;
    private final NotificationPresenter notificationPresenter;

    CompositePasswordAuthenticatorEditorFactory(MessageSource msg, CredentialManagement credMan, PamAuthenticatorEditorFactory pamFactory, LdapAuthenticatorEditorFactory ldapFactory, NotificationPresenter notificationPresenter) {
        this.msg = msg;
        this.credMan = credMan;
        this.pamFactory = pamFactory;
        this.ldapFactory = ldapFactory;
        this.notificationPresenter = notificationPresenter;
    }

    public String getSupportedAuthenticatorType() {
        return "composite-password";
    }

    public AuthenticatorEditor createInstance() throws EngineException {
        return new CompositePasswordAuthenticatorEditor(this.msg, this.credMan.getCredentialDefinitions(), this.pamFactory, this.ldapFactory, this.notificationPresenter);
    }
}

