/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.composite.password.web;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import io.imunity.vaadin.auth.authenticators.AuthenticatorEditor;
import io.imunity.vaadin.auth.authenticators.AuthenticatorEditorFactory;
import io.imunity.vaadin.elements.CssClassNames;
import io.imunity.vaadin.elements.NotificationPresenter;
import io.imunity.vaadin.endpoint.common.api.SubViewSwitcher;
import io.imunity.vaadin.endpoint.common.api.UnitySubView;
import io.imunity.vaadin.endpoint.common.exceptions.FormValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.base.exceptions.InternalException;
import pl.edu.icm.unity.base.message.MessageSource;
import pl.edu.icm.unity.composite.password.CompositePasswordProperties;
import pl.edu.icm.unity.engine.api.authn.AuthenticatorDefinition;

class EditRemoteAuthenticatorSubView
extends VerticalLayout
implements UnitySubView {
    private final MessageSource msg;
    private final AuthenticatorEditorFactory factory;
    private final AuthenticatorDefinition toEdit;
    private final boolean editMode;

    EditRemoteAuthenticatorSubView(MessageSource msg, AuthenticatorEditorFactory factory, AuthenticatorDefinition toEdit, Consumer<AuthenticatorDefinition> onConfirm, Runnable onCancel, SubViewSwitcher subViewSwitcher, NotificationPresenter notificationPresenter) {
        AuthenticatorEditor editor;
        this.msg = msg;
        this.factory = factory;
        this.toEdit = toEdit;
        this.editMode = toEdit != null;
        try {
            editor = factory.createInstance();
        }
        catch (EngineException e) {
            throw new InternalException("Can not create remote authenticator editor");
        }
        VerticalLayout mainView = new VerticalLayout();
        mainView.setMargin(false);
        mainView.add(new Component[]{editor.getEditor(toEdit, subViewSwitcher, true)});
        Button cancelButton = new Button(msg.getMessage("cancel", new Object[0]), (ComponentEventListener & Serializable)event -> onCancel.run());
        cancelButton.setWidthFull();
        Button updateButton = new Button(this.editMode ? msg.getMessage("update", new Object[0]) : msg.getMessage("create", new Object[0]), (ComponentEventListener & Serializable)event -> {
            try {
                onConfirm.accept(editor.getAuthenticatorDefinition());
            }
            catch (FormValidationException e) {
                notificationPresenter.showError(msg.getMessage("EditRemoteAuthenticatorSubView.invalid", new Object[0]), e.getMessage());
            }
        });
        updateButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        updateButton.setWidthFull();
        HorizontalLayout buttonsLayout = new HorizontalLayout(new Component[]{cancelButton, updateButton});
        buttonsLayout.setClassName(CssClassNames.EDIT_VIEW_ACTION_BUTTONS_LAYOUT.getName());
        mainView.add(new Component[]{buttonsLayout});
        this.add(new Component[]{mainView});
    }

    public List<String> getBreadcrumbs() {
        ArrayList<String> breadcrumbs = new ArrayList<String>();
        breadcrumbs.add(this.msg.getMessage("EditRemoteAuthenticatorSubView.caption", new Object[0]));
        breadcrumbs.add(this.factory.getSupportedAuthenticatorType().equals("pam") ? CompositePasswordProperties.VerificatorTypes.pam.toString() : CompositePasswordProperties.VerificatorTypes.ldap.toString());
        if (this.editMode) {
            breadcrumbs.add(this.toEdit.id);
        }
        return breadcrumbs;
    }
}

