/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.idp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.imunity.idp.AccessProtocol;
import io.imunity.idp.ApplicationId;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.Constants;
import pl.edu.icm.unity.base.attribute.Attribute;
import pl.edu.icm.unity.base.attribute.AttributeExt;
import pl.edu.icm.unity.base.entity.EntityParam;
import pl.edu.icm.unity.base.exceptions.EngineException;
import pl.edu.icm.unity.engine.api.AttributesManagement;
import pl.edu.icm.unity.engine.api.authn.InvocationContext;
import pl.edu.icm.unity.engine.api.authn.LoginSession;

@Component
public class LastIdPClinetAccessAttributeManagement {
    private final AttributesManagement attributesManagement;

    public LastIdPClinetAccessAttributeManagement(@Qualifier(value="insecure") AttributesManagement attributesManagement) {
        this.attributesManagement = attributesManagement;
    }

    public synchronized void setAttribute(EntityParam entity, AccessProtocol accessProtocol, ApplicationId clientId, Instant lastAccess) throws EngineException {
        Collection attributes = this.attributesManagement.getAttributes(entity, "/", "sys:idp:clientLastAccess");
        if (attributes.isEmpty()) {
            this.setAttribute(entity, Map.of(new LastIdPClientAccessKey(accessProtocol, clientId.id), lastAccess));
        } else {
            AttributeExt attr = (AttributeExt)attributes.iterator().next();
            Map<LastIdPClientAccessKey, Instant> value = this.getAttributeValue(attr);
            value.put(new LastIdPClientAccessKey(accessProtocol, clientId.id), lastAccess);
            this.setAttribute(entity, value);
        }
    }

    public Map<LastIdPClientAccessKey, Instant> getLastAccessByClient() throws EngineException {
        LoginSession entity = InvocationContext.getCurrent().getLoginSession();
        EntityParam entityParam = new EntityParam(Long.valueOf(entity.getEntityId()));
        Collection attributes = this.attributesManagement.getAttributes(entityParam, "/", "sys:idp:clientLastAccess");
        if (attributes.isEmpty()) {
            return new HashMap<LastIdPClientAccessKey, Instant>();
        }
        return this.getAttributeValue((AttributeExt)attributes.iterator().next());
    }

    private void setAttribute(EntityParam entity, Map<LastIdPClientAccessKey, Instant> value) throws EngineException {
        try {
            HashMap<String, Instant> toSave = new HashMap<String, Instant>();
            for (Map.Entry<LastIdPClientAccessKey, Instant> entry : value.entrySet()) {
                toSave.put(Constants.MAPPER.writeValueAsString((Object)entry.getKey()), entry.getValue());
            }
            this.attributesManagement.setAttribute(entity, new Attribute("sys:idp:clientLastAccess", "string", "/", List.of(Constants.MAPPER.writeValueAsString(toSave))));
        }
        catch (JsonProcessingException e) {
            throw new EngineException("Can not save idP last access attribute", (Throwable)e);
        }
    }

    private Map<LastIdPClientAccessKey, Instant> getAttributeValue(AttributeExt attr) throws EngineException {
        try {
            return (Map)Constants.MAPPER.readValue((String)attr.getValues().get(0), (TypeReference)new TypeReference<Map<LastIdPClientAccessKey, Instant>>(){});
        }
        catch (Exception e) {
            throw new EngineException("Can not get idP last access attribute", (Throwable)e);
        }
    }

    public static class LastIdPClientAccessKey {
        public final AccessProtocol accessProtocol;
        public final String clientId;

        @JsonCreator
        public LastIdPClientAccessKey(@JsonProperty(value="accessProtocol") AccessProtocol accessProtocol, @JsonProperty(value="clientId") String clientId) {
            this.accessProtocol = accessProtocol;
            this.clientId = clientId;
        }

        @JsonCreator
        public LastIdPClientAccessKey(String from) throws JsonMappingException, JsonProcessingException {
            LastIdPClientAccessKey readValue = (LastIdPClientAccessKey)Constants.MAPPER.readValue(from, (TypeReference)new TypeReference<LastIdPClientAccessKey>(){});
            this.accessProtocol = readValue.accessProtocol;
            this.clientId = readValue.clientId;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.accessProtocol, this.clientId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastIdPClientAccessKey other = (LastIdPClientAccessKey)obj;
            return this.accessProtocol == other.accessProtocol && Objects.equals(this.clientId, other.clientId);
        }
    }
}

