/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.pam;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jvnet.libpam.UnixUser;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAttribute;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteGroupMembership;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteIdentity;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;

public class LibPAMUtils {
    public static RemotelyAuthenticatedInput unixUser2RAI(UnixUser unixUser, String idp) {
        RemotelyAuthenticatedInput ret = new RemotelyAuthenticatedInput(idp);
        ArrayList<RemoteAttribute> attributes = new ArrayList<RemoteAttribute>();
        attributes.add(new RemoteAttribute("gid", new Object[]{unixUser.getGID()}));
        attributes.add(new RemoteAttribute("uid", new Object[]{unixUser.getUID()}));
        if (unixUser.getDir() != null) {
            attributes.add(new RemoteAttribute("home", new Object[]{unixUser.getDir()}));
        }
        if (unixUser.getGecos() != null) {
            attributes.addAll(LibPAMUtils.processGecos(unixUser.getGecos()));
        }
        if (unixUser.getShell() != null) {
            attributes.add(new RemoteAttribute("shell", new Object[]{unixUser.getShell()}));
        }
        ret.setAttributes(attributes);
        ret.setRawAttributes(ret.getAttributes());
        ret.setGroups(unixUser.getGroups().stream().map(RemoteGroupMembership::new).collect(Collectors.toList()));
        ret.setIdentities((List)Lists.newArrayList((Object[])new RemoteIdentity[]{new RemoteIdentity(unixUser.getUserName(), "userName")}));
        return ret;
    }

    static List<RemoteAttribute> processGecos(String gecos) {
        ArrayList<RemoteAttribute> attributes = new ArrayList<RemoteAttribute>();
        String[] elements = gecos.split(",");
        if (elements.length > 0 && !elements[0].isEmpty()) {
            attributes.add(new RemoteAttribute("name", new Object[]{elements[0]}));
        }
        if (elements.length > 1 && !elements[1].isEmpty()) {
            attributes.add(new RemoteAttribute("contact", new Object[]{elements[1]}));
        }
        if (elements.length > 2 && !elements[2].isEmpty()) {
            attributes.add(new RemoteAttribute("home-phone", new Object[]{elements[2]}));
        }
        if (elements.length > 3 && !elements[3].isEmpty()) {
            attributes.add(new RemoteAttribute("work-phone", new Object[]{elements[3]}));
        }
        if (elements.length > 4 && !elements[4].isEmpty()) {
            attributes.add(new RemoteAttribute("other", new Object[]{elements[4]}));
        }
        return attributes;
    }
}

