/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.pam;

import org.apache.logging.log4j.Logger;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.userimport.UserImportSPI;
import pl.edu.icm.unity.pam.LibPAMUtils;

public class OSImporter
implements UserImportSPI {
    private static final Logger log = Log.getLogger((String)"unity.server.pam", OSImporter.class);
    private String idpName;

    public OSImporter(String idpName) {
        this.idpName = idpName;
    }

    public RemotelyAuthenticatedInput importUser(String identity, String type) {
        if (!type.equals("userName") && !type.equals("identifier")) {
            log.warn("Can not import user of type " + type + " from local OS, only userName and identifier are supported.");
            return null;
        }
        try {
            UnixUser unixUser = new UnixUser(identity);
            return LibPAMUtils.unixUser2RAI(unixUser, this.idpName);
        }
        catch (PAMException e) {
            log.warn("Import of user " + identity + " from local OS failed, skipping", (Throwable)e);
            return null;
        }
    }
}

