/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.pam;

import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AbstractCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.CredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.RemoteAuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.remote.AbstractRemoteVerificator;
import pl.edu.icm.unity.engine.api.authn.remote.AuthenticationTriggeringContext;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnResponseProcessor;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnResultTranslator;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.pam.LibPAMUtils;
import pl.edu.icm.unity.pam.PAMProperties;
import pl.edu.icm.unity.stdext.credential.NoCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.pass.PasswordExchange;
import pl.edu.icm.unity.types.translation.TranslationProfile;

@PrototypeComponent
public class PAMVerificator
extends AbstractRemoteVerificator
implements PasswordExchange {
    private static final AuthenticationResult.ResolvableError GENERIC_ERROR = new AuthenticationResult.ResolvableError("WebPasswordRetrieval.wrongPassword", new Object[0]);
    private static final Logger log = Log.getLogger((String)"unity.server.pam", PAMVerificator.class);
    public static final String NAME = "pam";
    public static final String IDP = "PAM";
    public static final String DESCRIPTION = "Verifies passwords using local OS PAM facility";
    private final RemoteAuthnResponseProcessor remoteAuthnProcessor;
    private PAMProperties pamProperties;
    private TranslationProfile translationProfile;

    @Autowired
    public PAMVerificator(RemoteAuthnResultTranslator translator, RemoteAuthnResponseProcessor remoteAuthnProcessor) {
        super(NAME, DESCRIPTION, "password exchange", translator);
        this.remoteAuthnProcessor = remoteAuthnProcessor;
    }

    public String getSerializedConfiguration() {
        StringWriter sbw = new StringWriter();
        try {
            this.pamProperties.getProperties().store(sbw, "");
        }
        catch (IOException e) {
            throw new InternalException("Can't serialize PAM verificator configuration", (Throwable)e);
        }
        return sbw.toString();
    }

    public void setSerializedConfiguration(String config) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(config));
            this.pamProperties = new PAMProperties(properties);
            this.translationProfile = PAMVerificator.getTranslationProfile((UnityPropertiesHelper)this.pamProperties, (String)"translationProfile", (String)"embeddedTranslationProfile");
        }
        catch (ConfigurationException e) {
            throw new InternalException("Invalid configuration of the PAM verificator", (Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException("Invalid configuration of the PAM verificator(?)", (Throwable)e);
        }
    }

    public AuthenticationResult checkPassword(String username, String password, String formForUnknown, boolean enableAssociation, AuthenticationTriggeringContext triggeringContext) {
        Supplier<AuthenticationResult> verificator = () -> this.authenticate(username, password, formForUnknown, enableAssociation, triggeringContext);
        return this.remoteAuthnProcessor.executeVerificator(verificator, triggeringContext);
    }

    private AuthenticationResult authenticate(String username, String password, String formForUnknown, boolean enableAssociation, AuthenticationTriggeringContext triggeringContext) {
        try {
            RemotelyAuthenticatedInput input = this.getRemotelyAuthenticatedInput(username, password);
            RemoteAuthenticationResult result = this.getResult(input, this.translationProfile, triggeringContext.isSandboxTriggered(), formForUnknown, enableAssociation);
            return this.addGenericMessageIfError(result, GENERIC_ERROR);
        }
        catch (Exception e) {
            if (e instanceof AuthenticationException) {
                log.info("PAM authentication failed", (Throwable)e);
            } else {
                log.warn("PAM authentication failed", (Throwable)e);
            }
            return RemoteAuthenticationResult.failed(null, (Exception)e, (AuthenticationResult.ResolvableError)GENERIC_ERROR);
        }
    }

    private RemotelyAuthenticatedInput getRemotelyAuthenticatedInput(String username, String password) throws AuthenticationException, PAMException {
        PAM pam = new PAM("unity");
        try {
            UnixUser unixUser = pam.authenticate(username, password);
            return LibPAMUtils.unixUser2RAI(unixUser, IDP);
        }
        catch (PAMException e) {
            throw new AuthenticationException("PAM authentication failed", (Exception)((Object)e));
        }
    }

    public CredentialReset getCredentialResetBackend() {
        return new NoCredentialResetImpl();
    }

    public CredentialVerificator.VerificatorType getType() {
        return CredentialVerificator.VerificatorType.Remote;
    }

    @Component
    public static class Factory
    extends AbstractCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<PAMVerificator> factory) {
            super(PAMVerificator.NAME, PAMVerificator.DESCRIPTION, factory);
        }
    }
}

