/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.pam;

import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AbstractCredentialVerificatorFactory;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.engine.api.authn.AuthenticationResult;
import pl.edu.icm.unity.engine.api.authn.CredentialReset;
import pl.edu.icm.unity.engine.api.authn.CredentialVerificator;
import pl.edu.icm.unity.engine.api.authn.remote.AbstractRemoteVerificator;
import pl.edu.icm.unity.engine.api.authn.remote.RemoteAuthnResultProcessor;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.authn.remote.SandboxAuthnResultCallback;
import pl.edu.icm.unity.engine.api.config.UnityPropertiesHelper;
import pl.edu.icm.unity.engine.api.utils.PrototypeComponent;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.pam.LibPAMUtils;
import pl.edu.icm.unity.pam.PAMProperties;
import pl.edu.icm.unity.stdext.credential.NoCredentialResetImpl;
import pl.edu.icm.unity.stdext.credential.pass.PasswordExchange;
import pl.edu.icm.unity.types.translation.TranslationProfile;

@PrototypeComponent
public class PAMVerificator
extends AbstractRemoteVerificator
implements PasswordExchange {
    private static final Logger log = Log.getLogger((String)"unity.server.pam", PAMVerificator.class);
    public static final String NAME = "pam";
    public static final String IDP = "PAM";
    public static final String DESCRIPTION = "Verifies passwords using local OS PAM facility";
    private PAMProperties pamProperties;
    private TranslationProfile translationProfile;

    @Autowired
    public PAMVerificator(RemoteAuthnResultProcessor processor) {
        super(NAME, DESCRIPTION, "password exchange", processor);
    }

    public String getSerializedConfiguration() {
        StringWriter sbw = new StringWriter();
        try {
            this.pamProperties.getProperties().store(sbw, "");
        }
        catch (IOException e) {
            throw new InternalException("Can't serialize PAM verificator configuration", (Throwable)e);
        }
        return sbw.toString();
    }

    public void setSerializedConfiguration(String config) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(config));
            this.pamProperties = new PAMProperties(properties);
            this.translationProfile = PAMVerificator.getTranslationProfile((UnityPropertiesHelper)this.pamProperties, (String)"translationProfile", (String)"embeddedTranslationProfile");
        }
        catch (ConfigurationException e) {
            throw new InternalException("Invalid configuration of the PAM verificator", (Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException("Invalid configuration of the PAM verificator(?)", (Throwable)e);
        }
    }

    public AuthenticationResult checkPassword(String username, String password, SandboxAuthnResultCallback sandboxCallback) {
        AbstractRemoteVerificator.RemoteAuthnState state = this.startAuthnResponseProcessing(sandboxCallback, new String[]{"unity.server.externaltranslation", "unity.server.pam"});
        try {
            RemotelyAuthenticatedInput input = this.getRemotelyAuthenticatedInput(username, password);
            return this.getResult(input, this.translationProfile, state);
        }
        catch (Exception e) {
            if (e instanceof AuthenticationException) {
                log.debug("PAM authentication failed", (Throwable)e);
            } else {
                log.warn("PAM authentication failed", (Throwable)e);
            }
            this.finishAuthnResponseProcessing(state, e);
            return new AuthenticationResult(AuthenticationResult.Status.deny, null, null);
        }
    }

    private RemotelyAuthenticatedInput getRemotelyAuthenticatedInput(String username, String password) throws AuthenticationException, PAMException {
        PAM pam = new PAM("unity");
        try {
            UnixUser unixUser = pam.authenticate(username, password);
            return LibPAMUtils.unixUser2RAI(unixUser, IDP);
        }
        catch (PAMException e) {
            throw new AuthenticationException("PAM authentication failed", (Exception)((Object)e));
        }
    }

    public CredentialReset getCredentialResetBackend() {
        return new NoCredentialResetImpl();
    }

    public CredentialVerificator.VerificatorType getType() {
        return CredentialVerificator.VerificatorType.Remote;
    }

    @Component
    public static class Factory
    extends AbstractCredentialVerificatorFactory {
        @Autowired
        public Factory(ObjectFactory<PAMVerificator> factory) {
            super(PAMVerificator.NAME, PAMVerificator.DESCRIPTION, factory);
        }
    }
}

