/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unity.pam.web;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import eu.unicore.util.configuration.ConfigurationException;
import io.imunity.webconsole.utils.tprofile.InputTranslationProfileFieldFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.translation.TranslationProfileGenerator;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.pam.PAMProperties;
import pl.edu.icm.unity.types.I18nString;
import pl.edu.icm.unity.types.authn.AuthenticatorDefinition;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.webui.authn.authenticators.AuthenticatorEditor;
import pl.edu.icm.unity.webui.authn.authenticators.BaseAuthenticatorEditor;
import pl.edu.icm.unity.webui.authn.extensions.PasswordRetrievalProperties;
import pl.edu.icm.unity.webui.common.CollapsibleLayout;
import pl.edu.icm.unity.webui.common.FormLayoutWithFixedCaptionWidth;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.i18n.I18nTextField;
import pl.edu.icm.unity.webui.common.webElements.SubViewSwitcher;

class PamAuthenticatorEditor
extends BaseAuthenticatorEditor
implements AuthenticatorEditor {
    private List<String> registrationForms;
    private InputTranslationProfileFieldFactory profileFieldFactory;
    private Binder<PamConfiguration> configBinder;

    PamAuthenticatorEditor(MessageSource msg, List<String> registrationForms, InputTranslationProfileFieldFactory profileFieldFactory) {
        super(msg);
        this.registrationForms = registrationForms;
        this.profileFieldFactory = profileFieldFactory;
    }

    public Component getEditor(AuthenticatorDefinition toEdit, SubViewSwitcher subViewSwitcher, boolean forceNameEditable) {
        boolean editMode = this.init(this.msg.getMessage("PamAuthenticatorEditor.defaultName", new Object[0]), toEdit, forceNameEditable);
        this.configBinder = new Binder(PamConfiguration.class);
        FormLayoutWithFixedCaptionWidth header = this.buildHeaderSection();
        CollapsibleLayout interactiveLoginSettings = this.buildInteractiveLoginSettingsSection();
        CollapsibleLayout remoteDataMapping = this.profileFieldFactory.getWrappedFieldInstance(subViewSwitcher, this.configBinder, "translationProfile");
        VerticalLayout mainView = new VerticalLayout();
        mainView.setMargin(false);
        mainView.addComponent((Component)header);
        mainView.addComponent((Component)remoteDataMapping);
        mainView.addComponent((Component)interactiveLoginSettings);
        PamConfiguration config = new PamConfiguration();
        if (editMode) {
            config.fromProperties(toEdit.configuration, this.msg);
        }
        this.configBinder.setBean((Object)config);
        return mainView;
    }

    private FormLayoutWithFixedCaptionWidth buildHeaderSection() {
        TextField pamFacility = new TextField(this.msg.getMessage("PamAuthenticatorEditor.pamFacility", new Object[0]));
        this.configBinder.forField((HasValue)pamFacility).asRequired(this.msg.getMessage("fieldRequired", new Object[0])).bind("pamFacility");
        FormLayoutWithFixedCaptionWidth header = new FormLayoutWithFixedCaptionWidth();
        header.setMargin(true);
        header.addComponent((Component)this.name);
        header.addComponent((Component)pamFacility);
        return header;
    }

    private CollapsibleLayout buildInteractiveLoginSettingsSection() {
        FormLayoutWithFixedCaptionWidth interactiveLoginSettings = new FormLayoutWithFixedCaptionWidth();
        interactiveLoginSettings.setMargin(false);
        I18nTextField retrievalName = new I18nTextField(this.msg);
        retrievalName.setCaption(this.msg.getMessage("PamAuthenticatorEditor.displayedName", new Object[0]));
        this.configBinder.forField((HasValue)retrievalName).bind("retrievalName");
        interactiveLoginSettings.addComponent((Component)retrievalName);
        CheckBox accountAssociation = new CheckBox(this.msg.getMessage("PamAuthenticatorEditor.accountAssociation", new Object[0]));
        this.configBinder.forField((HasValue)accountAssociation).bind("accountAssociation");
        interactiveLoginSettings.addComponent((Component)accountAssociation);
        ComboBox registrationForm = new ComboBox(this.msg.getMessage("PamAuthenticatorEditor.registrationForm", new Object[0]));
        registrationForm.setItems(this.registrationForms);
        this.configBinder.forField((HasValue)registrationForm).bind("registrationForm");
        interactiveLoginSettings.addComponent((Component)registrationForm);
        return new CollapsibleLayout(this.msg.getMessage("BaseAuthenticatorEditor.interactiveLoginSettings", new Object[0]), (Layout)interactiveLoginSettings);
    }

    public AuthenticatorDefinition getAuthenticatorDefiniton() throws FormValidationException {
        return new AuthenticatorDefinition(this.getName(), "pam", this.getConfiguration(), null);
    }

    private String getConfiguration() throws FormValidationException {
        if (this.configBinder.validate().hasErrors()) {
            throw new FormValidationException();
        }
        try {
            return ((PamConfiguration)this.configBinder.getBean()).toProperties(this.msg);
        }
        catch (ConfigurationException e) {
            throw new FormValidationException("Invalid configuration of the pam verificator", (Throwable)e);
        }
    }

    public class PamConfiguration {
        private I18nString retrievalName;
        private String pamFacility;
        private TranslationProfile translationProfile = TranslationProfileGenerator.generateEmbeddedEmptyInputProfile();
        private boolean accountAssociation;
        private String registrationForm;

        public String toProperties(MessageSource msg) {
            Properties raw = new Properties();
            raw.put("pam.facility", this.pamFacility);
            raw.put("pam.translationProfile", this.translationProfile.getName());
            if (this.getRetrievalName() != null) {
                this.getRetrievalName().toProperties(raw, "retrieval.password.name", msg);
            }
            raw.put("retrieval.password.enableAssociation", String.valueOf(this.isAccountAssociation()));
            if (this.getRegistrationForm() != null) {
                raw.put("retrieval.password.registrationFormForUnknown", this.getRegistrationForm());
            }
            try {
                raw.put("pam.embeddedTranslationProfile", Constants.MAPPER.writeValueAsString((Object)this.getTranslationProfile().toJsonObject()));
            }
            catch (Exception e) {
                throw new InternalException("Can't serialize authenticator translation profile to JSON", (Throwable)e);
            }
            PAMProperties prop = new PAMProperties(raw);
            return prop.getAsString();
        }

        public void fromProperties(String source, MessageSource msg) {
            Properties raw = new Properties();
            try {
                raw.load(new StringReader(source));
            }
            catch (IOException e) {
                throw new InternalException("Invalid configuration of the pam verificator", (Throwable)e);
            }
            PAMProperties pamProp = new PAMProperties(raw);
            this.setPamFacility(pamProp.getValue("facility"));
            if (pamProp.isSet("embeddedTranslationProfile")) {
                this.setTranslationProfile(TranslationProfileGenerator.getProfileFromString((String)pamProp.getValue("embeddedTranslationProfile")));
            } else {
                this.setTranslationProfile(TranslationProfileGenerator.generateIncludeInputProfile((String)pamProp.getValue("translationProfile")));
            }
            PasswordRetrievalProperties passwordRetrievalProperties = new PasswordRetrievalProperties(raw);
            this.setRetrievalName(passwordRetrievalProperties.getLocalizedStringWithoutFallbackToDefault(msg, "name"));
            this.setAccountAssociation(passwordRetrievalProperties.getBooleanValue("enableAssociation"));
            this.setRegistrationForm(passwordRetrievalProperties.getValue("registrationFormForUnknown"));
        }

        public I18nString getRetrievalName() {
            return this.retrievalName;
        }

        public void setRetrievalName(I18nString retrivalName) {
            this.retrievalName = retrivalName;
        }

        public String getPamFacility() {
            return this.pamFacility;
        }

        public void setPamFacility(String pamFacility) {
            this.pamFacility = pamFacility;
        }

        public TranslationProfile getTranslationProfile() {
            return this.translationProfile;
        }

        public void setTranslationProfile(TranslationProfile translationProfile) {
            this.translationProfile = translationProfile;
        }

        public boolean isAccountAssociation() {
            return this.accountAssociation;
        }

        public void setAccountAssociation(boolean accountAssociation) {
            this.accountAssociation = accountAssociation;
        }

        public String getRegistrationForm() {
            return this.registrationForm;
        }

        public void setRegistrationForm(String registrationForm) {
            this.registrationForm = registrationForm;
        }
    }
}

